/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.VirtualHost;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Jar;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class WarExpansion {
    static L10N L = new L10N(class$com$caucho$server$http$WarExpansion == null ? (class$com$caucho$server$http$WarExpansion = WarExpansion.class$("com.caucho.server.http.WarExpansion")) : class$com$caucho$server$http$WarExpansion);
    static WriteStream dbg = LogStream.open("/caucho.com/http/host/war");
    static WriteStream dbgLife = LogStream.open("/caucho.com/http/lifecycle");
    private static Object LOCK = new Object();
    private VirtualHost host;
    private String[] warExpandFileNames = new String[0];
    static /* synthetic */ Class class$com$caucho$server$http$WarExpansion;

    WarExpansion(VirtualHost host) {
        this.host = host;
    }

    public Path getWarDir() {
        return this.host.getWarDir();
    }

    public Path getWarExpandDir() {
        return this.host.getWarExpandDir();
    }

    void initWarDir() throws Exception {
        ArrayList appNames = new ArrayList();
        Path warDir = this.getWarDir();
        Path warExpandDir = this.getWarExpandDir();
        if (warDir.isDirectory()) {
            String[] list = warDir.list();
            for (int i = 0; i < list.length; ++i) {
                Path war;
                if (!list[i].endsWith(".war") || !(war = warDir.lookup(list[i])).canRead()) continue;
                String tail = war.getTail();
                int p = tail.lastIndexOf(46);
                if (p >= 0) {
                    tail = tail.substring(0, p);
                }
                try {
                    WarExpansion.expandWar(war, warExpandDir, tail);
                    continue;
                }
                catch (Exception e) {
                    this.host.log(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void expandWar(Path war, Path warDir, String subpath) throws IOException {
        if (subpath == null) {
            subpath = warDir.getTail();
            warDir = warDir.getParent();
        }
        if (!war.canRead()) {
            return;
        }
        if (CauchoSystem.isCaseInsensitive()) {
            subpath = subpath.toLowerCase();
        }
        Path expandDir = warDir.lookup(subpath);
        Path tempDir = warDir.lookup("._" + subpath);
        Path dependPath = expandDir.lookup("WEB-INF/resin-war.timestamp");
        Object object = LOCK;
        synchronized (object) {
            if (dependPath.canRead()) {
                try {
                    ReadStream is = dependPath.openRead();
                    ObjectInputStream ois = new ObjectInputStream(is);
                    long lastModified = ois.readLong();
                    long length = ois.readLong();
                    ois.close();
                    is.close();
                    if (lastModified == war.getLastModified() && length == war.getLength()) {
                        return;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                ZipEntry entry;
                if (dbgLife.canWrite()) {
                    dbgLife.log("expanding war " + war + " to " + tempDir);
                }
                if (!tempDir.equals(expandDir)) {
                    WarExpansion.removeAll(tempDir);
                }
                tempDir.mkdirs();
                ReadStream rs = war.openRead();
                ZipInputStream zis = new ZipInputStream(rs);
                byte[] buffer = new byte[1024];
                while ((entry = zis.getNextEntry()) != null) {
                    String name = entry.getName();
                    Path path = tempDir.lookup(name);
                    if (entry.isDirectory()) {
                        try {
                            path.mkdirs();
                        }
                        catch (IOException e) {
                            dbg.log(e);
                        }
                        continue;
                    }
                    long length = entry.getSize();
                    long lastModified = entry.getTime();
                    path.getParent().mkdirs();
                    WriteStream os = path.openWrite();
                    try {
                        int len;
                        while ((len = zis.read(buffer, 0, buffer.length)) > 0) {
                            os.write(buffer, 0, len);
                        }
                    }
                    catch (IOException e) {
                        dbg.log(e);
                    }
                    finally {
                        os.close();
                    }
                    if (lastModified <= 0L) continue;
                    path.setLastModified(lastModified);
                }
                zis.close();
                rs.close();
                if (tempDir != expandDir) {
                    if (dbgLife.canWrite()) {
                        dbgLife.log("moving old war " + war + " from " + expandDir);
                    }
                    Jar.clearJarCache();
                    WarExpansion.removeAll(expandDir);
                    WarExpansion.moveAll(tempDir, expandDir);
                    WarExpansion.removeAll(tempDir);
                }
            }
            catch (IOException e) {
                dbg.log(e);
                return;
            }
        }
        try {
            dependPath.getParent().mkdirs();
            WriteStream os = dependPath.openWrite();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeLong(war.getLastModified());
            oos.writeLong(war.getLength());
            oos.close();
            os.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            dbg.log(e);
        }
    }

    private static void removeAll(Path path) {
        try {
            if (path.isDirectory()) {
                if (path.getPath().endsWith("WEB-INF/sessions")) {
                    return;
                }
                String[] list = path.list();
                for (int i = 0; list != null && i < list.length; ++i) {
                    WarExpansion.removeAll(path.lookup(list[i]));
                }
            } else if (path.getPath().endsWith("WEB-INF/resin-web.xml")) {
                return;
            }
            path.remove();
        }
        catch (Throwable e) {
            dbg.log(e);
        }
    }

    private static void moveAll(Path source, Path target) {
        block6: {
            try {
                if (source.isDirectory()) {
                    try {
                        target.mkdirs();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    String[] list = source.list();
                    for (int i = 0; list != null && i < list.length; ++i) {
                        WarExpansion.moveAll(source.lookup(list[i]), target.lookup(list[i]));
                    }
                    break block6;
                }
                source.renameTo(target);
            }
            catch (IOException e) {
                dbg.log(e);
            }
        }
    }

    boolean isModified() {
        try {
            ArrayList oldWars = this.getDeletedWars();
            if (oldWars.size() > 0) {
                dbgLife.log("war-dir changed with deleted files: " + oldWars);
                return true;
            }
            ArrayList newWars = this.getNewWars(false);
            if (newWars.size() > 0) {
                dbgLife.log("war-dir changed with new files: " + newWars);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            dbg.log(e);
            return false;
        }
    }

    ArrayList getDeletedWars() throws IOException {
        ArrayList<String> oldWars = new ArrayList<String>();
        Path warDir = this.getWarDir();
        Path warExpandDir = this.getWarExpandDir();
        if (warDir == null || warExpandDir == null) {
            return oldWars;
        }
        String[] warExpandList = warExpandDir.list();
        block0: for (int i = 0; i < this.warExpandFileNames.length; ++i) {
            String appName = this.warExpandFileNames[i];
            for (int j = 0; j < warExpandList.length; ++j) {
                if (CauchoSystem.isCaseInsensitive() ? warExpandList[j].equalsIgnoreCase(appName) : warExpandList[j].equals(appName)) continue block0;
            }
            if (oldWars.contains(appName)) continue;
            oldWars.add(appName);
        }
        return oldWars;
    }

    ArrayList getNewWars(boolean setExpandNames) throws IOException {
        ArrayList<String> newWars = new ArrayList<String>();
        Path warDir = this.getWarDir();
        Path warExpandDir = this.getWarExpandDir();
        if (warDir == null || warExpandDir == null) {
            return newWars;
        }
        String[] warDirList = warDir.list();
        block0: for (int i = 0; i < warDirList.length; ++i) {
            Path path;
            String warName = warDirList[i];
            if (!warName.endsWith(".war") && !warName.endsWith(".jar") || !(path = warDir.lookup(warName)).canRead()) continue;
            String appName = warName.substring(0, warName.length() - 4);
            if (CauchoSystem.isCaseInsensitive()) {
                appName = appName.toLowerCase();
            }
            for (int j = 0; j < this.warExpandFileNames.length; ++j) {
                if (appName.equals(this.warExpandFileNames[j])) continue block0;
            }
            if (newWars.contains(appName)) continue;
            newWars.add(appName);
        }
        String[] warExpandList = warExpandDir.list();
        ArrayList<String> newNames = new ArrayList<String>();
        block2: for (int i = 0; i < warExpandList.length; ++i) {
            Path path;
            String appName = warExpandList[i];
            if (CauchoSystem.isCaseInsensitive()) {
                appName = appName.toLowerCase();
            }
            if (!(path = warExpandDir.lookup(appName)).isDirectory() || appName.startsWith(".") || appName.equalsIgnoreCase("web-inf") || appName.equalsIgnoreCase("meta-inf")) continue;
            if (!newNames.contains(appName)) {
                newNames.add(appName);
            }
            for (int j = 0; j < this.warExpandFileNames.length; ++j) {
                if (appName.equals(this.warExpandFileNames[j])) continue block2;
            }
            if (newWars.contains(appName)) continue;
            newWars.add(appName);
        }
        if (setExpandNames) {
            this.warExpandFileNames = newNames.toArray(new String[newNames.size()]);
        }
        return newWars;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

