/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.DBPool;
import com.caucho.sql.QPooledConnectionImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class QPooledConnection
implements PooledConnection {
    protected static WriteStream dbg = LogStream.open("/caucho.com/sql/pool");
    protected static L10N L = new L10N("com/caucho/sql/messages");
    protected DBPool _pool;
    protected Connection _conn;
    private ArrayList _listeners = new ArrayList();
    private int _oldIsolation = -1;
    private int _isolation = -1;

    QPooledConnection(DBPool pool, Connection conn) {
        if (conn == null) {
            throw new NullPointerException();
        }
        this._pool = pool;
        this._conn = conn;
    }

    public Connection getConnection() throws SQLException {
        if (this._conn == null) {
            throw new SQLException("connection is closed");
        }
        return new QPooledConnectionImpl(this._pool, this._conn, this);
    }

    public void setIsolation(int isolation) throws SQLException {
        if (this._oldIsolation < 0) {
            this._oldIsolation = this._conn.getTransactionIsolation();
            this._isolation = isolation;
            this._conn.setTransactionIsolation(isolation);
        } else if (this._isolation < isolation) {
            throw new SQLException(L.l("can't change to more restrictive isolation in the middle of a transaction."));
        }
    }

    public void resetIsolation() throws SQLException {
        int oldIsolation = this._oldIsolation;
        this._isolation = -1;
        this._oldIsolation = -1;
        if (oldIsolation >= 0) {
            this._conn.setTransactionIsolation(oldIsolation);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this._listeners.remove(listener);
    }

    void fatalEvent(Connection conn) {
        ConnectionEvent event = new ConnectionEvent(this, new SQLException("foo"));
        for (int i = 0; i < this._listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this._listeners.get(i);
            listener.connectionErrorOccurred(event);
        }
    }

    void closeEvent(Connection conn) {
        ConnectionEvent event = new ConnectionEvent(this);
        for (int i = 0; i < this._listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this._listeners.get(i);
            listener.connectionClosed(event);
        }
    }

    public void close() throws SQLException {
        Connection conn = this._conn;
        this._conn = null;
        if (conn != null) {
            conn.close();
        }
    }
}

