/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.OldByteToChar;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class ByteToChar
extends InputStream {
    private CharBuffer charBuffer = new CharBuffer();
    private static boolean isOldJdk = !CauchoSystem.isJdk12();
    private Reader readEncoding;
    private String readEncodingName;
    private int specialEncoding;
    private byte[] byteBuffer = new byte[256];
    private int byteHead;
    private int byteTail;

    ByteToChar() {
    }

    public static ByteToChar create() {
        if (isOldJdk) {
            return new OldByteToChar();
        }
        return new ByteToChar();
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        this.readEncoding = Encoding.getReadEncoding(this, encoding);
        this.readEncodingName = Encoding.getMimeName(encoding);
    }

    public void clear() {
        this.charBuffer.clear();
        this.byteHead = 0;
        this.byteTail = 0;
    }

    public String getConvertedString() throws IOException {
        int ch;
        while ((ch = this.readChar()) >= 0) {
            this.charBuffer.append((char)ch);
        }
        return this.charBuffer.toString();
    }

    public void addByte(int b) throws IOException {
        int ch;
        int nextHead = (this.byteHead + 1) % this.byteBuffer.length;
        while (nextHead == this.byteTail && (ch = this.readChar()) >= 0) {
            this.charBuffer.append((char)ch);
        }
        this.byteBuffer[this.byteHead] = (byte)b;
        this.byteHead = nextHead;
    }

    public void addChar(char nextCh) throws IOException {
        int ch;
        while ((ch = this.readChar()) >= 0) {
            this.charBuffer.append((char)ch);
        }
        this.charBuffer.append(nextCh);
    }

    private int readChar() throws IOException {
        if (this.readEncoding == null) {
            return this.read();
        }
        return this.readEncoding.read();
    }

    public int read() throws IOException {
        if (this.byteHead == this.byteTail) {
            return -1;
        }
        int b = this.byteBuffer[this.byteTail] & 0xFF;
        this.byteTail = (this.byteTail + 1) % this.byteBuffer.length;
        return b;
    }

    public String toString() {
        try {
            return this.getConvertedString();
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(e));
        }
    }
}

