/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.el.SystemPropertiesResolver;
import com.caucho.util.ChangeListener;
import com.caucho.util.QDate;
import com.caucho.util.Registry;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Path;
import com.caucho.vfs.RotateStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.Iterator;

public class LogStream
extends StreamImpl
implements ChangeListener {
    private static int changeCount;
    private String logId;
    private byte[] idBuf;
    private RotateStream dest;
    private String timestampFormat;
    private QDate calendar;
    private boolean doLogId;

    LogStream(String logId) {
        if (logId.charAt(logId.length() - 1) != '/') {
            logId = logId + '/';
        }
        this.logId = logId;
        this.idBuf = (logId + ": ").getBytes();
        this.calendar = new QDate();
        changeCount = Registry.getChangeCount();
        this.init();
        Registry.addListener(this);
    }

    public void setDoLogId(boolean logId) {
        this.doLogId = logId;
    }

    public void handleChange(Object object) {
        this.dest = null;
        this.init();
    }

    private void init() {
        RegistryNode root = Registry.lookup("/caucho.com");
        if (root == null) {
            return;
        }
        SystemPropertiesResolver var = new SystemPropertiesResolver();
        String bestId = "/";
        RegistryNode bestNode = null;
        Iterator iter = root.select("log");
        while (iter.hasNext()) {
            RegistryNode node = (RegistryNode)iter.next();
            String id = node.getValue();
            if (id == null) {
                id = "/";
            } else if (id.length() == 0 || id.charAt(id.length() - 1) != '/') {
                id = id + '/';
            }
            if (!this.logId.startsWith(id) || !id.startsWith(bestId)) continue;
            bestId = id;
            bestNode = node;
        }
        if (bestNode == null) {
            return;
        }
        String bestHref = bestNode.getPath("href", null);
        if (bestHref == null) {
            return;
        }
        if (bestNode.lookup("timestamp") != null) {
            try {
                this.timestampFormat = bestNode.getELString("timestamp", "[%Y/%m/%d %H:%M:%S]", var);
            }
            catch (RegistryException e) {
                // empty catch block
            }
        }
        Path path = Vfs.lookupNative(bestHref);
        try {
            path.getParent().mkdirs();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.dest = RotateStream.create(path);
        try {
            long period;
            int size;
            int maxRollover = bestNode.getInt("rollover-count", -1);
            if (maxRollover > 0) {
                this.dest.setMaxRolloverCount(maxRollover);
            }
            if ((size = bestNode.getInt("rollover-size", -1)) > 0) {
                this.dest.setRolloverSize(size);
            }
            if ((period = bestNode.getPeriod("rollover-period", -1L)) > 0L) {
                this.dest.setRolloverPeriod(period);
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
    }

    public static WriteStream open(String logId) {
        LogStream log = new LogStream(logId);
        WriteStream stream = new WriteStream(log);
        stream.setFlushOnNewline(true);
        return stream;
    }

    public static WriteStream openQuiet(String logId) {
        LogStream log = new LogStream(logId);
        log.setDoLogId(false);
        WriteStream stream = new WriteStream(log);
        stream.setFlushOnNewline(true);
        return stream;
    }

    public final boolean canWrite() {
        return this.dest != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        RotateStream dest = this.dest;
        if (dest == null) {
            return;
        }
        WriteStream os = dest.getStream();
        if (os == null) {
            return;
        }
        WriteStream writeStream = os;
        synchronized (writeStream) {
            if (this.timestampFormat != null) {
                this.calendar.calculate(System.currentTimeMillis(), true);
                String date = this.calendar.format(this.timestampFormat);
                byte[] bytes = date.getBytes();
                os.write(bytes, 0, bytes.length);
                os.print(' ');
            }
            if (this.doLogId) {
                os.write(this.idBuf, 0, this.idBuf.length);
            }
            os.write(buf, offset, length);
            os.flush();
        }
    }

    public void flush() {
    }

    public void close() {
    }

    public void destroy() {
        Registry.removeListener(this);
    }
}

