/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TcpPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

class TcpStream
extends StreamImpl {
    private Socket _s;
    private InputStream _is;
    private OutputStream _os;

    private TcpStream(Path path, long timeout) throws IOException {
        this.setPath(path);
        this._s = new Socket(path.getHost(), path.getPort());
        if (this._s == null) {
            throw new IOException("connection timeout");
        }
        this._is = this._s.getInputStream();
        this._os = this._s.getOutputStream();
    }

    public void setAttribute(String name, Object value) {
        if (name.equals("timeout")) {
            try {
                this._s.setSoTimeout(Integer.parseInt(String.valueOf(value)));
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    static TcpStream openRead(TcpPath path, long timeout) throws IOException {
        return new TcpStream(path, timeout);
    }

    static TcpStream openReadWrite(TcpPath path, long timeout) throws IOException {
        return new TcpStream(path, timeout);
    }

    public boolean canWrite() {
        return this._os != null;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        this._os.write(buf, offset, length);
    }

    public boolean canRead() {
        return this._is != null;
    }

    public int getAvailable() throws IOException {
        return this._is.available();
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        return this._is.read(buf, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        InputStream is = this._is;
        this._is = null;
        OutputStream os = this._os;
        this._os = null;
        Socket s = this._s;
        this._s = null;
        try {
            if (os != null) {
                os.close();
            }
            if (is != null) {
                is.close();
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }
}

