/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.QDate;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class TimestampFilter
extends StreamImpl {
    private WriteStream stream;
    private String timestamp;
    private QDate calendar = new QDate();
    private boolean isLineBegin = true;

    TimestampFilter() {
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setStream(WriteStream stream) {
        this.stream = stream;
    }

    public boolean canWrite() {
        return this.stream != null && this.stream.canWrite();
    }

    public void write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
        if (this.stream == null) {
            return;
        }
        if (this.timestamp == null) {
            this.stream.write(buffer, offset, length);
            return;
        }
        long now = System.currentTimeMillis();
        for (int i = 0; i < length; ++i) {
            if (this.isLineBegin) {
                this.stream.print(QDate.formatLocal(now, this.timestamp));
                this.isLineBegin = false;
            }
            byte ch = buffer[offset + i];
            this.stream.write(ch);
            if (ch != 10 && (ch != 13 || i + 1 >= length || buffer[offset + i + 1] == 10)) continue;
            this.isLineBegin = true;
        }
    }

    public void flush() throws IOException {
        if (this.stream != null) {
            this.stream.flush();
        }
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }
}

