/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.ReaderWriterStream;
import com.caucho.vfs.StringReader;
import com.caucho.vfs.StringWriter;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;

public final class Vfs {
    static FilesystemPath PWD;

    private Vfs() {
    }

    public static Path lookup(String url) {
        if (PWD == null) {
            PWD = new FilePath(null);
        }
        return PWD.lookup(url, null);
    }

    public static Path lookup() {
        if (PWD == null) {
            PWD = new FilePath(null);
        }
        return PWD;
    }

    public static Path lookup(String url, Map attr) {
        if (PWD == null) {
            PWD = new FilePath(null);
        }
        return PWD.lookup(url, attr);
    }

    public static Path lookupNative(String url) {
        if (PWD == null) {
            PWD = new FilePath(null);
        }
        return PWD.lookupNative(url, null);
    }

    public static Path lookupNative(String url, Map attr) {
        if (PWD == null) {
            PWD = new FilePath(null);
        }
        return PWD.lookupNative(url, attr);
    }

    public static ReadWritePair openReadWrite(InputStream is, OutputStream os) {
        VfsStream s = new VfsStream(is, os);
        WriteStream writeStream = new WriteStream(s);
        ReadStream readStream = new ReadStream(s, writeStream);
        return new ReadWritePair(readStream, writeStream);
    }

    public static ReadStream openRead(InputStream is) {
        if (is instanceof ReadStream) {
            return (ReadStream)is;
        }
        VfsStream s = new VfsStream(is, null);
        return new ReadStream(s);
    }

    public static ReadStream openRead(InputStream is, WriteStream ws) {
        VfsStream s = new VfsStream(is, null);
        return new ReadStream(s, ws);
    }

    public static ReadStream openRead(Reader reader) {
        if (reader instanceof ReadStream.StreamReader) {
            return ((ReadStream.StreamReader)reader).getStream();
        }
        ReaderWriterStream s = new ReaderWriterStream(reader, null);
        ReadStream is = new ReadStream(s);
        try {
            is.setEncoding("utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return is;
    }

    public static ReadStream openRead(String path) throws IOException {
        return Vfs.lookup(path).openRead();
    }

    public static ReadStream openString(String string) {
        return StringReader.open(string);
    }

    public static WriteStream openWrite(OutputStream os) {
        if (os instanceof WriteStream) {
            return (WriteStream)os;
        }
        VfsStream s = new VfsStream(null, os);
        return new WriteStream(s);
    }

    public static WriteStream openWrite(Writer writer) {
        ReaderWriterStream s = new ReaderWriterStream(null, writer);
        WriteStream os = new WriteStream(s);
        try {
            os.setEncoding("utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return os;
    }

    public static WriteStream openWrite(CharBuffer cb) {
        StringWriter s = new StringWriter(cb);
        WriteStream os = new WriteStream(s);
        try {
            os.setEncoding("utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return os;
    }

    public static WriteStream openWrite(String path) throws IOException {
        return Vfs.lookup(path).openWrite();
    }

    public static WriteStream openAppend(String path) throws IOException {
        return Vfs.lookup(path).openAppend();
    }
}

