/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.util.CharBuffer;
import com.caucho.xml.QDocumentType;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.NodeIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IdExpr
extends Expr {
    private Expr expr;
    private ExprEnvironment lastEnv;
    private int lastUseCount;
    private Node lastContext;
    private ArrayList lastList;

    public IdExpr(ArrayList args) {
        if (args.size() > 0) {
            this.expr = (Expr)args.get(0);
        }
    }

    public boolean isNodeSet() {
        return true;
    }

    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        String string = this.evalString(node, env);
        return IdExpr.stringToNumber(string);
    }

    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        return this.id(node, env).size() > 0;
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        NodeIterator iter = this.evalNodeSet(node, env);
        if (!iter.hasNext()) {
            return "";
        }
        Node qNode = (Node)iter.next();
        return XmlUtil.textValue(qNode);
    }

    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        ArrayList list = this.id(node, env);
        return list;
    }

    private ArrayList id(Node context, ExprEnvironment env) throws XPathException {
        ArrayList idList = this.getIdList(context, env);
        ArrayList<Element> list = new ArrayList<Element>();
        if (idList == null || idList.size() == 0) {
            return list;
        }
        Node ptr = context instanceof Document ? context : context.getOwnerDocument();
        while ((ptr = XmlUtil.getNext(ptr)) != null) {
            String idValue;
            if (!(ptr instanceof Element)) continue;
            Element elt = (Element)ptr;
            QDocumentType dtd = (QDocumentType)elt.getOwnerDocument().getDoctype();
            String id = null;
            if (dtd != null) {
                id = dtd.getElementId(elt.getNodeName());
            }
            if (id == null || !idList.contains(idValue = elt.getAttribute(id)) || list.contains(elt)) continue;
            list.add(elt);
        }
        return list;
    }

    private ArrayList getIdList(Node node, ExprEnvironment env) throws XPathException {
        ArrayList idList = new ArrayList();
        Object obj = this.expr.evalObject(node, env);
        if (obj instanceof ArrayList) {
            ArrayList list = (ArrayList)obj;
            for (int i = 0; i < list.size(); ++i) {
                Node value = (Node)list.get(i);
                this.addText(idList, XmlUtil.textValue(value));
            }
        } else if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            while (iter.hasNext()) {
                Node value = (Node)iter.next();
                this.addText(idList, XmlUtil.textValue(value));
            }
        } else {
            this.addText(idList, IdExpr.toString(obj));
        }
        return idList;
    }

    private void addText(ArrayList idList, String text) {
        int i;
        int len = text.length();
        CharBuffer cb = new CharBuffer();
        boolean ch = false;
        for (i = 0; i < len && XmlChar.isWhitespace(text.charAt(i)); ++i) {
        }
        if (i == len) {
            return;
        }
        while (i < len) {
            cb.clear();
            while (i < len && !XmlChar.isWhitespace(text.charAt(i))) {
                cb.append(text.charAt(i));
                ++i;
            }
            idList.add(cb.toString());
            while (i < len && XmlChar.isWhitespace(text.charAt(i))) {
                ++i;
            }
        }
    }

    public String toString() {
        if (this.expr != null) {
            return "id(" + this.expr + ")";
        }
        return "id()";
    }
}

