/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FromAttributes;
import com.caucho.xpath.pattern.FromSelf;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xpath.pattern.NodePattern;
import com.caucho.xpath.pattern.NodeTypePattern;
import com.caucho.xpath.pattern.SingleNodeIterator;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ObjectExpr
extends Expr {
    private int code;
    private String name;
    private Expr left;
    private Expr right;
    private Expr third;

    public ObjectExpr(int code, ArrayList args) {
        this.code = code;
        if (args != null && args.size() > 0) {
            this.left = (Expr)args.get(0);
        }
        if (args != null && args.size() > 1) {
            this.right = (Expr)args.get(1);
        }
        if (args != null && args.size() > 2) {
            this.third = (Expr)args.get(2);
        }
        if (this.right == null || this.third == null) {
            throw new NullPointerException();
        }
    }

    public ObjectExpr(int code, String name) {
        this.code = code;
        this.name = name;
        if (name == null) {
            throw new NullPointerException();
        }
    }

    public boolean isNodeSet() {
        return this.code == 59;
    }

    public boolean isString() {
        return this.code == 61;
    }

    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        switch (this.code) {
            case 58: {
                if (this.left.evalBoolean(node, env)) {
                    return this.right.evalBoolean(node, env);
                }
                return this.third.evalBoolean(node, env);
            }
            case 61: {
                if (node instanceof Element) {
                    return !((Element)node).getAttribute(this.name).equals("");
                }
                return false;
            }
            case 59: {
                return true;
            }
        }
        return ObjectExpr.toBoolean(this.evalObject(node, env));
    }

    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        switch (this.code) {
            case 58: {
                if (this.left.evalBoolean(node, env)) {
                    return this.right.evalNumber(node, env);
                }
                return this.third.evalNumber(node, env);
            }
            case 61: {
                if (node instanceof Element) {
                    return ObjectExpr.toDouble(((Element)node).getAttribute(this.name));
                }
                return Double.NaN;
            }
            case 59: {
                return ObjectExpr.toDouble(XmlUtil.textValue(node));
            }
        }
        return ObjectExpr.toDouble(this.evalObject(node, env));
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        switch (this.code) {
            case 58: {
                if (this.left.evalBoolean(node, env)) {
                    return this.right.evalString(node, env);
                }
                return this.third.evalString(node, env);
            }
            case 61: {
                if (node instanceof Element) {
                    return ((Element)node).getAttribute(this.name);
                }
                return "";
            }
            case 59: {
                return XmlUtil.textValue(node);
            }
        }
        return ObjectExpr.toString(this.evalObject(node, env));
    }

    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        switch (this.code) {
            case 58: {
                if (this.left.evalBoolean(node, env)) {
                    return this.right.evalObject(node, env);
                }
                return this.third.evalObject(node, env);
            }
            case 59: {
                return node;
            }
            case 61: {
                if (node instanceof Element) {
                    return ((Element)node).getAttributeNode(this.name);
                }
                return null;
            }
        }
        return null;
    }

    public NodeIterator evalNodeSet(Node node, ExprEnvironment env) throws XPathException {
        switch (this.code) {
            case 58: {
                if (this.left.evalBoolean(node, env)) {
                    return this.right.evalNodeSet(node, env);
                }
                return this.third.evalNodeSet(node, env);
            }
            case 59: {
                return new SingleNodeIterator(env, node);
            }
            case 61: {
                if (node instanceof Element) {
                    return new SingleNodeIterator(env, ((Element)node).getAttributeNode(this.name));
                }
                return new SingleNodeIterator(env, null);
            }
        }
        return null;
    }

    protected AbstractPattern toNodeList() {
        switch (this.code) {
            case 59: {
                return NodeTypePattern.create(new FromSelf(null), -1);
            }
            case 61: {
                return new NodePattern(new FromAttributes(null), this.name, 2);
            }
        }
        return super.toNodeList();
    }

    public String toString() {
        switch (this.code) {
            case 58: {
                return "if(" + this.left + "," + this.right + "," + this.third + ")";
            }
            case 59: {
                return ".";
            }
            case 61: {
                return "@" + this.name;
            }
        }
        return super.toString();
    }
}

