/*
 * Copyright (c) 2005 Jason Carreira. All Rights Reserved.
 */
package com.opensymphony.async.model;

import org.springframework.orm.hibernate.support.HibernateDaoSupport;

import java.util.List;

/**
 * ExperimentDao
 *
 * @author Jason Carreira <jcarreira@eplus.com>
 */
public class ExperimentDao extends HibernateDaoSupport {

    public Experiment findById(String id) {
        return (Experiment) getHibernateTemplate().load(Experiment.class, id);
    }

    public List findAll() {
        return getHibernateTemplate().loadAll(Experiment.class);
    }

    public void save(Experiment entity) {
        getHibernateTemplate().save(entity);
    }

    public void delete(Experiment entity) {
        getHibernateTemplate().delete(entity);
    }
}
