/*
 * Copyright (c) 2005 Jason Carreira. All Rights Reserved.
 */
package com.opensymphony.async.model;

import java.util.Date;


/**
 * ExperimentDaoTest
 *
 * @author Jason Carreira <jcarreira@eplus.com>
 */
public class ExperimentDaoTest extends AbstractHibernateTestCase {
    ExperimentDao dao;

    public void setDao(ExperimentDao dao) {
        this.dao = dao;
    }

    public void testInsertNewExperiment() {
        Experiment experiment = new Experiment();
        Run run = new Run();
        experiment.addRun(run);
        experiment.setEndDate(new Date());
        dao.save(experiment);

        Experiment exp2 = dao.findById(experiment.getId());

        assertNotNull(exp2);

        assertEquals(experiment,exp2);
    }

}
