/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.digester;

import java.lang.reflect.Method;
import org.apache.struts.digester.Digester;
import org.apache.struts.digester.Rule;
import org.apache.struts.util.BeanUtils;
import org.xml.sax.AttributeList;

public final class CallMethodRule
extends Rule {
    private String bodyText = null;
    private String methodName = null;
    private int paramCount = 0;
    private Class[] paramTypes = null;

    public CallMethodRule(Digester digester, String methodName, int paramCount) {
        this(digester, methodName, paramCount, null);
    }

    public CallMethodRule(Digester digester, String methodName, int paramCount, String[] paramTypes) {
        super(digester);
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = this.paramCount == 0 ? new Class[1] : new Class[this.paramCount];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = i == 0 ? "abc".getClass() : this.paramTypes[0];
                ++i;
            }
        } else {
            this.paramTypes = new Class[paramTypes.length];
            int i = 0;
            while (i < this.paramTypes.length) {
                try {
                    this.paramTypes[i] = Class.forName(paramTypes[i]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.paramTypes[i] = null;
                }
                ++i;
            }
        }
    }

    public void begin(AttributeList attributes) throws Exception {
        if (this.paramCount > 0) {
            String[] parameters = new String[this.paramCount];
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = null;
                ++i;
            }
            this.digester.push(parameters);
        }
    }

    public void body(String bodyText) throws Exception {
        if (this.paramCount == 0) {
            this.bodyText = bodyText;
        }
    }

    public void end() throws Exception {
        String[] parameters = null;
        parameters = this.paramCount > 0 ? (String[])this.digester.pop() : new String[]{this.bodyText};
        Object[] paramValues = new Object[this.paramTypes.length];
        int i = 0;
        while (i < this.paramTypes.length) {
            paramValues[i] = BeanUtils.convert(parameters[i], this.paramTypes[i]);
            ++i;
        }
        Object top = this.digester.peek();
        if (this.digester.getDebug() >= 1) {
            StringBuffer sb = new StringBuffer("Call ");
            sb.append(top.getClass().getName());
            sb.append(".");
            sb.append(this.methodName);
            sb.append("(");
            int i2 = 0;
            while (i2 < paramValues.length) {
                if (i2 > 0) {
                    sb.append(",");
                }
                if (paramValues[i2] == null) {
                    sb.append("null");
                } else {
                    sb.append(paramValues[i2].toString());
                }
                ++i2;
            }
            sb.append(")");
            this.digester.log(sb.toString());
        }
        Method method = top.getClass().getMethod(this.methodName, this.paramTypes);
        method.invoke(top, paramValues);
    }

    public void finish() throws Exception {
        this.bodyText = null;
        this.methodName = null;
        this.paramTypes = null;
    }
}

