/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.struts.util.GenericConnection;

public class GenericDataSource
implements DataSource {
    protected boolean closed = false;
    protected LinkedList connections = new LinkedList();
    protected Driver driver = null;
    protected int loginTimeout = 0;
    protected PrintWriter logWriter = null;
    protected Properties properties = new Properties();
    protected int activeCount = 0;
    protected boolean autoCommit = true;
    protected String description = null;
    protected String driverClass = null;
    protected int maxCount = 2;
    protected int minCount = 1;
    protected String password = null;
    protected boolean readOnly = false;
    protected String url = null;
    protected int useCount = 0;
    protected String user = null;

    public void addProperty(String name, String value) {
        ((Hashtable)this.properties).put(name, value);
    }

    /*
     * Unable to fully structure code
     */
    public void close() throws SQLException {
        if (!this.closed) ** GOTO lbl6
        throw new SQLException("close:  Data Source already closed");
lbl-1000:
        // 1 sources

        {
            conn = (GenericConnection)this.getConnection();
            conn.getConnection().close();
            --this.activeCount;
lbl6:
            // 2 sources

            ** while (this.activeCount > 0)
        }
lbl7:
        // 1 sources

        this.closed = true;
        this.driver = null;
    }

    protected synchronized Connection createConnection() throws SQLException {
        Connection conn = this.driver.connect(this.url, this.properties);
        ++this.activeCount;
        return new GenericConnection(this, conn, this.autoCommit, this.readOnly);
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public Connection getConnection() throws SQLException {
        int seconds = 0;
        if (this.closed) {
            throw new SQLException("getConnection:  Data source is closed");
        }
        if (this.driver == null) {
            this.open();
        }
        while (this.loginTimeout <= 0 || seconds < this.loginTimeout) {
            LinkedList linkedList = this.connections;
            synchronized (linkedList) {
                if (!this.connections.isEmpty()) {
                    ++this.useCount;
                    Connection connection = (Connection)this.connections.removeFirst();
                    Object var4_5 = null;
                    return connection;
                }
            }
            if (this.activeCount < this.maxCount) {
                Connection conn = this.createConnection();
                ++this.useCount;
                return conn;
            }
            try {
                Thread.sleep(1000L);
                ++seconds;
            }
            catch (InterruptedException interruptedException) {}
        }
        throw new SQLException("getConnection: Timeout awaiting connection");
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    public String getDescription() {
        return this.description;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public String getUrl() {
        return this.url;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public String getUser() {
        return this.user;
    }

    public void open() throws SQLException {
        Serializable clazz;
        if (this.driver != null) {
            return;
        }
        try {
            clazz = Class.forName(this.driverClass);
            this.driver = (Driver)clazz.newInstance();
        }
        catch (Throwable t) {
            throw new SQLException("createConnection: " + t);
        }
        clazz = this.connections;
        synchronized (clazz) {
            int i = 0;
            while (i < this.minCount) {
                this.connections.addLast(this.createConnection());
                ++i;
            }
        }
        this.closed = false;
    }

    void returnConnection(GenericConnection conn) {
        LinkedList linkedList = this.connections;
        synchronized (linkedList) {
            this.connections.addLast(conn);
            --this.useCount;
        }
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.logWriter = logWriter;
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = loginTimeout;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public void setPassword(String password) {
        this.password = password;
        this.addProperty("password", this.password);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
        this.addProperty("user", this.user);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("GenericDataSource[");
        sb.append("activeCount=");
        sb.append(this.activeCount);
        sb.append(", autoCommit=");
        sb.append(this.autoCommit);
        sb.append(", closed=");
        sb.append(this.closed);
        if (this.description != null) {
            sb.append(", description=");
            sb.append(this.description);
        }
        sb.append(", driverClass=");
        sb.append(this.driverClass);
        sb.append(", loginTimeout=");
        sb.append(this.loginTimeout);
        sb.append(", maxCount=");
        sb.append(this.maxCount);
        sb.append(", minCount=");
        sb.append(this.minCount);
        sb.append(", password=");
        sb.append(this.password);
        sb.append(", readOnly=");
        sb.append(this.readOnly);
        sb.append(", url=");
        sb.append(this.url);
        sb.append(", useCount=");
        sb.append(this.useCount);
        sb.append(", user=");
        sb.append(this.user);
        sb.append("]");
        return sb.toString();
    }
}

