/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.digester;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.struts.digester.CallMethodRule;
import org.apache.struts.digester.CallParamRule;
import org.apache.struts.digester.ObjectCreateRule;
import org.apache.struts.digester.Rule;
import org.apache.struts.digester.SetNextRule;
import org.apache.struts.digester.SetPropertiesRule;
import org.apache.struts.digester.SetPropertyRule;
import org.apache.struts.digester.SetTopRule;
import org.apache.struts.util.ArrayStack;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Digester
extends HandlerBase {
    private StringBuffer bodyText = new StringBuffer();
    private ArrayStack bodyTexts = new ArrayStack();
    private int debug = 0;
    private HashMap dtds = new HashMap();
    private Locator locator = null;
    private String match = "";
    private SAXParser parser = null;
    private Object root = null;
    private HashMap rules = new HashMap();
    private ArrayStack stack = new ArrayStack();
    private boolean validating = false;

    public void addCallMethod(String pattern, String methodName, int paramCount) {
        this.addRule(pattern, new CallMethodRule(this, methodName, paramCount));
    }

    public void addCallMethod(String pattern, String methodName, int paramCount, String[] paramTypes) {
        this.addRule(pattern, new CallMethodRule(this, methodName, paramCount, paramTypes));
    }

    public void addCallParam(String pattern, int paramIndex) {
        this.addRule(pattern, new CallParamRule(this, paramIndex));
    }

    public void addCallParam(String pattern, int paramIndex, String attributeName) {
        this.addRule(pattern, new CallParamRule(this, paramIndex, attributeName));
    }

    public void addObjectCreate(String pattern, String className) {
        this.addRule(pattern, new ObjectCreateRule(this, className));
    }

    public void addObjectCreate(String pattern, String className, String attributeName) {
        this.addRule(pattern, new ObjectCreateRule(this, className, attributeName));
    }

    public void addRule(String pattern, Rule rule) {
        ArrayList<Rule> list = (ArrayList<Rule>)this.rules.get(pattern);
        if (list == null) {
            list = new ArrayList<Rule>();
            this.rules.put(pattern, list);
        }
        list.add(rule);
    }

    public void addSetNext(String pattern, String methodName) {
        this.addRule(pattern, new SetNextRule(this, methodName));
    }

    public void addSetNext(String pattern, String methodName, String paramType) {
        this.addRule(pattern, new SetNextRule(this, methodName, paramType));
    }

    public void addSetProperties(String pattern) {
        this.addRule(pattern, new SetPropertiesRule(this));
    }

    public void addSetProperty(String pattern, String name, String value) {
        this.addRule(pattern, new SetPropertyRule(this, name, value));
    }

    public void addSetTop(String pattern, String methodName) {
        this.addRule(pattern, new SetTopRule(this, methodName));
    }

    public void addSetTop(String pattern, String methodName, String paramType) {
        this.addRule(pattern, new SetTopRule(this, methodName, paramType));
    }

    public void characters(char[] buffer, int start, int length) throws SAXException {
        this.bodyText.append(buffer, start, length);
    }

    public void clear() {
        this.match = "";
        this.bodyTexts.clear();
        this.stack.clear();
        this.root = null;
    }

    public void endDocument() throws SAXException {
        if (this.getCount() > 1) {
            this.log("endDocument():  " + this.getCount() + " elements left");
        }
        while (this.getCount() > 1) {
            this.pop();
        }
        Iterator keys = this.rules.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List rules = (List)this.rules.get(key);
            int i = 0;
            while (i < rules.size()) {
                try {
                    ((Rule)rules.get(i)).finish();
                }
                catch (Exception e) {
                    this.log("Finish event threw exception", e);
                    throw new SAXException(e);
                }
                ++i;
            }
        }
        this.clear();
    }

    public void endElement(String name) throws SAXException {
        int slash;
        List rules = this.getRules(this.match);
        if (rules != null) {
            String bodyText = this.bodyText.toString();
            int i = 0;
            while (i < rules.size()) {
                try {
                    ((Rule)rules.get(i)).body(bodyText);
                }
                catch (Exception e) {
                    this.log("Body event threw exception", e);
                    throw new SAXException(e);
                }
                ++i;
            }
        }
        this.bodyText = (StringBuffer)this.bodyTexts.pop();
        if (rules != null) {
            int i = 0;
            while (i < rules.size()) {
                int j = rules.size() - i - 1;
                try {
                    ((Rule)rules.get(j)).end();
                }
                catch (Exception e) {
                    this.log("End event threw exception", e);
                    throw new SAXException(e);
                }
                ++i;
            }
        }
        this.match = (slash = this.match.lastIndexOf(47)) >= 0 ? this.match.substring(0, slash) : "";
    }

    public void error(SAXParseException exception) throws SAXException {
        this.log("Parse Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.log("Parse Fatal Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
    }

    public int getCount() {
        return this.stack.size();
    }

    public int getDebug() {
        return this.debug;
    }

    public SAXParser getParser() {
        if (this.parser != null) {
            return this.parser;
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(this.validating);
            this.parser = factory.newSAXParser();
            return this.parser;
        }
        catch (Exception e) {
            this.log("Digester.getParser: ", e);
            return null;
        }
    }

    private List getRules(String match) {
        List rulesList = (List)this.rules.get(match);
        if (rulesList == null) {
            Iterator keys = this.rules.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!key.startsWith("*/") || !match.endsWith(key.substring(1))) continue;
                rulesList = (List)this.rules.get(key);
                break;
            }
        }
        return rulesList;
    }

    public boolean getValidating() {
        return this.validating;
    }

    public void ignorableWhitespace(char[] buffer, int start, int len) throws SAXException {
    }

    public void log(String message) {
        System.out.println(message);
    }

    public void log(String message, Throwable exception) {
        System.out.println(message);
        exception.printStackTrace(System.out);
    }

    public void notationDecl(String name, String publicId, String systemId) {
        if (this.debug >= 1) {
            this.log("notationDecl('" + name + "', '" + publicId + "', '" + systemId + "')");
        }
    }

    public Object parse(File file) throws IOException, SAXException {
        this.getParser().parse(file, (HandlerBase)this);
        return this.root;
    }

    public Object parse(InputStream input) throws IOException, SAXException {
        this.getParser().parse(input, (HandlerBase)this);
        return this.root;
    }

    public Object parse(String uri) throws IOException, SAXException {
        this.getParser().parse(uri, (HandlerBase)this);
        return this.root;
    }

    public Object parse(InputSource input) throws IOException, SAXException {
        this.getParser().parse(input, (HandlerBase)this);
        return this.root;
    }

    public Object peek() {
        try {
            return this.stack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    public Object peek(int n) {
        try {
            return this.stack.peek(n);
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    public Object pop() {
        try {
            if (this.stack.size() == 1) {
                this.root = this.stack.peek();
            }
            return this.stack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void push(Object object) {
        this.stack.push(object);
    }

    public void register(String publicId, String dtdURL) {
        if (this.debug >= 1) {
            this.log("register('" + publicId + "', '" + dtdURL + "'");
        }
        this.dtds.put(publicId, dtdURL);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (this.debug >= 1) {
            this.log("resolveEntity('" + publicId + "', '" + systemId + "')");
        }
        String dtdURL = null;
        if (publicId != null) {
            dtdURL = (String)this.dtds.get(publicId);
        }
        if (dtdURL == null) {
            if (this.debug >= 1) {
                this.log(" Not registered, use system identifier");
            }
            return null;
        }
        if (this.debug >= 1) {
            this.log(" Resolving to alternate DTD '" + dtdURL + "'");
        }
        try {
            URL url = new URL(dtdURL);
            InputStream stream = url.openStream();
            return new InputSource(stream);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String name, AttributeList list) throws SAXException {
        this.bodyTexts.push(this.bodyText);
        this.bodyText.setLength(0);
        this.match = this.match.length() > 0 ? String.valueOf(this.match) + "/" + name : name;
        List rules = this.getRules(this.match);
        if (rules != null) {
            String bodyText = this.bodyText.toString();
            int i = 0;
            while (i < rules.size()) {
                try {
                    ((Rule)rules.get(i)).begin(list);
                }
                catch (Exception e) {
                    this.log("Begin event threw exception", e);
                    throw new SAXException(e);
                }
                ++i;
            }
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notation) {
        if (this.debug >= 1) {
            this.log("unparsedEntityDecl('" + name + "', '" + publicId + "', '" + systemId + "', '" + notation + "')");
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.log("Parse Warning at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
    }
}

