/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.form;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.taglib.form.SelectTag;
import org.apache.struts.util.BeanUtils;
import org.apache.struts.util.MessageResources;

public class OptionsTag
extends TagSupport {
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.form.LocalStrings");
    protected String collection = null;
    protected String labelName = null;
    protected String labelProperty = null;
    protected String name = null;
    protected String property = null;

    protected void addOption(StringBuffer sb, String value, String label, String match) {
        sb.append("<option value=\"");
        sb.append(value);
        sb.append("\"");
        if (match.equals(value)) {
            sb.append(" selected");
        }
        sb.append(">");
        sb.append(label);
        sb.append("</option>\r\n");
    }

    public int doEndTag() throws JspException {
        SelectTag selectTag = (SelectTag)((Object)this.pageContext.getAttribute("org.apache.struts.taglib.form.SELECT"));
        if (selectTag == null) {
            throw new JspException(messages.getMessage("optionsTag.select"));
        }
        String match = selectTag.getMatch();
        StringBuffer sb = new StringBuffer();
        if (this.collection != null) {
            Iterator collIterator = this.getIterator(this.collection, null);
            while (collIterator.hasNext()) {
                Object bean = collIterator.next();
                Object value = null;
                Object label = null;
                try {
                    value = BeanUtils.getPropertyValue(bean, this.property);
                    if (value == null) {
                        value = "";
                    }
                    if ((label = this.labelProperty != null ? BeanUtils.getPropertyValue(bean, this.labelProperty) : value) == null) {
                        label = "";
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new JspException(messages.getMessage("getter.access", (Object)this.property, (Object)this.collection));
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    throw new JspException(messages.getMessage("getter.result", (Object)this.property, (Object)t.toString()));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new JspException(messages.getMessage("getter.method", (Object)this.property, (Object)this.collection));
                }
                this.addOption(sb, value.toString(), label.toString(), match);
            }
        } else {
            Iterator valuesIterator = this.getIterator(this.name, this.property);
            Iterator labelsIterator = null;
            labelsIterator = this.labelName == null && this.labelProperty == null ? this.getIterator(this.name, this.property) : this.getIterator(this.labelName, this.labelProperty);
            while (valuesIterator.hasNext()) {
                String value;
                String label = value = (String)valuesIterator.next();
                if (labelsIterator.hasNext()) {
                    label = (String)labelsIterator.next();
                }
                this.addOption(sb, value, label, match);
            }
        }
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.print(sb.toString());
        }
        catch (IOException e) {
            throw new JspException(messages.getMessage("common.io", (Object)e.toString()));
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        return 0;
    }

    public String getCollection() {
        return this.collection;
    }

    protected Iterator getIterator(String name, String property) throws JspException {
        List<Object> bean;
        String beanName = name;
        if (beanName == null) {
            beanName = "org.apache.struts.taglib.form.BEAN";
        }
        if ((bean = this.pageContext.findAttribute(beanName)) == null) {
            throw new JspException(messages.getMessage("getter.bean", (Object)beanName));
        }
        List<Object> collection = bean;
        if (property != null) {
            try {
                collection = BeanUtils.getPropertyValue(bean, property);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JspException(messages.getMessage("getter.access", (Object)property, (Object)name));
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                throw new JspException(messages.getMessage("getter.result", (Object)property, (Object)t.toString()));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new JspException(messages.getMessage("getter.method", (Object)property, (Object)name));
            }
        }
        if (collection.getClass().isArray()) {
            collection = Arrays.asList((Object[])collection);
        }
        if (collection instanceof Collection) {
            return ((Collection)collection).iterator();
        }
        if (collection instanceof Iterator) {
            return (Iterator)((Object)collection);
        }
        if (collection instanceof Map) {
            return ((Map)((Object)collection)).entrySet().iterator();
        }
        throw new JspException(messages.getMessage("optionsTag.iterator", (Object)collection.toString()));
    }

    public String getLabelName() {
        return this.labelName;
    }

    public String getLabelProperty() {
        return this.labelProperty;
    }

    public String getName() {
        return this.name;
    }

    public String getProperty() {
        return this.property;
    }

    public void release() {
        super.release();
        this.collection = null;
        this.labelName = null;
        this.labelProperty = null;
        this.name = null;
        this.property = null;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    public void setLabelProperty(String labelProperty) {
        this.labelProperty = labelProperty;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperty(String property) {
        this.property = property;
    }
}

