/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.logic;

import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.struts.taglib.logic.ConditionalTagBase;
import org.apache.struts.util.BeanUtils;
import org.apache.struts.util.PropertyUtils;

public class MatchTag
extends ConditionalTagBase {
    protected String location = null;
    protected String value = null;

    protected boolean condition() throws JspException {
        return this.condition(true);
    }

    protected boolean condition(boolean desired) throws JspException {
        String variable = null;
        if (this.cookie != null) {
            Cookie[] cookies = ((HttpServletRequest)this.pageContext.getRequest()).getCookies();
            if (cookies == null) {
                cookies = new Cookie[]{};
            }
            int i = 0;
            while (i < cookies.length) {
                if (this.cookie.equals(cookies[i].getName())) {
                    variable = cookies[i].getValue();
                    break;
                }
                ++i;
            }
        } else if (this.header != null) {
            variable = ((HttpServletRequest)this.pageContext.getRequest()).getHeader(this.header);
        } else if (this.name != null) {
            Object bean = BeanUtils.lookup(this.pageContext, this.name, this.scope);
            if (bean == null) {
                JspException e = new JspException(ConditionalTagBase.messages.getMessage("logic.bean", (Object)this.name));
                this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
                throw e;
            }
            if (this.property != null) {
                Object propertyValue = null;
                try {
                    propertyValue = PropertyUtils.getProperty(bean, this.property);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t == null) {
                        t = e;
                    }
                    this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)t, 2);
                    throw new JspException(ConditionalTagBase.messages.getMessage("logic.property", (Object)this.name, (Object)this.property, (Object)t.toString()));
                }
                catch (Throwable t) {
                    this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)t, 2);
                    throw new JspException(ConditionalTagBase.messages.getMessage("logic.property", (Object)this.name, (Object)this.property, (Object)t.toString()));
                }
                if (propertyValue != null) {
                    variable = propertyValue.toString();
                }
            } else {
                variable = bean.toString();
            }
        } else if (this.parameter != null) {
            variable = this.pageContext.getRequest().getParameter(this.parameter);
        } else {
            JspException e = new JspException(ConditionalTagBase.messages.getMessage("logic.selector"));
            this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw e;
        }
        if (variable == null) {
            JspException e = new JspException(ConditionalTagBase.messages.getMessage("logic.variable", (Object)this.value));
            this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw e;
        }
        boolean matched = false;
        if (this.location == null) {
            matched = variable.indexOf(this.value) >= 0;
        } else if (this.location.equals("start")) {
            matched = variable.startsWith(this.value);
        } else if (this.location.equals("end")) {
            matched = variable.endsWith(this.value);
        } else {
            JspException e = new JspException(ConditionalTagBase.messages.getMessage("logic.location", (Object)this.location));
            this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw e;
        }
        return matched == desired;
    }

    public String getLocation() {
        return this.location;
    }

    public String getValue() {
        return this.value;
    }

    public void release() {
        super.release();
        this.location = null;
        this.value = null;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

