/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.upload.DiskFile;
import org.apache.struts.upload.MultipartElement;
import org.apache.struts.upload.MultipartIterator;
import org.apache.struts.upload.MultipartRequestHandler;

public class DiskMultipartRequestHandler
implements MultipartRequestHandler {
    protected ActionServlet servlet;
    protected ActionMapping mapping;
    protected Hashtable fileElements;
    protected Hashtable textElements;
    protected Hashtable allElements;

    public void finish() {
        this.rollback();
    }

    public Hashtable getAllElements() {
        return this.allElements;
    }

    public Hashtable getFileElements() {
        return this.fileElements;
    }

    public ActionMapping getMapping() {
        return this.mapping;
    }

    protected long getMaxSizeFromServlet() throws ServletException {
        String stringSize = this.servlet.getMaxFileSize();
        long size = -1L;
        int multiplier = 1;
        if (stringSize.endsWith("K")) {
            multiplier = 1024;
            stringSize = stringSize.substring(0, stringSize.length() - 1);
        }
        if (stringSize.endsWith("M")) {
            multiplier = 0x100000;
            stringSize = stringSize.substring(0, stringSize.length() - 1);
        } else if (stringSize.endsWith("G")) {
            multiplier = 0x40000000;
            stringSize = stringSize.substring(0, stringSize.length() - 1);
        }
        try {
            size = Long.parseLong(stringSize);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServletException("Invalid format for maximum file size: \"" + this.servlet.getMaxFileSize() + "\"");
        }
        return size * (long)multiplier;
    }

    public ActionServlet getServlet() {
        return this.servlet;
    }

    public Hashtable getTextElements() {
        return this.textElements;
    }

    public void handleRequest(HttpServletRequest request) throws ServletException {
        MultipartIterator iterator = new MultipartIterator(request, this.servlet.getBufferSize(), this.getMaxSizeFromServlet());
        this.textElements = new Hashtable();
        this.fileElements = new Hashtable();
        this.allElements = new Hashtable();
        block6: while (true) {
            try {
                MultipartElement element;
                while ((element = iterator.getNextElement()) != null) {
                    if (element.getFileName() == null && element.getContentType() == null) {
                        String textData;
                        try {
                            textData = new String(element.getData(), "ISO-8859-1");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            textData = new String(element.getData());
                        }
                        this.textElements.put(element.getName(), textData);
                        this.allElements.put(element.getName(), textData);
                        continue;
                    }
                    try {
                        DiskFile theFile = this.writeFile(element);
                        this.fileElements.put(element.getName(), theFile);
                        this.allElements.put(element.getName(), theFile);
                        continue block6;
                    }
                    catch (IOException ioe) {
                        throw new ServletException("DiskMultipartRequestHandler.handleRequest(), IOException: " + ioe.getMessage());
                    }
                }
                break;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ServletException("Encoding \"ISO-8859-1\" not supported");
            }
        }
    }

    public void rollback() {
        Enumeration names = this.fileElements.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            DiskFile theFile = (DiskFile)this.fileElements.get(name);
            theFile.destroy();
        }
    }

    public void setMapping(ActionMapping mapping) {
        this.mapping = mapping;
    }

    public void setServlet(ActionServlet servlet) {
        this.servlet = servlet;
    }

    protected DiskFile writeFile(MultipartElement element) throws IOException, ServletException {
        File tempDirectory;
        DiskFile theFile = null;
        String tempDir = this.servlet.getTempDir();
        if (tempDir == null) {
            ServletContext context = this.servlet.getServletConfig().getServletContext();
            try {
                tempDir = (String)context.getAttribute("javax.servlet.context.tempdir");
            }
            catch (ClassCastException classCastException) {
                tempDir = ((File)context.getAttribute("javax.servlet.context.tempdir")).getAbsolutePath();
            }
            if (tempDir == null) {
                tempDir = System.getProperty("java.io.tmpdir");
                if (this.servlet.getDebug() > 1) {
                    this.servlet.log("DiskMultipartRequestHandler.handleRequest(): defaulting to java.io.tmpdir directory \"" + tempDir);
                }
            }
        }
        if (!(tempDirectory = new File(tempDir)).exists() || !tempDirectory.isDirectory()) {
            throw new ServletException("DiskMultipartRequestHandler: no temporary directory specified for disk write");
        }
        File tempFile = File.createTempFile("strts", null, tempDirectory);
        FileOutputStream fos = new FileOutputStream(tempFile);
        int bufferSize = -1;
        if (bufferSize > 0) {
            ByteArrayInputStream byteArray = new ByteArrayInputStream(element.getData());
            byte[] bufferBytes = new byte[bufferSize];
            int bytesWritten = 0;
            int bytesRead = 0;
            int offset = 0;
            while ((bytesRead = byteArray.read(bufferBytes, offset, bufferSize)) != -1) {
                fos.write(bufferBytes, offset, bytesRead);
                bytesWritten += bytesRead;
                offset += bytesRead;
            }
            byteArray.close();
        } else {
            fos.write(element.getData());
        }
        theFile = new DiskFile(tempFile.getAbsolutePath());
        theFile.setContentType(element.getContentType());
        theFile.setFileName(element.getFileName());
        theFile.setFileSize(element.getData().length);
        fos.close();
        return theFile;
    }
}

