/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.struts.util.GenericDataSource;

public class GenericConnection
implements Connection {
    protected boolean autoCommit = false;
    protected String catalog = null;
    protected Connection conn = null;
    protected int level = 0;
    protected Map map = null;
    protected boolean readOnly = false;
    protected GenericDataSource source = null;

    public GenericConnection(GenericDataSource source, Connection conn, boolean autoCommit, boolean readOnly) throws SQLException {
        this.source = source;
        this.conn = conn;
        this.autoCommit = autoCommit;
        this.catalog = conn.getCatalog();
        this.level = conn.getTransactionIsolation();
        try {
            this.map = conn.getTypeMap();
        }
        catch (SQLException sQLException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        this.readOnly = readOnly;
        this.conn.setAutoCommit(this.autoCommit);
        this.conn.setReadOnly(this.readOnly);
    }

    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    public void close() throws SQLException {
        try {
            this.conn.rollback();
        }
        catch (SQLException sQLException) {}
        try {
            this.conn.setAutoCommit(this.autoCommit);
        }
        catch (SQLException sQLException) {}
        try {
            this.conn.setCatalog(this.catalog);
        }
        catch (SQLException sQLException) {}
        try {
            this.conn.setTransactionIsolation(this.level);
        }
        catch (SQLException sQLException) {}
        try {
            this.conn.setTypeMap(this.map);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (SQLException sQLException) {}
        try {
            this.conn.setReadOnly(this.readOnly);
        }
        catch (SQLException sQLException) {}
        try {
            this.conn.clearWarnings();
        }
        catch (SQLException sQLException) {}
        this.source.returnConnection(this);
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.createStatement(resultSetType, resultSetConcurrency);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    Connection getConnection() {
        return this.conn;
    }

    DataSource getDataSource() {
        return this.source;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return false;
    }

    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.conn.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.conn.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.conn.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.conn.setAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.conn.setCatalog(catalog);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.conn.setReadOnly(readOnly);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.conn.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.conn.setTypeMap(map);
    }
}

