/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.util.BeanUtils;
import org.apache.struts.util.MessageResources;

public final class HtmlPropertyTag
extends TagSupport {
    private String name = null;
    private static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.LocalStrings");
    private String property = null;

    public int doStartTag() throws JspException {
        Object bean = this.pageContext.findAttribute(this.name);
        if (bean == null) {
            throw new JspException(messages.getMessage("getter.bean", (Object)this.name));
        }
        Class[] paramTypes = new Class[]{};
        Object value = null;
        try {
            value = BeanUtils.getPropertyValue(bean, this.property);
            if (value == null) {
                value = "";
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JspException(messages.getMessage("getter.access", (Object)this.property, (Object)this.name));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw new JspException(messages.getMessage("getter.result", (Object)this.property, (Object)t.toString()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JspException(messages.getMessage("getter.method", (Object)this.property, (Object)this.name));
        }
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.print(BeanUtils.filter(value.toString()));
        }
        catch (IOException e) {
            throw new JspException(messages.getMessage("common.io", (Object)e.toString()));
        }
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public String getProperty() {
        return this.property;
    }

    public void release() {
        super.release();
        this.name = null;
        this.property = null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperty(String property) {
        this.property = property;
    }
}

