/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.form;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionForwards;
import org.apache.struts.taglib.form.BaseHandlerTag;
import org.apache.struts.util.BeanUtils;
import org.apache.struts.util.MessageResources;

public class LinkTag
extends BaseHandlerTag {
    protected String forward = null;
    protected String href = null;
    protected String linkName = null;
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.form.LocalStrings");
    protected String name = null;
    protected String page = null;
    protected String paramId = null;
    protected String paramName = null;
    protected String paramProperty = null;
    protected String paramScope = null;
    protected String property = null;
    protected String scope = null;
    protected String target = null;

    public int doAfterBody() throws JspException {
        if (this.bodyContent != null) {
            JspWriter writer = this.bodyContent.getEnclosingWriter();
            try {
                writer.print(this.bodyContent.getString().trim());
            }
            catch (IOException e) {
                throw new JspException(messages.getMessage("common.io", (Object)e.toString()));
            }
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        JspWriter writer = ((TagSupport)this).pageContext.getOut();
        try {
            writer.print("</a>");
        }
        catch (IOException e) {
            throw new JspException(messages.getMessage("common.io", (Object)e.toString()));
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        HttpServletResponse response = (HttpServletResponse)((TagSupport)this).pageContext.getResponse();
        StringBuffer results = new StringBuffer("<a");
        String hyperlink = this.hyperlink();
        if (hyperlink != null) {
            results.append(" href=\"");
            results.append(response.encodeURL(BeanUtils.filter(hyperlink)));
            results.append("\"");
        }
        if (this.linkName != null) {
            results.append(" name=\"");
            results.append(this.linkName);
            results.append("\"");
        }
        if (this.target != null) {
            results.append(" target=\"");
            results.append(this.target);
            results.append("\"");
        }
        results.append(this.prepareStyles());
        results.append(this.prepareEventHandlers());
        results.append(">");
        JspWriter writer = ((TagSupport)this).pageContext.getOut();
        try {
            writer.print(results.toString());
        }
        catch (IOException e) {
            ((TagSupport)this).pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw new JspException(messages.getMessage("common.io", (Object)e.toString()));
        }
        return 2;
    }

    public String getForward() {
        return this.forward;
    }

    public String getHref() {
        return this.href;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public String getName() {
        return this.name;
    }

    public String getPage() {
        return this.page;
    }

    public String getParamId() {
        return this.paramId;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getParamProperty() {
        return this.paramProperty;
    }

    public String getParamScope() {
        return this.paramScope;
    }

    public String getProperty() {
        return this.property;
    }

    public String getScope() {
        return this.scope;
    }

    public String getTarget() {
        return this.target;
    }

    protected String hyperlink() throws JspException {
        Object bean;
        if (this.linkName != null) {
            return null;
        }
        int n = 0;
        if (this.forward != null) {
            ++n;
        }
        if (this.href != null) {
            ++n;
        }
        if (this.page != null) {
            ++n;
        }
        if (n != 1) {
            JspException e = new JspException(messages.getMessage("linkTag.destination"));
            ((TagSupport)this).pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw e;
        }
        String href = this.href;
        if (this.forward != null) {
            ActionForwards forwards = (ActionForwards)((TagSupport)this).pageContext.getAttribute("org.apache.struts.action.FORWARDS", 4);
            if (forwards == null) {
                throw new JspException(messages.getMessage("linkTag.forwards"));
            }
            ActionForward forward = forwards.findForward(this.forward);
            if (forward == null) {
                throw new JspException(messages.getMessage("linkTag.forward"));
            }
            HttpServletRequest request = (HttpServletRequest)((TagSupport)this).pageContext.getRequest();
            href = String.valueOf(request.getContextPath()) + forward.getPath();
        }
        if (this.page != null) {
            HttpServletRequest request = (HttpServletRequest)((TagSupport)this).pageContext.getRequest();
            href = String.valueOf(request.getContextPath()) + this.page;
        }
        if (this.paramId != null && this.paramName != null) {
            href = href.indexOf(63) < 0 ? String.valueOf(href) + '?' : String.valueOf(href) + '&';
            href = String.valueOf(href) + this.paramId;
            href = String.valueOf(href) + '=';
            bean = BeanUtils.lookup(((TagSupport)this).pageContext, this.paramName, this.paramScope);
            if (bean != null) {
                if (this.paramProperty == null) {
                    href = String.valueOf(href) + bean.toString();
                } else {
                    try {
                        Object value = BeanUtils.getPropertyValue(bean, this.paramProperty);
                        if (value != null) {
                            href = String.valueOf(href) + value.toString();
                        }
                    }
                    catch (IllegalAccessException e) {
                        ((TagSupport)this).pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
                        throw new JspException(messages.getMessage("getter.access", (Object)this.paramProperty, (Object)this.paramName));
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        ((TagSupport)this).pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)t, 2);
                        throw new JspException(messages.getMessage("getter.result", (Object)this.paramProperty, (Object)t.toString()));
                    }
                    catch (NoSuchMethodException e) {
                        ((TagSupport)this).pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
                        throw new JspException(messages.getMessage("getter.method", (Object)this.paramProperty, (Object)this.paramName));
                    }
                }
            }
        }
        if (this.property != null && this.name == null) {
            JspException e = new JspException(messages.getMessage("getter.name"));
            ((TagSupport)this).pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw e;
        }
        if (this.name == null) {
            return href;
        }
        bean = BeanUtils.lookup(((TagSupport)this).pageContext, this.name, this.scope);
        if (bean == null) {
            JspException e = new JspException(messages.getMessage("getter.bean", (Object)this.name));
            ((TagSupport)this).pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw e;
        }
        Map map = null;
        if (this.property == null) {
            try {
                map = (Map)bean;
            }
            catch (ClassCastException e) {
                ((TagSupport)this).pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
                throw new JspException(messages.getMessage("linkTag.type"));
            }
        }
        try {
            map = (Map)BeanUtils.getPropertyValue(bean, this.property);
            if (map == null) {
                JspException e = new JspException(messages.getMessage("getter.property", (Object)this.property));
                ((TagSupport)this).pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
                throw e;
            }
        }
        catch (IllegalAccessException e) {
            ((TagSupport)this).pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw new JspException(messages.getMessage("getter.access", (Object)this.property, (Object)this.name));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            ((TagSupport)this).pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)t, 2);
            throw new JspException(messages.getMessage("getter.result", (Object)this.property, (Object)t.toString()));
        }
        catch (ClassCastException e) {
            ((TagSupport)this).pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw new JspException(messages.getMessage("linkTag.type"));
        }
        catch (NoSuchMethodException e) {
            ((TagSupport)this).pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw new JspException(messages.getMessage("getter.method", (Object)this.property, (Object)this.name));
        }
        StringBuffer sb = new StringBuffer(href);
        boolean question = href.indexOf("?") >= 0;
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = map.get(key);
            if (value == null) {
                if (question) {
                    sb.append('&');
                } else {
                    sb.append('?');
                    question = true;
                }
                sb.append(key);
                sb.append('=');
                continue;
            }
            if (value instanceof String[]) {
                String[] values = (String[])value;
                int i = 0;
                while (i < values.length) {
                    if (question) {
                        sb.append('&');
                    } else {
                        sb.append('?');
                        question = true;
                    }
                    sb.append(key);
                    sb.append('=');
                    sb.append(URLEncoder.encode(values[i]));
                    ++i;
                }
                continue;
            }
            if (question) {
                sb.append('&');
            } else {
                sb.append('?');
                question = true;
            }
            sb.append(key);
            sb.append('=');
            sb.append(URLEncoder.encode(value.toString()));
        }
        return sb.toString();
    }

    public void release() {
        super.release();
        this.forward = null;
        this.href = null;
        this.linkName = null;
        this.name = null;
        this.page = null;
        this.property = null;
        this.scope = null;
        this.target = null;
    }

    public void setForward(String forward) {
        this.forward = forward;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void setParamId(String paramId) {
        this.paramId = paramId;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public void setParamProperty(String paramProperty) {
        this.paramProperty = paramProperty;
    }

    public void setParamScope(String paramScope) {
        this.paramScope = paramScope;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setTarget(String target) {
        this.target = target;
    }
}

