<%@ page language="java" %>
<%@ page import="business.util.Validation" %>
<%@ page import="business.db.MailingList" %>
<%
String error = "";
String email = request.getParameter("email");

// validate input
if( email!=null ) {

    // validate input...
    if( business.util.Validation.isValidEmail(email) ) {

        // store input...
        try {
            business.db.MailingList.AddEmail(email);
        } catch (Exception e) {
            error = "Error adding email address to system.  " + e;
        }

        if( error.length()==0 ) {
%>
            // redirect to welcome page...
            <jsp:forward page="welcome.html"/> 
<%
        }
    } else {
        // set error message and redisplay page
        error = email + " is not a valid email address, please try again.";
    }

} else {
    email = "";
}
%>
<html>
<head>
<title>Join Mailing List</title>
</head>
<body>
<font color=red><%=error%></font><br>

<h3>Enter your email to join the group</h3>
<form action="join.jsp" name="joinForm">
    <input name="email" id="email" value=<%=email%>></input> 
    <input type=submit value="submit">
</form>
</body>
</html>