// Block.cpp: implementation of the CBlock class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Tetris.h"
#include "Block.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

int	CBlock::BLOCK_CELL = 20;		//	С
BYTE CBlock::COLOR_CHANGE = 60;		//	ɫɫͻɫֵ
int CBlock::BORDER_WIDTH = 1;		//	3D߿

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBlock::CBlock()
{
	m_nXPos = 0;
	m_nYPos = 0;
	m_crBody = 0;
}

CBlock::CBlock(int x, int y, COLORREF cr)
{
	m_nXPos = x;
	m_nYPos = y;
	m_crBody = cr;
}

CBlock::CBlock(CBlock &b)
{
	m_nXPos = b.m_nXPos;
	m_nYPos = b.m_nYPos;
	m_crBody = b.m_crBody;
}

CBlock::~CBlock()
{

}

void CBlock::Draw(CPoint lt, CDC &dc, BOOL bNull, int nSize)
{
	if (m_nXPos < 0 || m_nYPos < 0) return;
	CPoint pt = lt+CSize(m_nXPos*nSize, m_nYPos*nSize);
	CRect rc = CRect(pt, CSize(nSize, nSize));
	if (!bNull)
	{
		dc.FillRect(rc, &CBrush(m_crBody));
		dc.Draw3dRect(rc, GetLightColor(), GetDarkColor());
	}
	else
		dc.FillRect(rc, &CBrush(RGB(255, 255, 255)));
/*
	CPen LightPen, DarkPen;
	CPen* pOldPen;
	int i;

	LightPen.CreatePen(PS_SOLID, 1, GetLightColor());
	pOldPen = dc.SelectObject(&LightPen);

	for (i=0; i<BORDER_WIDTH; i++)
	{
		dc.MoveTo(pt.x+i, pt.y+i);
		dc.LineTo(pt.x+BLOCK_CELL-i, pt.y+i);
		dc.MoveTo(pt.x+i, pt.y+i);
		dc.LineTo(pt.x+i, pt.y+BLOCK_CELL-i);
	}

	DarkPen.CreatePen(PS_SOLID, 1, GetDarkColor());
	dc.SelectObject(&DarkPen);
	for (i=0; i<BORDER_WIDTH; i++)
	{
		dc.MoveTo(pt.x+BLOCK_CELL-i, pt.y+BLOCK_CELL-i);
		dc.LineTo(pt.x+BLOCK_CELL-i, pt.y+i);
		dc.MoveTo(pt.x+BLOCK_CELL-i, pt.y+BLOCK_CELL-i);
		dc.LineTo(pt.x+i, pt.y+BLOCK_CELL-i);
	}
	dc.SelectObject(pOldPen);
*/
}

COLORREF CBlock::GetDarkColor(void)
{
	BYTE r = GetRValue(m_crBody);
	BYTE g = GetGValue(m_crBody);
	BYTE b = GetBValue(m_crBody);

	r = r-COLOR_CHANGE<0 ? 0 : r-COLOR_CHANGE;
	g = g-COLOR_CHANGE<0 ? 0 : g-COLOR_CHANGE;
	b = b-COLOR_CHANGE<0 ? 0 : b-COLOR_CHANGE;

	return RGB(r, g, b);
}

COLORREF CBlock::GetLightColor(void)
{
	BYTE r = GetRValue(m_crBody);
	BYTE g = GetGValue(m_crBody);
	BYTE b = GetBValue(m_crBody);

	r = r+COLOR_CHANGE>255 ? 255 : r+COLOR_CHANGE;
	g = g+COLOR_CHANGE>255 ? 255 : g+COLOR_CHANGE;
	b = b+COLOR_CHANGE>255 ? 255 : b+COLOR_CHANGE;

	return RGB(r, g, b);
}
