// Block.h: interface for the CBlock class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BLOCK_H__9CAB1AD5_F75F_11D4_910A_5254ABDD22CE__INCLUDED_)
#define AFX_BLOCK_H__9CAB1AD5_F75F_11D4_910A_5254ABDD22CE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CBlock : public CObject  
{
public:
	CBlock();
	CBlock(int x, int y, COLORREF cr);
	CBlock(CBlock &b);
	
	virtual ~CBlock();

	void Draw(CPoint lt, CDC &dc, BOOL bNull = FALSE, int nSize = GetCell());

	void SetXPos(int x)
	{
		m_nXPos = x;
	}
	void SetYPos(int y)
	{
		m_nYPos = y;
	}

	int GetXPos(void)
	{
		return m_nXPos;
	}
	int GetYPos(void)
	{
		return m_nYPos;
	}

	void SetColor(COLORREF cr)
	{
		m_crBody = cr;
	}
	COLORREF GetColor(void)
	{
		return m_crBody;
	}
	COLORREF GetDarkColor(void);
	COLORREF GetLightColor(void);

	static int GetCell(void)
	{
		return BLOCK_CELL;
	}
	static void SetCell(int c)
	{
		BLOCK_CELL = c;
	}

protected:
	int			m_nXPos;
	int			m_nYPos;
	COLORREF	m_crBody;

	static int	BLOCK_CELL;
	static BYTE COLOR_CHANGE;
	static int	BORDER_WIDTH;

public:
	void operator = (const CBlock &b)
	{
		m_nXPos = b.m_nXPos;
		m_nYPos = b.m_nYPos;
		m_crBody = b.m_crBody;
	}

};

#endif // !defined(AFX_BLOCK_H__9CAB1AD5_F75F_11D4_910A_5254ABDD22CE__INCLUDED_)
