// Body.cpp: implementation of the CBody class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Tetris.h"
#include "Body.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBody::CBody()
{
	m_nWidth = 10;
	m_nHeight = 20;
}

CBody::CBody(CBody &b)
{
	m_nWidth = b.m_nWidth;
	m_nHeight = b.m_nHeight;
	m_Tetris = b.m_Tetris;
	m_ptStart = b.m_ptStart;
	m_ptTetris = b.m_ptTetris;
}

CBody::~CBody()
{
	ReSetBlocks();
}

void CBody::Draw(CDC &dc)
{
	int nSaveDC = dc.SaveDC();
	dc.SelectStockObject(WHITE_PEN);
	dc.SelectStockObject(WHITE_BRUSH);
	dc.Rectangle(CRect(m_ptStart, CSize(m_nWidth*CBlock::GetCell(), m_nHeight*CBlock::GetCell())));

	for (int i=0; i<m_Blocks.GetSize(); i++)
		m_Blocks[i].Draw(m_ptStart, dc);

	DrawTetris(dc);
	dc.RestoreDC(nSaveDC);
}

void CBody::DrawTetris(CDC &dc, bool bNull)
{
	m_Tetris.Draw(m_ptStart + CSize(m_ptTetris.x*CBlock::GetCell(), m_ptTetris.y*CBlock::GetCell()), dc, bNull);
}

void CBody::SetTetris(const CTetris &Tetris)
{
   	for (int i=0; i<m_Tetris.GetBlockCount(); i++)
	{
		CBlock TempBlock = m_Tetris.GetBlock(i);
		TempBlock.SetXPos(m_ptTetris.x + TempBlock.GetXPos());
		TempBlock.SetYPos(m_ptTetris.y + TempBlock.GetYPos());
		m_Blocks.Add(TempBlock);
	}
	m_Tetris = Tetris;
}

bool CBody::IsTetrisFit(const CPoint &pt, CTetris Tetris)
{
	for (int i=0; i<Tetris.GetBlockCount(); i++)
	{
		CPoint ptT = pt + Tetris.GetBlockPoint(i);
		if (ptT.x < 0 || ptT.y < 0 || ptT.x >= m_nWidth || ptT.y >= m_nHeight) return false;
		for (int j=0; j<m_Blocks.GetSize(); j++)
		{
			if (ptT.x == m_Blocks[j].GetXPos() && ptT.y == m_Blocks[j].GetYPos()) return false;
		}
	}
	return true;
}

bool CBody::TetrisMove(CDC &dc, const CSize &sz)
{
	CPoint ptTo = m_ptTetris + sz;
	CTetris TestTetris = m_Tetris;
	if (sz == CSize(0, 0))	TestTetris.Roate();

	if (IsTetrisFit(ptTo, TestTetris))
	{
		DrawTetris(dc, true);
		m_ptTetris = ptTo;
		if (sz == CSize(0, 0))	m_Tetris.Roate();
		DrawTetris(dc);
		return true;
	}
	return false;
}

void CBody::CutLastTetris(void)
{
	for (int i=0; i<m_Tetris.GetSize()+1; i++)
	{
		if (IsTetrisFit(m_ptTetris, m_Tetris)) break;
		m_Tetris.CutTopLine();
	}
}

int CBody::RemoveLines(void)
{
	int nLines = 0;
	for (int i=0; i<m_nHeight; i++)
	{
		bool bRemove = true;
		for (int j=0; j<m_nWidth; j++)
		{
			if (!HasBlock(j, i))
			{
				bRemove = false;
				break;
			}
		}
		if (bRemove)
		{
			for (int nIndex=m_Blocks.GetSize()-1; nIndex>=0; nIndex--)
			{
				int nYPos = m_Blocks[nIndex].GetYPos();
				if (nYPos < i)
					m_Blocks[nIndex].SetYPos(nYPos+1);
				if (nYPos == i)
					m_Blocks.RemoveAt(nIndex);
			}
			nLines++;
		}
	}
	return nLines;
}

void CBody::AddLines(int nLines, int nColor)
{
	int i;
	for (i=0; i<m_Blocks.GetSize(); i++)
	{
		m_Blocks[i].SetYPos(m_Blocks[i].GetYPos()-nLines);
	}

	for (i=m_nHeight-1; i>m_nHeight-nLines-1; i--)
	{
		int nNull1 = rand() % m_nWidth;
		int nNull2 = -1;
		if (rand()%10 < 3) nNull2 = rand() % m_nWidth;
		for (int n=0; n<m_nWidth; n++)
		{
			if (n != nNull1 && n != nNull2)
			{
				CBlock* pTempBlock = new CBlock(n, i, CTetris::COLOR_TYPE[rand()%nColor]);
				m_Blocks.Add(*pTempBlock);
				delete pTempBlock;
			}
		}
	}
}

bool CBody::HasBlock(int x, int y)
{
	for (int i=0; i<m_Blocks.GetSize(); i++)
		if (m_Blocks[i].GetXPos() == x && m_Blocks[i].GetYPos() == y)	return true;
	return false;
}


/*
 *  溯Ϊ㷽λ
 */
bool CBody::HasTetrisBlock(int x, int y)
{
	for (int i=0; i<m_Tetris.GetBlockCount(); i++)
		if (m_ptTetris.x + m_Tetris.GetBlock(i).GetXPos() == x && 
			m_ptTetris.y + m_Tetris.GetBlock(i).GetYPos() == y)	return true;
	return false;
}

void CBody::SetComputerCtrl(int &nRoate, int &nMove, int nComputerIntelligence)
{
	CPoint pt = m_ptTetris;
	nRoate = 0;
	nMove = 0;
	int nScore = 0;
	int nR, nM;

	int i, j;
	int nNearNull[9];	//	ſλ
	for (i=0; i<9; i++)
		nNearNull[i] = -1;
	int nFindIndex = 0;
	for (i=1; i<m_nHeight; i++)
	{
		bool bFind = false;
		for (j=0; j<m_nWidth; j++)
		{
			if ( !HasBlock(j, i) && HasBlock(j, i-1) )
			{
				nNearNull[nFindIndex] = j;
				nFindIndex++;
				if (!bFind) bFind = true;
			}
		}
		if (bFind) break;
	}
	
 	for (nR=0; nR<4; nR++)
	{
		for (nM=-4; nM<9; nM++)
		{
			m_ptTetris = pt + CSize(nM, 0);
			int nS = GetScore(nNearNull, nR, nM, nComputerIntelligence);
			if (nS > nScore)
			{
				nScore = nS;
				nRoate = nR;
				nMove = nM;
			}
		}
		m_Tetris.Roate();
	}
	m_ptTetris = pt;
}

int CBody::GetScore(int nNearNull[9], int nRoate, int nMove, int nComputerIntelligence)
{
	if (!IsTetrisFit(m_ptTetris, m_Tetris)) return 0;
	int nScore = 0;
	int nClearLines[4];		//	¼к
	int i, j;
	for (i=0; i<4; i++)
		nClearLines[i] = 0;

	//	
	for (i=1; ; i++)
	{
		if (!IsTetrisFit(m_ptTetris + CSize(0, i), m_Tetris))	break;
	}
	m_ptTetris += CSize(0, i-1);
	
	//	мӷ
	int nLines = 0;
	for (i=m_ptTetris.y; i<m_ptTetris.x+m_Tetris.GetSize(); i++)
	{
		bool bRemove = true;
		for (j=0; j<m_nWidth; j++)
		{
			if (!HasBlock(j, i) && !HasTetrisBlock(j, i))
			{
				bRemove = false;
				break;
			}
		}
		if (bRemove)
		{
			if (nLines < 4) nClearLines[nLines] = i;
			nLines++;
		}
	}
	nScore += nLines * 3000;
	if (nLines == 1) nScore -= 1500;

	//	λõͷ
	for (i=0; i<m_Tetris.GetBlockCount(); i++)
		nScore += (m_ptTetris.y + m_Tetris.GetBlock(i).GetYPos()) * 100;

	//	ռ
	int nNull = 0;
	for (i=0; i<m_Tetris.GetBlockCount(); i++)
	{
		int nX = m_ptTetris.x + m_Tetris.GetBlock(i).GetXPos();
		int nY = m_ptTetris.y + m_Tetris.GetBlock(i).GetYPos();
		if (nY >= m_nHeight-1) continue;
		for (int j=0; j<4; j++)
		{
			if (nClearLines[j] == nY) continue;
		}
		if (!HasBlock(nX, nY+1) && !HasTetrisBlock(nX, nY+1))
		{
			nNull++;
		}
	}
	nScore -= 2000 * nNull;
//	if (nNull) nScore -= 2000;

	if (nComputerIntelligence == 0) return nScore;
	//	߶Ȳ۷, ϼӷ
	int nMinX = 3;
	int nMaxX = 0;
	int nSub;
	for (i=0; i<m_Tetris.GetBlockCount(); i++)
	{
		int nX = m_Tetris.GetBlock(i).GetXPos();
		if (nX > nMaxX) nMaxX = nX;
		if (nX < nMinX) nMinX = nX;
	}
	if (m_ptTetris.x + nMinX > 0)
	{
		nSub = abs(GetCellMaxTier(m_ptTetris.x+nMinX) - GetCellMaxTier(m_ptTetris.x+nMinX-1));
		if (nSub > 2) nScore -= (nSub-2) * 800;
		if (nSub = 2) nScore -= 500;
	}
	else
	{
		nScore += 100;
	}
	if (m_ptTetris.x + nMaxX < m_nWidth-1)
	{
		nSub = abs(GetCellMaxTier(m_ptTetris.x+nMaxX) - GetCellMaxTier(m_ptTetris.x+nMaxX+1));
		if (nSub > 2) nScore -= (nSub-2) * 800;
		if (nSub = 2) nScore -= 500;
	}
	else
	{
		nScore += 100;
	}

	if (nComputerIntelligence == 1) return nScore;
	//	ϲŷ
	i = 0;
	int nBlockOnNull;
	while (nNearNull[i] >= 0)
	{
		nBlockOnNull = 0;
		for (j=0; j<m_Tetris.GetBlockCount(); j++)
		{
			if (m_ptTetris.x + m_Tetris.GetBlock(j).GetXPos() == nNearNull[i])
			{
				nBlockOnNull++;
				break;
			}
		}
		i++;
	}
	nScore -= nBlockOnNull * 800;

	//	ƶ۷
	nScore -= (nRoate + nMove) * 10;

	return nScore;
}

int CBody::GetCellMaxTier(int nCell)
{
	if (nCell < 0 || nCell >= m_nWidth) return 0;
	int i;
	int nY;
	int nTier = m_nHeight-1;
	for (i=0; i<m_Tetris.GetBlockCount(); i++)
	{
		if (m_ptTetris.x + m_Tetris.GetBlock(i).GetXPos() == nCell)
		{
			nY = m_ptTetris.y + m_Tetris.GetBlock(i).GetYPos();
			if (nY < nTier) nTier = nY;
		}
	}
	for (i=0; i<m_Blocks.GetSize(); i++)
	{
		if (m_Blocks[i].GetXPos() == nCell)
		{
			nY = m_Blocks[i].GetYPos();
			if (nY < nTier) nTier = nY;
		}
	}
	return nTier;
}
