// Body.h: interface for the CBody class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BODY_H__9CAB1AD3_F75F_11D4_910A_5254ABDD22CE__INCLUDED_)
#define AFX_BODY_H__9CAB1AD3_F75F_11D4_910A_5254ABDD22CE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Teris.h"
#include "Block.h"

class CBody : public CObject  
{
public:
	CBody();
	CBody(CBody &b);
	virtual ~CBody();

	void SetTetris(const CTetris &Tetris);
	CTetris GetTetris(void)	{	return m_Tetris;	}

	void Draw(CDC &dc);
	void DrawTetris(CDC &dc, bool bNull = false);

	void ReSetBlocks(void)
	{
		m_Blocks.RemoveAll();
		m_Tetris.ReSetBlocks();
	}

	bool IsTetrisFit(const CPoint &pt, CTetris Tetris);
	bool TetrisMove(CDC &dc, const CSize &sz);
	int RemoveLines(void);
	bool HasBlock(int x, int y);
	bool HasTetrisBlock(int x, int y);
	void CutLastTetris(void);
	void SetPoint(const CPoint &pt)	{		m_ptStart = pt;	}
	CPoint GetPoint(void)	{		return m_ptStart;	}

	CPoint GetTetrisPoint(void)	{	return m_ptTetris;	}
	void SetTetrisPoint(const CPoint &pt)	{	m_ptTetris = pt;	}
	void SetComputerCtrl(int &nRoate, int &nMove, int nComputerIntelligence);
	int GetScore(int nNearNull[9], int nRoate, int nMove, int nComputerIntelligence);
	int GetCellMaxTier(int nCell);

	void AddLines(int nLines, int nColor);
	int GetWidth(void)	{	return m_nWidth;	}
	void SetWidth(int w)	{	m_nWidth = w;	}
	int GetHeight(void)	{	return m_nHeight;	}
	void SetHeight(int h)	{	m_nHeight = h;	}
protected:
	CArray<CBlock, CBlock>	m_Blocks;
	CTetris m_Tetris;
	CPoint	m_ptTetris;

	CPoint	m_ptStart;

	int		m_nWidth;
	int		m_nHeight;

public:
	void operator = (const CBody &b)
	{
		m_nWidth = b.m_nWidth;
		m_nHeight = b.m_nHeight;
		m_Tetris = b.m_Tetris;
		m_ptStart = b.m_ptStart;
		m_ptTetris = b.m_ptTetris;
	}
};

#endif // !defined(AFX_BODY_H__9CAB1AD3_F75F_11D4_910A_5254ABDD22CE__INCLUDED_)
