// ChildView.cpp : implementation of the CChildView class
//

#include "stdafx.h"
#include "Tetris.h"
#include "ChildView.h"
#include "DlgOption.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView::CChildView()
{

}

CChildView::~CChildView()
{

}

BEGIN_MESSAGE_MAP(CChildView,CWnd )
	//{{AFX_MSG_MAP(CChildView)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_TIMER()
	ON_WM_KEYDOWN()
	ON_COMMAND(IDM_GAME_START, OnGameStart)
	ON_UPDATE_COMMAND_UI(IDM_GAME_START, OnUpdateGameStart)
	ON_COMMAND(IDM_GAME_SINGLE, OnGameSingle)
	ON_UPDATE_COMMAND_UI(IDM_GAME_SINGLE, OnUpdateGameSingle)
	ON_COMMAND(IDM_GAME_DOUBLE, OnGameDouble)
	ON_UPDATE_COMMAND_UI(IDM_GAME_DOUBLE, OnUpdateGameDouble)
	ON_COMMAND(IDM_GAME_SITZKRIEG, OnGameSitzkrieg)
	ON_UPDATE_COMMAND_UI(IDM_GAME_SITZKRIEG, OnUpdateGameSitzkrieg)
	ON_COMMAND(IDM_GAME_NET, OnGameNet)
	ON_UPDATE_COMMAND_UI(IDM_GAME_NET, OnUpdateGameNet)
	ON_COMMAND(IDM_GAME_COMPUTER, OnGameComputer)
	ON_UPDATE_COMMAND_UI(IDM_GAME_COMPUTER, OnUpdateGameComputer)
	ON_WM_CLOSE()
	ON_COMMAND(IDM_HELP_TEACH, OnHelpTeach)
	ON_UPDATE_COMMAND_UI(IDM_HELP_TEACH, OnUpdateHelpTeach)
	ON_COMMAND(IDM_OPTION, OnOption)
	ON_COMMAND(IDM_OPTION_SETTING, OnOptionSetting)
	ON_COMMAND(IDM_OPTION_CHINESE, OnOptionChinese)
	ON_COMMAND(IDM_OPTION_ENGLISH, OnOptionEnglish)
	ON_UPDATE_COMMAND_UI(IDM_OPTION_CHINESE, OnUpdateOptionChinese)
	ON_UPDATE_COMMAND_UI(IDM_OPTION_ENGLISH, OnUpdateOptionEnglish)
	ON_UPDATE_COMMAND_UI(ID_APP_EXIT, OnUpdateAppExit)
	ON_UPDATE_COMMAND_UI(IDM_OPTION_SETTING, OnUpdateOptionSetting)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildView message handlers

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);

	return TRUE;
}

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here

	for (int i=0; i<MAX_GAMES; i++)
	{
		m_Games[i].Draw(dc);
	}
	// Do not call CWnd::OnPaint() for painting messages
}

void CChildView::FitWindowSize(void)
{
	int nScreenX = ::GetSystemMetrics(SM_CXSCREEN);
	int nScreenY = ::GetSystemMetrics(SM_CYSCREEN);
	int cx, cy;

	for (int nCell=CBlock::GetCell(); nCell>0; nCell--)
	{
		int x = 0;
		int y = 0;

		CBlock::SetCell(nCell);
		for (int i=0; i<MAX_GAMES; i++)
		{
			if (m_Games[i].IsActive())
			{
				x += m_Games[i].GetSize().cx;
				y =  m_Games[i].GetSize().cy;
			}
		}

		if (x==0 || y==0) return;

		int iWinBorderX = GetSystemMetrics(SM_CXBORDER);
		int iWinBorderY = GetSystemMetrics(SM_CYBORDER);
		int iCaptionY = GetSystemMetrics(SM_CYCAPTION);
		int iMenuY = GetSystemMetrics(SM_CYMENU);
		cx = x + 2 * iWinBorderX + 8;
		cy = y + 2 * iWinBorderY + iCaptionY + iMenuY + 8;
		if (cx < nScreenX && cy < nScreenY) break;
	}
	::SetWindowPos(AfxGetMainWnd()->m_hWnd, NULL, 0, 0, cx, cy, SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE);
}

int CChildView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd ::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	for (int i=0; i<MAX_GAMES; i++)
	{
		CGame *pTempGame = new CGame;
		m_Games.Add(*pTempGame);
		delete pTempGame;
		pTempGame = NULL;
	}
	srand( (unsigned)time( NULL));

	for (i=0; i<MAX_GAMES; i++)
	{
		m_Games[i].SetView(this);
		m_Games[i].SetIndex(i);

		CPoint ptStart;
		if (i == 0)
			ptStart = CPoint(0, 0);
		else
			ptStart = CPoint(m_Games[0].GetSize().cx, 0);
		m_Games[i].SetPoint(ptStart);
		
		m_Games[i].SetStatus(CGame::STATUS_WAIT);
	}

	m_Games[0].SetActive(TRUE);
	FitWindowSize();

	CTetrisApp *pApp = (CTetrisApp*)AfxGetApp();
	if (SetDefaultValue(pApp))
		SaveProfileValue(pApp);
	else
		GetProfileValue(pApp);

	LangueChange(pApp->GetProfileInt("Langue", "Langue", CTetrisApp::CHINESE));
	CGame::SetType(m_nDefaultGameType);
	Invalidate();
	return 0;
}

void CChildView::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	for (int i=0; i<MAX_GAMES; i++)
	{
		if ( (i == 0 && TIMER_INDEX_1 == nIDEvent) || (i == 1 && TIMER_INDEX_2 == nIDEvent) )
		{
			if (m_Games[i].IsComputer() && !m_Games[i].HasComputerCtrl() && m_Games[i].IsComputerCanFallDown())
				m_Games[i].TetrisMove(CSize(1, 1));
			else
				m_Games[i].TetrisMove(CSize(0, 1));
			break;
		}
		if ((CGame::GetType() == CGame::TYPE_COMPUTER || CGame::GetType() == CGame::TYPE_TEACH) 
			&& m_Games[i].IsComputer() && TIMER_COMPUTER == nIDEvent)
			m_Games[i].ComputerCtrlTetris();
	}
	CWnd ::OnTimer(nIDEvent);
}

void CChildView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
/*	CString str;
	str.Format("%d  ", nChar);
	str += CString(nChar);
	MessageBox(str);
*/	// TODO: Add your message handler code here and/or call default
	int nIndex;
	CSize sz = CSize(-1, -1);
	for (nIndex=0; nIndex<MAX_GAMES; nIndex++)
	{
		sz = m_Games[nIndex].MatchKey(nChar);
		if (sz != CSize(-1, -1))	break;
	}
/*
	switch (nChar)
	{
    case VK_NUMPAD4:		//	move left
    case VK_LEFT:
		sz = CSize(-1, 0);
		break;

    case VK_NUMPAD6:		//	move right
    case VK_RIGHT:
		sz = CSize(1, 0);
		break;

    case VK_NUMPAD8:		//	roate
    case VK_UP:
		sz = CSize(0, 0);
		break;

    case VK_NUMPAD2:		//	fall down
    case VK_DOWN:
		sz = CSize(1, 1);
		break;

	default:
		sz = CSize(-1, -1);
		
	}
*/
	if (sz != CSize(-1, -1))
	{
		if ( m_Games[nIndex].GetStatus() == CGame::STATUS_OVER && sz == CSize(0, 0) && 
			(m_Games[nIndex].GetType() == CGame::TYPE_SINGLE || m_Games[nIndex].GetType() == CGame::TYPE_DOUBLE) )
		{
			m_Games[nIndex].StartGame (m_nStartSpeed[nIndex], m_nStartLines[nIndex], m_nTetrisType[nIndex], 
			m_nCtrlKeys[nIndex], m_nColorType);
			Invalidate();
			goto End;
		}
		if (m_Games[nIndex].GetStatus() != CGame::STATUS_RUN) goto End;
		m_Games[nIndex].TetrisMove(sz);
	}
End:
	CWnd ::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CChildView::GetProfileValue(CTetrisApp* pApp)
{
	m_nStartSpeed[0] = pApp->GetProfileInt("Difficute", "Speed1", 0);
	m_nStartSpeed[1] = pApp->GetProfileInt("Difficute", "Speed2", 0);
	m_nStartLines[0] = pApp->GetProfileInt("Difficute", "Lines1", 0);
	m_nStartLines[1] = pApp->GetProfileInt("Difficute", "Lines2", 0);
	m_nTetrisType[0] = pApp->GetProfileInt("Difficute", "TetrisType1", CGame::TETRIS_BASE);
	m_nTetrisType[1] = pApp->GetProfileInt("Difficute", "TetrisType2", CGame::TETRIS_BASE);

	m_nColorType = pApp->GetProfileInt("Display", "ColorType", 0);
	COLORREF colDefault = RGB(51, 204, 102);
	CString str;
	for (int i=0; i<MAX_COLORS; i++)
	{
		str.Format("TetrisColor%d", i);
		m_nColorRef[i] = pApp->GetProfileInt("Display", str, colDefault);
	}

	m_nComputerIntelligence = pApp->GetProfileInt("Computer", "Intelligence", 2);
	m_bComputerFallDown = pApp->GetProfileInt("Computer", "FallDown", 1);

	m_nCtrlKeys[0][0] = pApp->GetProfileInt("Operate", "Left1", VK_LEFT);
	m_nCtrlKeys[0][1] = pApp->GetProfileInt("Operate", "Right1", VK_RIGHT);
	m_nCtrlKeys[0][2] = pApp->GetProfileInt("Operate", "Roate1", VK_UP);
	m_nCtrlKeys[0][3] = pApp->GetProfileInt("Operate", "Down1", VK_DOWN);
	m_nCtrlKeys[1][0] = pApp->GetProfileInt("Operate", "Left2", 'A');
	m_nCtrlKeys[1][1] = pApp->GetProfileInt("Operate", "Right2", 'D');
	m_nCtrlKeys[1][2] = pApp->GetProfileInt("Operate", "Roate2", 'W');
	m_nCtrlKeys[1][3] = pApp->GetProfileInt("Operate", "Down2", 'S');
	m_nDefaultGameType = pApp->GetProfileInt("Operate", "GameType", 0);
}

void CChildView::SaveProfileValue(CTetrisApp* pApp)
{
	pApp->WriteProfileInt("Difficute", "Speed1", m_nStartSpeed[0]);
	pApp->WriteProfileInt("Difficute", "Speed2", m_nStartSpeed[1]);
	pApp->WriteProfileInt("Difficute", "Lines1", m_nStartLines[0]);
	pApp->WriteProfileInt("Difficute", "Lines2", m_nStartLines[1]);
	pApp->WriteProfileInt("Difficute", "TetrisType1", m_nTetrisType[0]);
	pApp->WriteProfileInt("Difficute", "TetrisType2", m_nTetrisType[1]);

	pApp->WriteProfileInt("Display", "ColorType", m_nColorType);
	CString str;
	for (int i=0; i<MAX_COLORS; i++)
	{
		str.Format("TetrisColor%d", i);
		pApp->WriteProfileInt("Display", str, m_nColorRef[i]);
	}

	pApp->WriteProfileInt("Computer", "Intelligence", m_nComputerIntelligence);
	pApp->WriteProfileInt("Computer", "FallDown", m_bComputerFallDown);

	pApp->WriteProfileInt("Operate", "Left1", m_nCtrlKeys[0][0]);
	pApp->WriteProfileInt("Operate", "Right1", m_nCtrlKeys[0][1]);
	pApp->WriteProfileInt("Operate", "Roate1", m_nCtrlKeys[0][2]);
	pApp->WriteProfileInt("Operate", "Down1", m_nCtrlKeys[0][3]);
	pApp->WriteProfileInt("Operate", "Left2", m_nCtrlKeys[1][0]);
	pApp->WriteProfileInt("Operate", "Right2", m_nCtrlKeys[1][1]);
	pApp->WriteProfileInt("Operate", "Roate2", m_nCtrlKeys[1][2]);
	pApp->WriteProfileInt("Operate", "Down2", m_nCtrlKeys[1][3]);
	pApp->WriteProfileInt("Operate", "GameType", m_nDefaultGameType);
}

BOOL CChildView::SetDefaultValue(CTetrisApp* pApp, BOOL bReset)
{
	if (!bReset)
	{
		int nRunTimes = pApp->GetProfileInt("Version", "RunTimes", 0);
		if (nRunTimes)
		{
			pApp->WriteProfileInt("Version", "RunTimes", ++nRunTimes);
			return FALSE;
		}
		else
		{
			pApp->WriteProfileString("Version", "Write By", "Rigel(Yang-Zhan-Jin)");
			pApp->WriteProfileString("Version", "Version", "1.0");
			pApp->WriteProfileString("Version", "OverDate", "03-12-2001");
			pApp->WriteProfileInt("Version", "RunTimes", 1);
			SetLangueInfo(pApp);
		}
	}

	m_nStartSpeed[0] = 0;
	m_nStartSpeed[1] = 0;
	m_nStartLines[0] = 0;
	m_nStartLines[1] = 0;
	m_nTetrisType[0] = CGame::TETRIS_BASE;
	m_nTetrisType[1] = CGame::TETRIS_BASE;

	m_nColorType = 0;
	m_nColorRef[0] = RGB(51, 204, 102);			// 	Default color, or extend block color
	m_nColorRef[1] = RGB(200, 200, 102);		// 
	m_nColorRef[2] = RGB(233, 121, 118);		// ש
	m_nColorRef[3] = RGB(0, 143, 224);			// 
	m_nColorRef[4] = RGB(153, 153, 204);		// 
	m_nColorRef[5] = RGB(204, 204, 204);		// 
	m_nColorRef[6] = RGB(232, 123,  20);		// 
	m_nColorRef[7] = RGB(235,  88, 235);		// 
	m_nColorRef[8] = RGB(220,  39,  75);		// 	
	m_nColorRef[9] = RGB(51, 204, 102);			// 	Default color, or extend block color
	m_nColorRef[10] = RGB(51, 204, 102);		// 	Default color, or extend block color
	m_nColorRef[11] = RGB(51, 204, 102);		// 	Default color, or extend block color
	m_nColorRef[12] = RGB(51, 204, 102);		// 	Default color, or extend block color
	m_nColorRef[13] = RGB(51, 204, 102);		// 	Default color, or extend block color
	m_nColorRef[14] = RGB(51, 204, 102);		// 	Default color, or extend block color
	m_nColorRef[15] = RGB(51, 204, 102);		// 	Default color, or extend block color
	m_nColorRef[16] = RGB(51, 204, 102);		// 	Default color, or extend block color
	m_nColorRef[17] = RGB(51, 204, 102);		// 	Default color, or extend block color
	m_nColorRef[18] = RGB(51, 204, 102);		// 	Default color, or extend block color
	m_nColorRef[19] = RGB(51, 204, 102);		// 	Default color, or extend block color
	m_nColorRef[20] = RGB(51, 204, 102);		// 	Default color, or extend block color
	m_nColorRef[21] = RGB(51, 204, 102);		// 	Default color, or extend block color

	m_nComputerIntelligence = 2;
	m_bComputerFallDown = 1;

	m_nCtrlKeys[0][0] = VK_LEFT;
	m_nCtrlKeys[0][1] = VK_RIGHT;
	m_nCtrlKeys[0][2] = VK_UP;
	m_nCtrlKeys[0][3] = VK_DOWN;
	m_nCtrlKeys[1][0] = 'A';
	m_nCtrlKeys[1][1] = 'D';
	m_nCtrlKeys[1][2] = 'W';
	m_nCtrlKeys[1][3] = 'S';
	m_nDefaultGameType = 0;

	return TRUE;
}

void CChildView::SetLangueInfo(CTetrisApp* pApp)
{
	CString strChinese = CString("Langue\\Chinese");
	CString strEnglish = CString("Langue\\English");

	pApp->WriteProfileString(strEnglish, "AppName", "Tetris");
	pApp->WriteProfileString(strChinese, "AppName", "˹");

	pApp->WriteProfileString(strEnglish, "Next", "Next:");
	pApp->WriteProfileString(strChinese, "Next", "һ:");
	pApp->WriteProfileString(strEnglish, "Score", "Score:");
	pApp->WriteProfileString(strChinese, "Score", ":");
	pApp->WriteProfileString(strEnglish, "Lines", "Lines:");
	pApp->WriteProfileString(strChinese, "Lines", ":");
	pApp->WriteProfileString(strEnglish, "Speed", "Speed:");
	pApp->WriteProfileString(strChinese, "Speed", "ٶ:");

	pApp->WriteProfileString(strEnglish, "GameWin", "GAME WIN");
	pApp->WriteProfileString(strChinese, "GameWin", "Ϸʤ");
	pApp->WriteProfileString(strEnglish, "GameOver", "GAME OVER");
	pApp->WriteProfileString(strChinese, "GameOver", "Ϸ");
	pApp->WriteProfileString(strEnglish, "GameWait", "TETRIS");
	pApp->WriteProfileString(strChinese, "GameWait", "˹");
	pApp->WriteProfileString(strEnglish, "ReStart", "ReStart Game?");
	pApp->WriteProfileString(strChinese, "ReStart", "¿ʼϷ?");
	
	//
	pApp->WriteProfileString(strEnglish, "Game", "&Game");
	pApp->WriteProfileString(strChinese, "Game", "Ϸ(&G)");

	pApp->WriteProfileString(strEnglish, "Start", "&New Game");
	pApp->WriteProfileString(strChinese, "Start", "ʼ(&N)");
	pApp->WriteProfileString(strEnglish, "Single", "&Single Player");
	pApp->WriteProfileString(strChinese, "Single", "Ϸ(&S)");
	pApp->WriteProfileString(strEnglish, "Double", "&Double Players");
	pApp->WriteProfileString(strChinese, "Double", "˫Ϸ(&D)");
	pApp->WriteProfileString(strEnglish, "Sitzkrieg", "Double Si&tzkrieg");
	pApp->WriteProfileString(strChinese, "Sitzkrieg", "˫˶ս(&T)");
	pApp->WriteProfileString(strEnglish, "Net", "N&et Sitzkrieg");
	pApp->WriteProfileString(strChinese, "Net", "ս(&E)");
	pApp->WriteProfileString(strEnglish, "Computer", "Sitzkrieg with &Computer");
	pApp->WriteProfileString(strChinese, "Computer", "˻ս(&C)");
	pApp->WriteProfileString(strEnglish, "Exit", "E&xit");
	pApp->WriteProfileString(strChinese, "Exit", "˳(&X)");

	//
	pApp->WriteProfileString(strEnglish, "&Option", "&Option");
	pApp->WriteProfileString(strChinese, "&Option", "ѡ(&O)");

	pApp->WriteProfileString(strEnglish, "Setting", "&Setting...");
	pApp->WriteProfileString(strChinese, "Setting", "(&S)...");
	pApp->WriteProfileString(strEnglish, "Langue", "Choose &Langue");
	pApp->WriteProfileString(strChinese, "Langue", "ѡ(&L)");

	//
	pApp->WriteProfileString(strEnglish, "Help", "&Help");
	pApp->WriteProfileString(strChinese, "Help", "(&H)");

	pApp->WriteProfileString(strEnglish, "Teach", "&Teaching");
	pApp->WriteProfileString(strChinese, "Teach", "ѧ(&T)");
	pApp->WriteProfileString(strEnglish, "About", "&About Tetris...");
	pApp->WriteProfileString(strChinese, "About", "ڶ˹(&A)...");

	pApp->WriteProfileString(strEnglish, "About Tetris", "About Tetris");
	pApp->WriteProfileString(strChinese, "About Tetris", "ڶ˹");
	pApp->WriteProfileString(strEnglish, "Version", "Tetris Version 1.0");
	pApp->WriteProfileString(strChinese, "Version", "˹ 1.0 ");
	pApp->WriteProfileString(strEnglish, "Copyright", "Copyright (C) Rigel 2001");
	pApp->WriteProfileString(strChinese, "Copyright", "Ȩ (C) Rigel 2001");

	//
	pApp->WriteProfileString(strEnglish, "Option", "Option");
	pApp->WriteProfileString(strChinese, "Option", "ѡ");

	pApp->WriteProfileString(strEnglish, "OK", "&OK");
	pApp->WriteProfileString(strChinese, "OK", "ȷ(&O)");
	pApp->WriteProfileString(strEnglish, "Cancel", "&Cancel");
	pApp->WriteProfileString(strChinese, "Cancel", "ȡ(&C)");
	pApp->WriteProfileString(strEnglish, "Save", "&Save");
	pApp->WriteProfileString(strChinese, "Save", "(S)");
	pApp->WriteProfileString(strEnglish, "Reset", "&Reset All");
	pApp->WriteProfileString(strChinese, "Reset", "ȫ(R)");

	//
	pApp->WriteProfileString(strEnglish, "Computer Attrib", "Computer Attrib");
	pApp->WriteProfileString(strChinese, "Computer Attrib", "");
	pApp->WriteProfileString(strEnglish, "Inteligence", "Inteligence:");
	pApp->WriteProfileString(strChinese, "Inteligence", "̶ܳ:");
	pApp->WriteProfileString(strEnglish, "FallDown", "Can Fall Down:");
	pApp->WriteProfileString(strChinese, "FallDown", "ֱ:");
	pApp->WriteProfileString(strEnglish, "Normal", "Normal");
	pApp->WriteProfileString(strChinese, "Normal", "һ");
	pApp->WriteProfileString(strEnglish, "Good", "Good");
	pApp->WriteProfileString(strChinese, "Good", "");
	pApp->WriteProfileString(strEnglish, "Very Good", "Very Good");
	pApp->WriteProfileString(strChinese, "Very Good", "ܴ");
	pApp->WriteProfileString(strEnglish, "YES", "YES");
	pApp->WriteProfileString(strChinese, "YES", "");
	pApp->WriteProfileString(strEnglish, "NO", "NO");
	pApp->WriteProfileString(strChinese, "NO", "");

	//
	pApp->WriteProfileString(strEnglish, "Difficute", "Difficute");
	pApp->WriteProfileString(strChinese, "Difficute", "Ѷ");
	pApp->WriteProfileString(strEnglish, "Start Speed", "Start Speed:");
	pApp->WriteProfileString(strChinese, "Start Speed", "ʼٶ:");
	pApp->WriteProfileString(strEnglish, "Start Lines", "Start Lines:");
	pApp->WriteProfileString(strChinese, "Start Lines", "ֱ:");
	pApp->WriteProfileString(strEnglish, "Tetris Type", "Tetris Type");
	pApp->WriteProfileString(strChinese, "Tetris Type", "");
	pApp->WriteProfileString(strEnglish, "Base Type", "Base Type");
	pApp->WriteProfileString(strChinese, "Base Type", "");
	pApp->WriteProfileString(strEnglish, "Extend Type", "Extend Type");
	pApp->WriteProfileString(strChinese, "Extend Type", "չ");
	pApp->WriteProfileString(strEnglish, "Easy Type", "Easy Type");
	pApp->WriteProfileString(strChinese, "Easy Type", "");

	//
	pApp->WriteProfileString(strEnglish, "Display", "Display");
	pApp->WriteProfileString(strChinese, "Display", "ʾ");
	pApp->WriteProfileString(strEnglish, "Tetris Color", "Tetris Color:");
	pApp->WriteProfileString(strChinese, "Tetris Color", "ɫ:");
	pApp->WriteProfileString(strEnglish, "Set Tetris Color", "Set Color");
	pApp->WriteProfileString(strChinese, "Set Tetris Color", "÷ɫ");
	pApp->WriteProfileString(strEnglish, "Set Color", "Set...");
	pApp->WriteProfileString(strChinese, "Set Color", "ɫ...");
	pApp->WriteProfileString(strEnglish, "Own", "Use own color");
	pApp->WriteProfileString(strChinese, "Own", "ʹøԲͬɫ");
	pApp->WriteProfileString(strEnglish, "Same", "Use same color");
	pApp->WriteProfileString(strChinese, "Same", "ʹͬɫ");
	pApp->WriteProfileString(strEnglish, "Random", "Use random color");
	pApp->WriteProfileString(strChinese, "Random", "ʹɫ");

	//
	pApp->WriteProfileString(strEnglish, "Operate", "Operate");
	pApp->WriteProfileString(strChinese, "Operate", "");
	pApp->WriteProfileString(strEnglish, "Roate", "Roate:");
	pApp->WriteProfileString(strChinese, "Roate", "ת:");
	pApp->WriteProfileString(strEnglish, "Fall Down", "Fall Down:");
	pApp->WriteProfileString(strChinese, "Fall Down", ":");
	pApp->WriteProfileString(strEnglish, "Move Left", "Move Left:");
	pApp->WriteProfileString(strChinese, "Move Left", ":");
	pApp->WriteProfileString(strEnglish, "Move Right", "Move Right:");
	pApp->WriteProfileString(strChinese, "Move Right", ":");
	pApp->WriteProfileString(strEnglish, "Default Game Type", "Default Game Type:");
	pApp->WriteProfileString(strChinese, "Default Game Type", "ĬϷ:");
	pApp->WriteProfileString(strEnglish, "Save Window Position", "&Save Window Position");
	pApp->WriteProfileString(strChinese, "Save Window Position", "洰λ(&S)");
	pApp->WriteProfileString(strEnglish, "_Single", "Single Player");
	pApp->WriteProfileString(strChinese, "_Single", "Ϸ");
	pApp->WriteProfileString(strEnglish, "_Double", "Double Players");
	pApp->WriteProfileString(strChinese, "_Double", "˫Ϸ");
	pApp->WriteProfileString(strEnglish, "_Sitzkrieg", "Double Sitzkrieg");
	pApp->WriteProfileString(strChinese, "_Sitzkrieg", "˫˶ս");
	pApp->WriteProfileString(strEnglish, "_Net", "Net Sitzkrieg");
	pApp->WriteProfileString(strChinese, "_Net", "ս");
	pApp->WriteProfileString(strEnglish, "_Computer", "Sitzkrieg with Computer");
	pApp->WriteProfileString(strChinese, "_Computer", "˻ս");

	pApp->WriteProfileString(strEnglish, "Set Key", "Set Key");
	pApp->WriteProfileString(strChinese, "Set Key", "ü");
	pApp->WriteProfileString(strEnglish, "Select Key", "Please select a Key");
	pApp->WriteProfileString(strChinese, "Select Key", "ѡһ");
	pApp->WriteProfileString(strEnglish, "Key Used", "The KEY has been defined, please choose another.");
	pApp->WriteProfileString(strChinese, "Key Used", "ѡѶ壬ѡ");

	pApp->WriteProfileString(strEnglish, "Player1", "PlayerI");
	pApp->WriteProfileString(strChinese, "Player1", "I");
	pApp->WriteProfileString(strEnglish, "Player2", "PlayerII");
	pApp->WriteProfileString(strChinese, "Player2", "II");

}

void CChildView::GameAddLines(int nIndex, int nLines)
{
	int nGame;
	if (nIndex == 1)
		nGame = 0;
	else if (nIndex == 0)
		nGame = 1;
	else
		return;
	m_Games[nGame].AddLines(nLines);
}

void CChildView::GameWin(int nIndex)
{
	int nGame;
	if (nIndex == 1)
		nGame = 0;
	else if (nIndex == 0)
		nGame = 1;
	else
		return;
	if (m_Games[nGame].GetStatus() == CGame::STATUS_RUN)
	{
		m_Games[nGame].SetWin();
		m_Games[nGame].EndGame();
	}
}

void CChildView::OnGameStart() 
{
	// TODO: Add your command handler code here
	int i;
	BOOL bCheckReStart = FALSE;
	for (i=0; i<MAX_GAMES; i++)
	{
		if (m_Games[i].GetStatus() == CGame::STATUS_RUN)
		{
			if (!bCheckReStart)
			{
				bCheckReStart = TRUE;
				if (MessageBox(GetLangueString("ReStart"), GetLangueString("AppName"), 
					MB_OKCANCEL|MB_ICONQUESTION) == IDCANCEL) return;
			}
			m_Games[i].EndGame(FALSE);
		}
	}

	m_Games[1].SetActive(!(CGame::GetType() == CGame::TYPE_TEACH || CGame::GetType() == CGame::TYPE_SINGLE));
	m_Games[0].SetComputer(CGame::GetType() == CGame::TYPE_TEACH);
	m_Games[1].SetComputer(CGame::GetType() == CGame::TYPE_COMPUTER);

	CGame::SetComputerCanFallDown(m_bComputerFallDown);
	CGame::SetComputerIntelligence(m_nComputerIntelligence);

	for (i=0; i<MAX_COLORS; i++)
		CTetris::COLOR_TYPE[i] = m_nColorRef[i];

	for (i=0; i<MAX_GAMES; i++)
	{
		if (m_Games[i].IsActive())
			m_Games[i].StartGame (m_nStartSpeed[i], m_nStartLines[i], m_nTetrisType[i], m_nCtrlKeys[i], m_nColorType);
	}
	FitWindowSize();
	Invalidate();
}

void CChildView::OnUpdateGameStart(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetText(GetLangueString("Start"));
}

void CChildView::OnGameSingle() 
{
	// TODO: Add your command handler code here
	CGame::SetType(CGame::TYPE_SINGLE);
	OnGameStart();
}

void CChildView::OnUpdateGameSingle(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(CGame::GetType() == CGame::TYPE_SINGLE);
	pCmdUI->SetText(GetLangueString("Single"));
}

void CChildView::OnGameDouble() 
{
	// TODO: Add your command handler code here
	CGame::SetType(CGame::TYPE_DOUBLE);
	OnGameStart();
}

void CChildView::OnUpdateGameDouble(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(CGame::GetType() == CGame::TYPE_DOUBLE);
	pCmdUI->SetText(GetLangueString("Double"));
}

void CChildView::OnGameSitzkrieg() 
{
	// TODO: Add your command handler code here
	CGame::SetType(CGame::TYPE_SITZKRIEG);
	OnGameStart();
}

void CChildView::OnUpdateGameSitzkrieg(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(CGame::GetType() == CGame::TYPE_SITZKRIEG);
	pCmdUI->SetText(GetLangueString("Sitzkrieg"));
}

void CChildView::OnGameNet() 
{
	// TODO: Add your command handler code here
	CGame::SetType(CGame::TYPE_NET);
	OnGameStart();
}

void CChildView::OnUpdateGameNet(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(CGame::GetType() == CGame::TYPE_NET);
	pCmdUI->SetText(GetLangueString("Net"));
}

void CChildView::OnGameComputer() 
{
	// TODO: Add your command handler code here
	CGame::SetType(CGame::TYPE_COMPUTER);
	OnGameStart();
}

void CChildView::OnUpdateGameComputer(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(CGame::GetType() == CGame::TYPE_COMPUTER);
	pCmdUI->SetText(GetLangueString("Computer"));
}

void CChildView::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	for (int i=0; i<MAX_GAMES; i++)
	{
		m_Games[i].EndGame();
	}
//	if (AfxGetApp()->GetProfileInt("Operate", "SavePos", 0))
//	{
		CRect rect;
		::GetWindowRect(AfxGetApp()->m_pMainWnd->m_hWnd, &rect);
		AfxGetApp()->WriteProfileInt("Operate", "XPos", rect.left);
		AfxGetApp()->WriteProfileInt("Operate", "YPos", rect.top);
//	}
	CWnd ::OnClose();
}

void CChildView::OnHelpTeach() 
{
	// TODO: Add your command handler code here
	bool bTeach = CGame::GetType() == CGame::TYPE_TEACH;
	if (bTeach)
	{
		CGame::SetType(m_nLastGameType);
		m_Games[0].EndGame();
		m_Games[0].SetStatus(CGame::STATUS_WAIT);
		Invalidate();
	}
	else
	{
		m_nLastGameType = CGame::GetType();
		CGame::SetType(CGame::TYPE_TEACH);
		OnGameStart();
	}
}

void CChildView::OnUpdateHelpTeach(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(CGame::GetType() == CGame::TYPE_TEACH);
	pCmdUI->SetText(GetLangueString("Teach"));
}

void CChildView::OnOption() 
{
	// TODO: Add your command handler code here
}

void CChildView::OnOptionSetting() 
{
	// TODO: Add your command handler code here
	CDlgOption dlgOption(this);
	dlgOption.DoModal();
}

void CChildView::OnUpdateOptionSetting(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetText(GetLangueString("Setting"));
}

void CChildView::OnOptionChinese() 
{
	// TODO: Add your command handler code here
	if (CTetrisApp::m_nLangue == CTetrisApp::CHINESE) return;
	LangueChange(CTetrisApp::CHINESE);
	Invalidate();
}

void CChildView::OnOptionEnglish() 
{
	// TODO: Add your command handler code here
	if (CTetrisApp::m_nLangue == CTetrisApp::ENGLISH) return;
	LangueChange(CTetrisApp::ENGLISH);
	Invalidate();
}

void CChildView::OnUpdateOptionChinese(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(CTetrisApp::m_nLangue == CTetrisApp::CHINESE);
}

void CChildView::OnUpdateOptionEnglish(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(CTetrisApp::m_nLangue == CTetrisApp::ENGLISH);
}

void CChildView::OnUpdateAppExit(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetText(GetLangueString("Exit"));
}

