// ChildView.h : interface of the CChildView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_CHILDVIEW_H__9CAB1ACB_F75F_11D4_910A_5254ABDD22CE__INCLUDED_)
#define AFX_CHILDVIEW_H__9CAB1ACB_F75F_11D4_910A_5254ABDD22CE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Game.h"

class CGame;
/////////////////////////////////////////////////////////////////////////////
// CChildView window

class CChildView : public CWnd
{
// Construction
public:
	CChildView();
	virtual ~CChildView();

// Attributes
public:
	CArray<CGame, CGame> m_Games;

	void FitWindowSize(void);
	void GameAddLines(int nIndex, int nLines);
	void GameWin(int nIndex);
	void GetProfileValue(CTetrisApp* pApp);
	void SaveProfileValue(CTetrisApp* pApp);
	BOOL SetDefaultValue(CTetrisApp* pApp, BOOL bReset = FALSE);
	void SetLangueInfo(CTetrisApp* pApp);

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChildView)
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation

public:
	int m_nLastGameType;
	int m_nDefaultGameType;

	int m_nStartSpeed[MAX_GAMES];
	int m_nStartLines[MAX_GAMES];
	int m_nTetrisType[MAX_GAMES];

	int m_nColorType;
	int m_nColorRef[MAX_COLORS];

	int m_nComputerIntelligence;
	BOOL m_bComputerFallDown;

	UINT m_nCtrlKeys[MAX_GAMES][MAX_CTRL_KEYS];

	// Generated message map functions
protected:
	//{{AFX_MSG(CChildView)
	afx_msg void OnPaint();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnGameStart();
	afx_msg void OnUpdateGameStart(CCmdUI* pCmdUI);
	afx_msg void OnGameSingle();
	afx_msg void OnUpdateGameSingle(CCmdUI* pCmdUI);
	afx_msg void OnGameDouble();
	afx_msg void OnUpdateGameDouble(CCmdUI* pCmdUI);
	afx_msg void OnGameSitzkrieg();
	afx_msg void OnUpdateGameSitzkrieg(CCmdUI* pCmdUI);
	afx_msg void OnGameNet();
	afx_msg void OnUpdateGameNet(CCmdUI* pCmdUI);
	afx_msg void OnGameComputer();
	afx_msg void OnUpdateGameComputer(CCmdUI* pCmdUI);
	afx_msg void OnClose();
	afx_msg void OnHelpTeach();
	afx_msg void OnUpdateHelpTeach(CCmdUI* pCmdUI);
	afx_msg void OnOption();
	afx_msg void OnOptionSetting();
	afx_msg void OnOptionChinese();
	afx_msg void OnOptionEnglish();
	afx_msg void OnUpdateOptionChinese(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOptionEnglish(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAppExit(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOptionSetting(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHILDVIEW_H__9CAB1ACB_F75F_11D4_910A_5254ABDD22CE__INCLUDED_)
