// CoolButton.cpp : implementation file
//

#include "stdafx.h"
#include "CoolButton.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCoolButton

CCoolButton::CCoolButton()
{
#ifdef XS_FLAT_BUTTON
	m_MouseOnButton = FALSE;
#endif

	m_hIcon = NULL;
	m_cxIcon = 0;
	m_cyIcon = 0;

}

CCoolButton::~CCoolButton()
{
}


BEGIN_MESSAGE_MAP(CCoolButton, CButton)
	//{{AFX_MSG_MAP(CCoolButton)
	ON_WM_MOUSEMOVE()
	ON_WM_KILLFOCUS()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCoolButton message handlers

void CCoolButton::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: Add your code to draw the specified item
	CDC* pDC = CDC::FromHandle(lpDrawItemStruct->hDC);

	unsigned int IsPressed = (lpDrawItemStruct->itemState & ODS_SELECTED);
	unsigned int IsFocused = (lpDrawItemStruct->itemState & ODS_FOCUS);
	unsigned int IsDisabled = (lpDrawItemStruct->itemState & ODS_DISABLED);

	CRect itemRect = lpDrawItemStruct->rcItem;

#ifdef XS_FLAT_BUTTON
	if (IsFocused)
	{
		if (m_MouseOnButton)	//	Add by Rigel
		{
			CBrush br(RGB(0, 0, 0));
			pDC->FrameRect(&itemRect, &br);
			itemRect.DeflateRect(1, 1);
		}
	}
#endif

	CBrush br(GetSysColor(COLOR_BTNFACE));
	pDC->FillRect(&itemRect, &br);

	if (IsPressed)
	{
#ifdef XS_FLAT_BUTTON
		CPen penBtnHiLight(PS_SOLID, 0, GetSysColor(COLOR_BTNHILIGHT));
		CPen penBtnShadow(PS_SOLID, 0, GetSysColor(COLOR_BTNSHADOW));

		pDC->SelectObject(penBtnShadow);
		pDC->MoveTo(itemRect.left, itemRect.bottom-1);
		pDC->LineTo(itemRect.left, itemRect.top);
		pDC->LineTo(itemRect.right, itemRect.top);

		pDC->SelectObject(penBtnHiLight);
		pDC->MoveTo(itemRect.left, itemRect.bottom-1);
		pDC->LineTo(itemRect.right-1, itemRect.bottom-1);
		pDC->LineTo(itemRect.right-1, itemRect.top-1);
#else
		CBrush brBtnShadow(GetSysColor(COLOR_BTNSHADOW));
		pDC->FrameRect(&itemRect, &brBtnShadow);
#endif
	}
	else
	{
		CPen penBtnHiLight(PS_SOLID, 0, GetSysColor(COLOR_BTNHILIGHT));
		CPen pen3DLight(PS_SOLID, 0, GetSysColor(COLOR_3DLIGHT));
		CPen penBtnShadow(PS_SOLID, 0, GetSysColor(COLOR_BTNSHADOW));
		CPen pen3DKShadow(PS_SOLID, 0, GetSysColor(COLOR_3DDKSHADOW));

#ifdef XS_FLAT_BUTTON
		if (m_MouseOnButton == TRUE)
		{
			pDC->SelectObject(penBtnHiLight);
			pDC->MoveTo(itemRect.left, itemRect.bottom-1);
			pDC->LineTo(itemRect.left, itemRect.top);
			pDC->LineTo(itemRect.right, itemRect.top);

			pDC->SelectObject(penBtnShadow);
			pDC->MoveTo(itemRect.left, itemRect.bottom-1);
			pDC->LineTo(itemRect.right-1, itemRect.bottom-1);
			pDC->LineTo(itemRect.right-1, itemRect.top-1);
		}
#else
		pDC->SelectObject(penBtnHiLight);
		pDC->MoveTo(itemRect.left, itemRect.bottom-1);
		pDC->LineTo(itemRect.left, itemRect.top);
		pDC->LineTo(itemRect.right, itemRect.top);

		pDC->SelectObject(pen3DLight);
		pDC->MoveTo(itemRect.left+1, itemRect.bottom-1);
		pDC->LineTo(itemRect.left+1, itemRect.top+1);
		pDC->LineTo(itemRect.right, itemRect.top+1);

		pDC->SelectObject(pen3DKShadow);
		pDC->MoveTo(itemRect.left, itemRect.bottom-1);
		pDC->LineTo(itemRect.right-1, itemRect.bottom-1);
		pDC->LineTo(itemRect.right-1, itemRect.top-1);

		pDC->SelectObject(penBtnShadow);
		pDC->MoveTo(itemRect.left+1, itemRect.bottom-2);
		pDC->LineTo(itemRect.right-2, itemRect.bottom-2);
		pDC->LineTo(itemRect.right-2, itemRect.top);
#endif
	}

#ifdef XS_FLAT_BUTTON
	if (IsFocused)
	{
		if (m_MouseOnButton)	//	Add by Rigel
		{
		CRect focusRect = itemRect;
		focusRect.DeflateRect(3, 3);
		pDC->DrawFocusRect(&focusRect);
		}
	}
#endif

	CString title;
	GetWindowText(title);

	if (m_hIcon != NULL)
	{
		CRect iconRect = lpDrawItemStruct->rcItem;
		if (title.IsEmpty())
			iconRect.left += ((iconRect.Width() - m_cxIcon) / 2);
		else
			iconRect.left += 6;
		iconRect.top += ((iconRect.Height() - m_cyIcon) / 2);
		if (IsPressed) iconRect.OffsetRect(1, 1);
		pDC->DrawIcon(iconRect.TopLeft(), m_hIcon);
	}

	CRect captionRect = lpDrawItemStruct->rcItem;
	if (title.IsEmpty() == false)
	{
		pDC->SetBkMode(TRANSPARENT);
		captionRect.OffsetRect(0, -1);
		if (m_hIcon != NULL)	//	Add By Rigel
			captionRect.left += m_cxIcon;
		if (IsPressed)
			captionRect.OffsetRect(1, 1);

		if (IsDisabled)
		{
			captionRect.OffsetRect(1, 1);
			pDC->SetTextColor(RGB(255, 255, 255));
			pDC->DrawText(title, -1, captionRect, DT_SINGLELINE | DT_CENTER | DT_VCENTER);
			captionRect.OffsetRect(-1, -1);
			pDC->SetTextColor(GetSysColor(COLOR_GRAYTEXT));
			pDC->DrawText(title, -1, captionRect, DT_SINGLELINE | DT_CENTER | DT_VCENTER);
		}
		else
			pDC->DrawText(title, -1, captionRect, DT_SINGLELINE | DT_CENTER | DT_VCENTER);
	}
}

#ifdef XS_FLAT_BUTTON
void CCoolButton::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	CWnd* pWnd;
	CWnd* pParent;

	CButton::OnMouseMove(nFlags, point);

	pWnd = GetActiveWindow();
	pParent = GetOwner();

	if ((m_MouseOnButton == FALSE) && (GetCapture() != this) && 
		((pWnd != NULL) && (pWnd->m_hWnd == pParent->m_hWnd)))
	{
		SetCapture();
		SetFocus();
		m_MouseOnButton = TRUE;
		Invalidate();
		UpdateWindow();
	}
	else
	{
		CRect rc;
		GetClientRect(&rc);
		if (!rc.PtInRect(point))
		{
			m_MouseOnButton = FALSE;
			Invalidate();
			UpdateWindow();
			ReleaseCapture();
		}
		else	// Add By Rigel
			if (!m_MouseOnButton) SetCapture();
	}
}
#endif

#ifdef XS_FLAT_BUTTON

void CCoolButton::OnKillFocus(CWnd* pNewWnd) 
{
	CButton::OnKillFocus(pNewWnd);
	
	// TODO: Add your message handler code here
	if (m_MouseOnButton == TRUE)
	{
		m_MouseOnButton = FALSE;
		Invalidate();
		UpdateWindow();
	}
}
#endif

void CCoolButton::SetIcon(HICON hIcon, BYTE cx, BYTE cy, BOOL bOwnerDraw)
{
	m_hIcon = hIcon;
	m_cxIcon = cx;
	m_cyIcon = cy;

	//	Add by Rigel for set Button OwerDraw
	if (bOwnerDraw)
	{
		LONG bs = ::GetWindowLong(m_hWnd, GWL_STYLE);
		bs |= BS_OWNERDRAW;
		::SetWindowLong(m_hWnd, GWL_STYLE, bs);
	}
}

BOOL CCoolButton::SubclassDlgItem(UINT nID, CWnd *pParent)
{
	BOOL retValue = CButton::SubclassDlgItem(nID, pParent);

	//	Not Run this code,  Rigel
	LONG bs = ::GetWindowLong(m_hWnd, GWL_STYLE);
	bs |= BS_OWNERDRAW;
	::SetWindowLong(m_hWnd, GWL_STYLE, bs);

	return retValue;
}
