// DlgOption.cpp : implementation file
//

#include "stdafx.h"
#include "Tetris.h"
#include "DlgOption.h"
#include "PropSheetOption.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgOption dialog


CDlgOption::CDlgOption(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgOption::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgOption)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_pView = (CChildView*)pParent;
	m_pPropSheetOption = NULL;
}


void CDlgOption::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgOption)
	DDX_Control(pDX, IDC_CTRLHOLD, m_ctrlHold);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgOption, CDialog)
	//{{AFX_MSG_MAP(CDlgOption)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_OPTION_SAVE, OnOptionSave)
	ON_BN_CLICKED(IDC_OPTION_RESET, OnOptionReset)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgOption message handlers

void CDlgOption::OnProperties()
{
	// TODO: The property sheet attached to your project
	// via this function is not hooked up to any message
	// handler.  In order to actually use the property sheet,
	// you will need to associate this function with a control
	// in your project such as a menu item or tool bar button.

	CPropSheetOption propSheet;

	propSheet.DoModal();

	// This is where you would retrieve information from the property
	// sheet if propSheet.DoModal() returned IDOK.  We aren't doing
	// anything for simplicity.
}

void CDlgOption::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	delete m_pPropSheetOption;
}

BOOL CDlgOption::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	SetWindowText(GetLangueString("Option"));
	SetDlgItemText(IDOK, GetLangueString("OK"));
	SetDlgItemText(IDCANCEL, GetLangueString("Cancel"));
	SetDlgItemText(IDC_OPTION_SAVE, GetLangueString("Save"));
	SetDlgItemText(IDC_OPTION_RESET, GetLangueString("Reset"));

	CRect rect;
	m_ctrlHold.GetWindowRect(rect);
	ScreenToClient(&rect);

	m_pPropSheetOption = new CPropSheetOption(this);

	if (!m_pPropSheetOption->Create(this,WS_CHILD | WS_VISIBLE, 0))
	{
		delete m_pPropSheetOption;
		m_pPropSheetOption = NULL;
		return FALSE;
	}
	m_pPropSheetOption->ModifyStyleEx (0, WS_EX_CONTROLPARENT);
	m_pPropSheetOption->ModifyStyle( 0, WS_TABSTOP);
	m_pPropSheetOption->MoveWindow(&rect);

	m_pPropSheetOption->SetActivePage(3);
	m_pPropSheetOption->SetActivePage(2);
	m_pPropSheetOption->SetActivePage(1);
	m_pPropSheetOption->SetActivePage(0);

	m_pPropSheetOption->m_Page1.SetWindowText(GetLangueString("Difficute"));
	m_pPropSheetOption->m_Page2.SetWindowText(GetLangueString("Display"));
	m_pPropSheetOption->m_Page3.SetWindowText(GetLangueString("Computer Attrib"));
	m_pPropSheetOption->m_Page4.SetWindowText(GetLangueString("Operate"));

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgOption::OnSave() 
{
	m_pPropSheetOption->m_Page1.OnSave();
	m_pPropSheetOption->m_Page2.OnSave();
	m_pPropSheetOption->m_Page3.OnSave();
	m_pPropSheetOption->m_Page4.OnSave();
}

void CDlgOption::OnOK() 
{
	// TODO: Add extra validation here
	OnSave();
	CDialog::OnOK();
}

void CDlgOption::OnOptionSave() 
{
	// TODO: Add your control notification handler code here
	OnSave();
	CTetrisApp *pApp = (CTetrisApp*)AfxGetApp();
	m_pView->SaveProfileValue(pApp);
}

void CDlgOption::OnOptionReset() 
{
	// TODO: Add your control notification handler code here
	CTetrisApp *pApp = (CTetrisApp*)AfxGetApp();
	m_pView->SetDefaultValue(pApp, TRUE);

	m_pPropSheetOption->m_Page1.SetInitValue();
	m_pPropSheetOption->m_Page2.SetInitValue();
	m_pPropSheetOption->m_Page3.SetInitValue();
	m_pPropSheetOption->m_Page4.SetInitValue();
}
