// Game.h: interface for the CGame class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_GAME_H__9CAB1AD2_F75F_11D4_910A_5254ABDD22CE__INCLUDED_)
#define AFX_GAME_H__9CAB1AD2_F75F_11D4_910A_5254ABDD22CE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Block.h"
#include "Body.h"
#include "Teris.h"
#include "ChildView.h"

class CChildView;

class CGame : public CObject  
{
public:
	enum	{ STATUS_WAIT=0, STATUS_RUN=1, STATUS_PAUSE=2, STATUS_OVER=3	};
	enum	{ TETRIS_BASE=7, TETRIS_EXTEND=18, TETRIS_EASY=22	};
	enum	{ COLOR_OWNE=0, COLOR_SAME=1, COLOR_RAND=2	};
	enum	{ TYPE_SINGLE=0, TYPE_DOUBLE=1, TYPE_SITZKRIEG=2, TYPE_NET=3, TYPE_COMPUTER=4, TYPE_TEACH=5	};

public:
	CGame();
	virtual ~CGame();
	CGame(CGame &g);

	void Draw(CDC &dc);
	void DrawTop(CDC &dc);
	void DrawGameOver(CDC &dc);
	void DrawGameWait(CDC &dc);

	void SetView(CChildView* p)	{	m_pView = p;	}
	void SetCtrlKey(UINT Left=VK_LEFT, UINT Right=VK_RIGHT, UINT Up=VK_UP, UINT Down=VK_DOWN)
	{
		m_CtrlKeys[0] = Left;	m_CtrlKeys[1] = Right;
		m_CtrlKeys[2] = Up	;	m_CtrlKeys[3] = Down;
	}
	CSize MatchKey(UINT nChar);

	CSize GetSize(void);
	CSize GetTopSize(void);
	CSize GetBodySize(void);

	void StartGame(int nSpeed, int nLines, int nTetrisType,	UINT nCtrlKeys[MAX_CTRL_KEYS], int nColorType);

	void EndGame(BOOL bReDraw = TRUE);
	void SetWin(void)	{	m_bWin = true;	}

	void SetPoint(CPoint pt)	{	m_ptStart = pt;	}
	void NewTetris(void);
	void NextTetris(void);

	void SetGameTimer(void);
	UINT SpeedToTime(int nSpeed);
	int LinesToScore(int nLines);

	void SetComputerCtrl(void);
	void ComputerCtrlTetris(void);

	void TetrisMove(const CSize &sz);
	void TetrisDown(CDC& dc);
	void AddLines(int nLines);

	void SetStatus(int s)	{	m_nStatus = s;	}
	int GetStatus(void)	{	return m_nStatus;	}

	BOOL IsComputer(void)	{	return m_bComputer;	}
	void SetComputer(BOOL c)	{	m_bComputer = c;	}
	bool HasComputerCtrl(void)	{	return !(m_nCtrlRoate==0 && m_nCtrlMove==0);	}

	BOOL IsActive(void)		{	return m_bActive;	}
	void SetActive(BOOL b)	{	m_bActive = b;		}

	int GetIndex(void)		{	return m_nIndex;	}
	void SetIndex(int i)	{	m_nIndex = i;		}

	static void SetTetrisColor(int i)	{	m_nTetrisColor = i;	}
	static void SetComputerIntelligence(int i)	{	m_nComputerIntelligence = i;	}
	static void SetType(int t)	{	m_nGameType = t;	}
	static int GetType(void)	{	return m_nGameType;	}

	static void SetComputerCanFallDown(BOOL b)	{	m_bComputerCanFallDown = b;	}
	static BOOL IsComputerCanFallDown(void )	{	return m_bComputerCanFallDown;	}
protected:
	CChildView*	m_pView;
	CBody	m_Body;
	CTetris m_Tetris;
	CPoint	m_ptStart;

	int		m_nStatus;		//	Ϸ״̬
	UINT	m_CtrlKeys[MAX_CTRL_KEYS];	//	Ƽ

	BOOL	m_bWin;			//	սǷʤ
	BOOL	m_bComputer;	//	ǷΪ
	int		m_nCtrlRoate;	//	Կת
	int		m_nCtrlMove;	//	Կƶ

	int		m_nScore;
	int		m_nLines;
	int		m_nSpeed;

	int		m_nTetrisType;

	BOOL	m_bActive;
	int		m_nIndex;

	static int m_nTetrisColor;
	static int m_nGameType;
	static BOOL m_bComputerCanFallDown;		//	Ƿ԰¡
	static int m_nComputerIntelligence;		//	̶ܳ
public:
	void operator = (const CGame &g)
	{
		m_Body = g.m_Body;
		m_Tetris = g.m_Tetris;
		m_ptStart = g.m_ptStart;
		m_nStatus = g.m_nStatus;
		m_nScore = g.m_nScore;
		m_nLines = g.m_nLines;
		m_nSpeed = g.m_nSpeed;
		m_pView = g.m_pView;
		m_bWin = g.m_bWin;
		m_bComputer = g.m_bComputer;
		m_nTetrisType = g.m_nTetrisType;
		m_bActive = g.m_bActive;
		m_nIndex = g.m_nIndex;
		for (int i=0; i<4; i++)
			m_CtrlKeys[i] = g.m_CtrlKeys[i];
	}
};

#endif // !defined(AFX_GAME_H__9CAB1AD2_F75F_11D4_910A_5254ABDD22CE__INCLUDED_)
