// PropPage.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "PropPage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(CPropPageDifficute, CPropertyPage)
IMPLEMENT_DYNCREATE(CPropPageDisplay, CPropertyPage)
IMPLEMENT_DYNCREATE(CPropPageComputer, CPropertyPage)
IMPLEMENT_DYNCREATE(CPropPageOperate, CPropertyPage)


/////////////////////////////////////////////////////////////////////////////
// CPropPageDifficute property page

CPropPageDifficute::CPropPageDifficute() : CPropertyPage(CPropPageDifficute::IDD, CTetrisApp::m_nLangue == CTetrisApp::CHINESE ? IDS_DIFFICUTE_C : IDS_DIFFICUTE_E)
{
	//{{AFX_DATA_INIT(CPropPageDifficute)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CPropPageDifficute::~CPropPageDifficute()
{
}

void CPropPageDifficute::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropPageDifficute)
	DDX_Control(pDX, IDC_GROUP_TYPE, m_gpType);
	DDX_Control(pDX, IDC_COMBO_SPEED2, m_coboSpeed2);
	DDX_Control(pDX, IDC_COMBO_SPEED1, m_coboSpeed1);
	DDX_Control(pDX, IDC_COMBO_LINES2, m_coboLines2);
	DDX_Control(pDX, IDC_COMBO_LINES1, m_coboLines1);
	DDX_Control(pDX, IDC_CHECK_TYPE_EXT2, m_chkExt2);
	DDX_Control(pDX, IDC_CHECK_TYPE_EXT1, m_chkExt1);
	DDX_Control(pDX, IDC_CHECK_TYPE_EAS2, m_chkEas2);
	DDX_Control(pDX, IDC_CHECK_TYPE_EAS1, m_chkEas1);
	DDX_Control(pDX, IDC_CHECK_TYPE_BASE2, m_chkBase2);
	DDX_Control(pDX, IDC_CHECK_TYPE_BASE1, m_chkBase1);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPropPageDifficute, CPropertyPage)
	//{{AFX_MSG_MAP(CPropPageDifficute)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPropPageDisplay property page

CPropPageDisplay::CPropPageDisplay() : CPropertyPage(CPropPageDisplay::IDD, CTetrisApp::m_nLangue == CTetrisApp::CHINESE ? IDS_DISPLAY_C : IDS_DISPLAY_E)
{
	//{{AFX_DATA_INIT(CPropPageDisplay)
	//}}AFX_DATA_INIT
}

CPropPageDisplay::~CPropPageDisplay()
{
}

void CPropPageDisplay::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropPageDisplay)
	DDX_Control(pDX, IDC_FRAME_BIG_TETRIS, m_frmBigTetris);
	DDX_Control(pDX, IDC_COMBO_COLOR, m_coboColorType);
	DDX_Control(pDX, IDC_FRAME_TETRIS, m_frmTetris);
	DDX_Control(pDX, IDC_DISP_CHOOSE, m_btnChoose);
	DDX_Control(pDX, IDC_DISP_SETCOLOR, m_btnSetColor);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPropPageDisplay, CPropertyPage)
	//{{AFX_MSG_MAP(CPropPageDisplay)
	ON_BN_CLICKED(IDC_DISP_CHOOSE, OnDispChoose)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_FRAME_TETRIS, OnFrameTetris)
	ON_WM_LBUTTONDOWN()
	ON_BN_CLICKED(IDC_DISP_SETCOLOR, OnDispSetcolor)
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPropPageComputer property page

CPropPageComputer::CPropPageComputer() : CPropertyPage(CPropPageComputer::IDD, CTetrisApp::m_nLangue == CTetrisApp::CHINESE ? IDS_COMPUTER_C : IDS_COMPUTER_E)
{
	//{{AFX_DATA_INIT(CPropPageComputer)
	//}}AFX_DATA_INIT
}

CPropPageComputer::~CPropPageComputer()
{
}

void CPropPageComputer::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropPageComputer)
	DDX_Control(pDX, IDC_COMBO_FALL, m_coboFall);
	DDX_Control(pDX, IDC_COMBO_INTELIGENCE, m_coboInteligence);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPropPageComputer, CPropertyPage)
	//{{AFX_MSG_MAP(CPropPageComputer)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPropPageOperate property page

CPropPageOperate::CPropPageOperate() : CPropertyPage(CPropPageOperate::IDD, CTetrisApp::m_nLangue == CTetrisApp::CHINESE ? IDS_OPERATE_C : IDS_OPERATE_E)
{
	//{{AFX_DATA_INIT(CPropPageOperate)
	//}}AFX_DATA_INIT
}

CPropPageOperate::~CPropPageOperate()
{
}

void CPropPageOperate::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropPageOperate)
	DDX_Control(pDX, IDC_TEXT_ROATE2, m_btnRoate2);
	DDX_Control(pDX, IDC_TEXT_ROATE1, m_btnRoate1);
	DDX_Control(pDX, IDC_TEXT_RIGHT2, m_btnRight2);
	DDX_Control(pDX, IDC_TEXT_RIGHT1, m_btnRight1);
	DDX_Control(pDX, IDC_TEXT_LEFT2, m_btnLeft2);
	DDX_Control(pDX, IDC_TEXT_LEFT1, m_btnLeft1);
	DDX_Control(pDX, IDC_TEXT_DOWN2, m_btnDown2);
	DDX_Control(pDX, IDC_TEXT_DOWN1, m_btnDown1);
	DDX_Control(pDX, IDC_COMBO_GAMETYPE, m_coboGameType);
	DDX_Control(pDX, IDC_CHECK_SAVEPOS, m_chkSavePos);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPropPageOperate, CPropertyPage)
	//{{AFX_MSG_MAP(CPropPageOperate)
	ON_BN_CLICKED(IDC_TEXT_ROATE1, OnTextRoate1)
	ON_BN_CLICKED(IDC_TEXT_ROATE2, OnTextRoate2)
	ON_BN_CLICKED(IDC_TEXT_DOWN1, OnTextDown1)
	ON_BN_CLICKED(IDC_TEXT_DOWN2, OnTextDown2)
	ON_BN_CLICKED(IDC_TEXT_LEFT1, OnTextLeft1)
	ON_BN_CLICKED(IDC_TEXT_LEFT2, OnTextLeft2)
	ON_BN_CLICKED(IDC_TEXT_RIGHT1, OnTextRight1)
	ON_BN_CLICKED(IDC_TEXT_RIGHT2, OnTextRight2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CPropPageDisplay::OnDispChoose() 
{
	// TODO: Add your control notification handler code here
	m_bChooseColor = !m_bChooseColor;
	m_btnChoose.SetWindowText(GetLangueString("Set Tetris Color") + CString(m_bChooseColor?"<<":">>"));
	m_btnSetColor.ShowWindow(m_bChooseColor);
	m_frmTetris.ShowWindow(m_bChooseColor);
	m_frmBigTetris.ShowWindow(m_bChooseColor);
}

void CPropPageDisplay::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	CDC* pDC = m_frmTetris.GetWindowDC();
	CRect rc;
	m_frmTetris.GetWindowRect(rc);

	pDC->Rectangle(0, 0, rc.Width(), rc.Height());
	
	for (int i=0; i<MAX_TETRIS_TYPE; i++)
	{
		CPoint pt = CPoint(i%5*m_nSize*4, i/5*m_nSize*4);
		pDC->Rectangle(CRect(pt, CSize(m_nSize*4, m_nSize*4)));
		m_Tetris[i].Draw(pt, *pDC, FALSE, m_nSize, TRUE);
	}
	DrawBigTetris();
	// Do not call CPropertyPage::OnPaint() for painting messages
}

void CPropPageDifficute::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	CDC* pDC = m_gpType.GetWindowDC();
	int nSize = 10;
	for (int i=0; i<6; i++)
	{
		CPoint pt = CPoint(10+i%2*50, 20+i/2*45);
		m_Tetris[i].Draw(pt, *pDC, FALSE, nSize);
	}
	// Do not call CPropertyPage::OnPaint() for painting messages
}

BOOL CPropPageDisplay::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	SetDlgItemText(IDC_TXT_TETRIS_COLOR, GetLangueString("Tetris Color"));
	SetDlgItemText(IDC_DISP_SETCOLOR, GetLangueString("Set Color"));

	m_coboColorType.Clear();
	m_coboColorType.AddString(GetLangueString("Own"));
	m_coboColorType.AddString(GetLangueString("Same"));
	m_coboColorType.AddString(GetLangueString("Random"));

	SetInitValue();

	m_nSize = 10;
	m_nTetrisIndex = 0;

	m_bChooseColor = TRUE;
	OnDispChoose();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPropPageComputer::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();

	SetWindowText(GetLangueString("Computer Attrib"));
	SetDlgItemText(IDC_TXT_INTELIGENCE, GetLangueString("Inteligence"));
	SetDlgItemText(IDC_TXT_FALLDOWN, GetLangueString("FallDown"));

	m_coboInteligence.Clear();
	m_coboInteligence.AddString(GetLangueString("Normal"));
	m_coboInteligence.AddString(GetLangueString("Good"));
	m_coboInteligence.AddString(GetLangueString("Very Good"));
	m_coboFall.Clear();
	m_coboFall.AddString(GetLangueString("NO"));
	m_coboFall.AddString(GetLangueString("YES"));

	SetInitValue();
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPropPageDifficute::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();

	SetWindowText(GetLangueString("Difficute"));
	SetDlgItemText(IDC_TXT_SPEED, GetLangueString("Speed"));
	SetDlgItemText(IDC_TXT_LINES, GetLangueString("Lines"));
	SetDlgItemText(IDC_GROUP_TYPE, GetLangueString("Tetris Type"));
	SetDlgItemText(IDC_CHECK_TYPE_BASE1, GetLangueString("Base Type"));
	SetDlgItemText(IDC_CHECK_TYPE_BASE2, GetLangueString("Base Type"));
	SetDlgItemText(IDC_CHECK_TYPE_EXT1, GetLangueString("Extend Type"));
	SetDlgItemText(IDC_CHECK_TYPE_EXT2, GetLangueString("Extend Type"));
	SetDlgItemText(IDC_CHECK_TYPE_EAS1, GetLangueString("Easy Type"));
	SetDlgItemText(IDC_CHECK_TYPE_EAS2, GetLangueString("Easy Type"));
	SetDlgItemText(IDC_TXT_PLAYER1, GetLangueString("Player1"));
	SetDlgItemText(IDC_TXT_PLAYER2, GetLangueString("Player2"));

	SetInitValue();
	// TODO: Add extra initialization here
	m_Tetris[0] = CTetris(1, m_pView->m_nColorRef[1], TRUE);
	m_Tetris[1] = CTetris(4, m_pView->m_nColorRef[4], TRUE);
	m_Tetris[2] = CTetris(7, m_pView->m_nColorRef[7], TRUE);
	m_Tetris[3] = CTetris(8, m_pView->m_nColorRef[8], TRUE);
	m_Tetris[4] = CTetris(19, m_pView->m_nColorRef[19], TRUE);
	m_Tetris[5] = CTetris(20, m_pView->m_nColorRef[20], TRUE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPropPageOperate::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();

	SetDlgItemText(IDC_TXT_ROATE, GetLangueString("Roate"));
	SetDlgItemText(IDC_TXT_FALL_DOWN, GetLangueString("Fall Down"));
	SetDlgItemText(IDC_TXT_MOVE_LEFT, GetLangueString("Move Left"));
	SetDlgItemText(IDC_TXT_MOVE_RIGHT, GetLangueString("Move Right"));
	SetDlgItemText(IDC_TXT_DEFAULT_GAME_TYPE, GetLangueString("Default Game Type"));
	SetDlgItemText(IDC_CHECK_SAVEPOS, GetLangueString("Save Window Position"));

	SetDlgItemText(IDC_TXT_PLAYER1, GetLangueString("Player1"));
	SetDlgItemText(IDC_TXT_PLAYER2, GetLangueString("Player2"));
	
	m_coboGameType.Clear();
	m_coboGameType.AddString(GetLangueString("_Single"));
	m_coboGameType.AddString(GetLangueString("_Double"));
	m_coboGameType.AddString(GetLangueString("_Sitzkrieg"));
	m_coboGameType.AddString(GetLangueString("_Net"));
	m_coboGameType.AddString(GetLangueString("_Computer"));

	m_btnDown1.SetIcon();
	m_btnDown2.SetIcon();
	m_btnRoate1.SetIcon();
	m_btnRoate2.SetIcon();
	m_btnLeft1.SetIcon();
	m_btnLeft2.SetIcon();
	m_btnRight1.SetIcon();
	m_btnRight2.SetIcon();

	// TODO: Add extra initialization here
	SetInitValue();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPropPageComputer::OnSave()
{
	m_pView->m_nComputerIntelligence = m_coboInteligence.GetCurSel();
	m_pView->m_bComputerFallDown = m_coboFall.GetCurSel();
}

void CPropPageDifficute::OnSave()
{
	m_pView->m_nStartSpeed[0] = m_coboSpeed1.GetCurSel();
	m_pView->m_nStartSpeed[1] = m_coboSpeed2.GetCurSel();
	m_pView->m_nStartLines[0] = m_coboLines1.GetCurSel()*3;
	m_pView->m_nStartLines[1] = m_coboLines2.GetCurSel()*3;
	m_pView->m_nTetrisType[0] = CGame::TETRIS_BASE;
	m_pView->m_nTetrisType[1] = CGame::TETRIS_BASE;
	if (m_chkExt1.GetCheck())
		m_pView->m_nTetrisType[0] = CGame::TETRIS_EXTEND;
	if (m_chkExt2.GetCheck())
		m_pView->m_nTetrisType[1] = CGame::TETRIS_EXTEND;
	if (m_chkEas1.GetCheck())
		m_pView->m_nTetrisType[0] = CGame::TETRIS_EASY;
	if (m_chkEas2.GetCheck())
		m_pView->m_nTetrisType[1] = CGame::TETRIS_EASY;
}

void CPropPageDisplay::OnSave()
{
	m_pView->m_nColorType = m_coboColorType.GetCurSel();
	for (int i=0; i<MAX_COLORS; i++)
	{
		m_pView->m_nColorRef[i] = m_nColorRef[i];
	}
}

void CPropPageOperate::OnSave()
{
	for (int i=0; i<MAX_GAMES; i++)
		for (int j=0; j<MAX_CTRL_KEYS; j++)
			m_pView->m_nCtrlKeys[i][j] = m_nKeys[i][j];

	CWinApp* pApp = AfxGetApp();
	pApp->WriteProfileInt("Operate", "SavePos", m_chkSavePos.GetCheck());
	m_pView->m_nDefaultGameType = m_coboGameType.GetCurSel();
}

void CPropPageComputer::SetInitValue()
{
	m_coboInteligence.SetCurSel(m_pView->m_nComputerIntelligence);
	m_coboFall.SetCurSel(m_pView->m_bComputerFallDown);
}

void CPropPageDifficute::SetInitValue()
{
	m_coboSpeed1.SetCurSel(m_pView->m_nStartSpeed[0]);
	m_coboSpeed2.SetCurSel(m_pView->m_nStartSpeed[1]);
	m_coboLines1.SetCurSel(m_pView->m_nStartLines[0]/3);
	m_coboLines2.SetCurSel(m_pView->m_nStartLines[1]/3);
	m_chkBase1.SetCheck(m_pView->m_nTetrisType[0]>=CGame::TETRIS_BASE);
	m_chkBase2.SetCheck(m_pView->m_nTetrisType[1]>=CGame::TETRIS_BASE);
	m_chkExt1.SetCheck(m_pView->m_nTetrisType[0]>=CGame::TETRIS_EXTEND);
	m_chkExt2.SetCheck(m_pView->m_nTetrisType[1]>=CGame::TETRIS_EXTEND);
	m_chkEas1.SetCheck(m_pView->m_nTetrisType[0]>=CGame::TETRIS_EASY);
	m_chkEas2.SetCheck(m_pView->m_nTetrisType[1]>=CGame::TETRIS_EASY);
}

void CPropPageDisplay::SetInitValue()
{
	m_coboColorType.SetCurSel(m_pView->m_nColorType);

	for (int i=0; i<MAX_COLORS; i++)
	{
		m_nColorRef[i] = m_pView->m_nColorRef[i];
	}
	for (i=0; i<MAX_TETRIS_TYPE; i++)
	{
		m_Tetris[i] = CTetris(i, m_nColorRef[i], TRUE);
	}

	Invalidate();
}

void CPropPageOperate::SetInitValue()
{
	for (int i=0; i<MAX_GAMES; i++)
	{
		for (int j=0; j<MAX_CTRL_KEYS; j++)
		{
			m_nKeys[i][j] = m_pView->m_nCtrlKeys[i][j];
			SetKeyToTitle(i, j);
		}
	}


	CWinApp* pApp = AfxGetApp();
	m_chkSavePos.SetCheck(pApp->GetProfileInt("Operate", "SavePos", 1));
	m_coboGameType.SetCurSel(m_pView->m_nDefaultGameType);
}

void CPropPageDisplay::OnFrameTetris() 
{
	// TODO: Add your control notification handler code here
	
}

void CPropPageDisplay::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	if (!m_bChooseColor)
	{
		CPropertyPage::OnLButtonDown(nFlags, point);
		return;
	}
	CDC* pDC = m_frmTetris.GetWindowDC();
	CRect rcFrm;
	CRect rcDlg;
	GetWindowRect(rcDlg);
	m_frmTetris.GetWindowRect(rcFrm);
	CRect rc = CRect(CPoint(rcFrm.left-rcDlg.left, rcFrm.top-rcDlg.top), CSize(rcFrm.Width(), rcFrm.Height()));
	if (rc.PtInRect(point))
	{
		int nIndex = (point.y-rc.top)/(m_nSize*4) * 5 + (point.x-rc.left)/(m_nSize*4);
		if (nIndex >= 0 && nIndex < MAX_TETRIS_TYPE && nIndex != m_nTetrisIndex)
		{
			m_nTetrisIndex = nIndex;
			DrawBigTetris();
		}
	}

	CPropertyPage::OnLButtonDown(nFlags, point);
}

void CPropPageDisplay::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	if (!m_bChooseColor)
	{
		CPropertyPage::OnLButtonDown(nFlags, point);
		return;
	}
	CDC* pDC = m_frmTetris.GetWindowDC();
	CRect rcFrm;
	CRect rcDlg;
	GetWindowRect(rcDlg);
	m_frmTetris.GetWindowRect(rcFrm);
	CRect rc = CRect(CPoint(rcFrm.left-rcDlg.left, rcFrm.top-rcDlg.top), CSize(rcFrm.Width(), rcFrm.Height()));
	if (rc.PtInRect(point))
	{
		OnDispSetcolor();
	}
	CPropertyPage::OnLButtonDblClk(nFlags, point);
}

void CPropPageDisplay::DrawBigTetris()
{
	CDC *pDC = m_frmBigTetris.GetWindowDC();
	CRect rc;
	m_frmBigTetris.GetWindowRect(rc);
	pDC->Rectangle(0, 0, rc.Width(), rc.Height());
	CPoint pt = CPoint(8, 10);
	m_Tetris[m_nTetrisIndex].Draw(pt, *pDC, FALSE, CBlock::GetCell(), TRUE);
}

void CPropPageDisplay::OnDispSetcolor() 
{
	// TODO: Add your control notification handler code here
	CColorDialog dlg;
	if (dlg.DoModal() == IDOK)
	{
		m_nColorRef[m_nTetrisIndex] = dlg.GetColor();
		m_Tetris[m_nTetrisIndex].SetColor(m_nColorRef[m_nTetrisIndex]);
	}
	Invalidate();
}


void CPropPageOperate::OnTextRoate1() 
{
	// TODO: Add your control notification handler code here
	ShowSetKeyDlg(0, 2);
}

void CPropPageOperate::OnTextRoate2() 
{
	// TODO: Add your control notification handler code here
	ShowSetKeyDlg(1, 2);	
}

void CPropPageOperate::OnTextDown1() 
{
	// TODO: Add your control notification handler code here
	ShowSetKeyDlg(0, 3);	
}

void CPropPageOperate::OnTextDown2() 
{
	// TODO: Add your control notification handler code here
	ShowSetKeyDlg(1, 3);	
}

void CPropPageOperate::OnTextLeft1() 
{
	// TODO: Add your control notification handler code here
	ShowSetKeyDlg(0, 0);	
}

void CPropPageOperate::OnTextLeft2() 
{
	// TODO: Add your control notification handler code here
	ShowSetKeyDlg(1, 0);	
}

void CPropPageOperate::OnTextRight1() 
{
	// TODO: Add your control notification handler code here
	ShowSetKeyDlg(0, 1);	
}

void CPropPageOperate::OnTextRight2() 
{
	// TODO: Add your control notification handler code here
	ShowSetKeyDlg(1, 1);	
}

void CPropPageOperate::ShowSetKeyDlg(int nPlayer, int nKeyIndex)
{
	CSetKeyDlg m_dlgSetKey(this);
	
	m_dlgSetKey.m_sTitle = GetLangueString("Set Key") + " - ";
	m_dlgSetKey.m_sTitle += (nPlayer ? GetLangueString("Player2") : GetLangueString("Player1")) + " - ";
	switch (nKeyIndex)
	{
	case 0:
		m_dlgSetKey.m_sTitle += GetLangueString("Move Left");
		break;
	case 1:
		m_dlgSetKey.m_sTitle += GetLangueString("Move Right");
		break;
	case 2:
		m_dlgSetKey.m_sTitle += GetLangueString("Roate");
		break;
	case 3:
		m_dlgSetKey.m_sTitle += GetLangueString("Fall Down");
		break;
	}

	m_dlgSetKey.m_nKeyValue = m_nKeys[nPlayer][nKeyIndex];	
	if (m_dlgSetKey.DoModal() == IDOK)
	{
		m_nKeys[nPlayer][nKeyIndex] = m_dlgSetKey.m_nKeyValue;	
		SetKeyToTitle(nPlayer, nKeyIndex);
	}
}

void CPropPageOperate::SetKeyToTitle(int nPlayer, int nKeyIndex)
{
	switch (nPlayer)
	{
	case 0:
		{
			switch (nKeyIndex)
			{
			case 0:
				SetDlgItemText(IDC_TEXT_LEFT1, UintToString(m_nKeys[nPlayer][nKeyIndex]));
				break;
			case 1:
				SetDlgItemText(IDC_TEXT_RIGHT1, UintToString(m_nKeys[nPlayer][nKeyIndex]));
				break;
			case 2:
				SetDlgItemText(IDC_TEXT_ROATE1, UintToString(m_nKeys[nPlayer][nKeyIndex]));
				break;
			case 3:
				SetDlgItemText(IDC_TEXT_DOWN1, UintToString(m_nKeys[nPlayer][nKeyIndex]));
				break;
			}
		}
		break;
	case 1:
		{
			switch (nKeyIndex)
			{
			case 0:
				SetDlgItemText(IDC_TEXT_LEFT2, UintToString(m_nKeys[nPlayer][nKeyIndex]));
				break;
			case 1:
				SetDlgItemText(IDC_TEXT_RIGHT2, UintToString(m_nKeys[nPlayer][nKeyIndex]));
				break;
			case 2:
				SetDlgItemText(IDC_TEXT_ROATE2, UintToString(m_nKeys[nPlayer][nKeyIndex]));
				break;
			case 3:
				SetDlgItemText(IDC_TEXT_DOWN2, UintToString(m_nKeys[nPlayer][nKeyIndex]));
				break;
			}
		}
		break;
	}
}
