// PropPage.h : header file
//

#ifndef __PROPPAGE_H__
#define __PROPPAGE_H__

#include "Tetris.h"
#include "Teris.h"
#include "ChildView.h"
#include "CoolButton.h"
#include "SetKeyDlg.h"

class CTetris;
/////////////////////////////////////////////////////////////////////////////
// CPropPageDifficute dialog

class CPropPageDifficute : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropPageDifficute)

// Construction
public:
	CPropPageDifficute();
	~CPropPageDifficute();

	CChildView* m_pView;
	void SetView(CChildView* pView)	{	m_pView = pView;	}
	void SetInitValue(void);
	void OnSave(void);

	CTetris m_Tetris[6];

// Dialog Data
	//{{AFX_DATA(CPropPageDifficute)
	enum { IDD = IDD_PROPPAGE_DIFFICUTE };
	CButton	m_gpType;
	CComboBox	m_coboSpeed2;
	CComboBox	m_coboSpeed1;
	CComboBox	m_coboLines2;
	CComboBox	m_coboLines1;
	CButton	m_chkExt2;
	CButton	m_chkExt1;
	CButton	m_chkEas2;
	CButton	m_chkEas1;
	CButton	m_chkBase2;
	CButton	m_chkBase1;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CPropPageDifficute)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CPropPageDifficute)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


/////////////////////////////////////////////////////////////////////////////
// CPropPageDisplay dialog

class CPropPageDisplay : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropPageDisplay)

// Construction
public:
	CPropPageDisplay();
	~CPropPageDisplay();

	CChildView* m_pView;
	void SetView(CChildView* pView)	{	m_pView = pView;	}
	void SetInitValue(void);
	void OnSave(void);
	void DrawBigTetris(void);
// Dialog Data
	//{{AFX_DATA(CPropPageDisplay)
	enum { IDD = IDD_PROPPAGE_DISPLAY };
	CStatic	m_frmBigTetris;
	CComboBox	m_coboColorType;
	CStatic	m_frmTetris;
	CButton	m_btnChoose;
	CButton	m_btnSetColor;
	//}}AFX_DATA
protected:
	BOOL m_bChooseColor;
	int m_nColorRef[MAX_COLORS];
	CTetris m_Tetris[MAX_TETRIS_TYPE];

	int m_nSize;
	int m_nTetrisIndex;
// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CPropPageDisplay)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CPropPageDisplay)
	afx_msg void OnDispChoose();
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg void OnFrameTetris();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnDispSetcolor();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


/////////////////////////////////////////////////////////////////////////////
// CPropPageComputer dialog

class CPropPageComputer : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropPageComputer)

// Construction
public:
	CPropPageComputer();
	~CPropPageComputer();

	CChildView* m_pView;
	void SetView(CChildView* pView)	{	m_pView = pView;	}
	void SetInitValue(void);
	void OnSave(void);
// Dialog Data
	//{{AFX_DATA(CPropPageComputer)
	enum { IDD = IDD_PROPPAGE_COMPUTER };
	CComboBox	m_coboFall;
	CComboBox	m_coboInteligence;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CPropPageComputer)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CPropPageComputer)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


/////////////////////////////////////////////////////////////////////////////
// CPropPageOperate dialog

class CPropPageOperate : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropPageOperate)

// Construction
public:
	CPropPageOperate();
	~CPropPageOperate();

	CChildView* m_pView;
	void SetView(CChildView* pView)	{	m_pView = pView;	}
	void SetInitValue(void);
	void OnSave(void);

	void ShowSetKeyDlg(int nPlayer, int nKeyIndex);
	void SetKeyToTitle(int nPlayer, int nKeyIndex);

	UINT m_nKeys[MAX_GAMES][MAX_CTRL_KEYS];

//	CSetKeyDlg m_dlgSetKey(this);
// Dialog Data
	//{{AFX_DATA(CPropPageOperate)
	enum { IDD = IDD_PROPPAGE_OPERATE };
	CCoolButton	m_btnRoate2;
	CCoolButton	m_btnRoate1;
	CCoolButton	m_btnRight2;
	CCoolButton	m_btnRight1;
	CCoolButton	m_btnLeft2;
	CCoolButton	m_btnLeft1;
	CCoolButton	m_btnDown2;
	CCoolButton	m_btnDown1;
	CComboBox	m_coboGameType;
	CButton	m_chkSavePos;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CPropPageOperate)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CPropPageOperate)
	virtual BOOL OnInitDialog();
	afx_msg void OnTextRoate1();
	afx_msg void OnTextRoate2();
	afx_msg void OnTextDown1();
	afx_msg void OnTextDown2();
	afx_msg void OnTextLeft1();
	afx_msg void OnTextLeft2();
	afx_msg void OnTextRight1();
	afx_msg void OnTextRight2();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};



#endif // __PROPPAGE_H__
