// SetKeyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Tetris.h"
#include "SetKeyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetKeyDlg dialog


CSetKeyDlg::CSetKeyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSetKeyDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetKeyDlg)
	//}}AFX_DATA_INIT
	m_pParent = (CPropPageOperate*)pParent;
}


void CSetKeyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetKeyDlg)
	DDX_Control(pDX, IDC_COMBO_KEY, m_coboKey);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetKeyDlg, CDialog)
	//{{AFX_MSG_MAP(CSetKeyDlg)
	ON_WM_CTLCOLOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetKeyDlg message handlers

BOOL CSetKeyDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	SetWindowText(m_sTitle);
	SetDlgItemText(IDOK, GetLangueString("OK"));
	SetDlgItemText(IDCANCEL, GetLangueString("Cancel"));
	SetDlgItemText(IDC_TXT_SELECTSKEY, GetLangueString("Select Key"));

	m_coboKey.Clear();
	for (UINT i=nAsciiStart; i<nAsciiEnd; i++)
	{
		m_coboKey.AddString(UintToString(i));
	}

	m_coboKey.SetCurSel(m_nKeyValue - nAsciiStart);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

HBRUSH CSetKeyDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	// TODO: Change any attributes of the DC here
	if (m_coboKey.m_hWnd == pWnd->m_hWnd)
	{
		LOGFONT		lf;          
		CFont		font;
		::GetObject((HFONT)GetStockObject(DEFAULT_GUI_FONT),sizeof(lf),&lf); 
		lf.lfHeight *= 2;     
		font.CreateFontIndirect(&lf); 

		pDC->SelectObject(&font);
//		pDC->SetTextColor(RGB(255, 0, 0));
	}
	// TODO: Return a different brush if the default is not desired
	return hbr;
}


void CSetKeyDlg::OnOK() 
{
	// TODO: Add extra validation here
	for (int iG=0; iG<MAX_GAMES; iG++)
	{
		for (int iK=0; iK<MAX_CTRL_KEYS; iK++)
		{
			if (m_pParent->m_nKeys[iG][iK] == (UINT)(m_coboKey.GetCurSel() + nAsciiStart))
			{
				if (m_nKeyValue != (UINT)(m_coboKey.GetCurSel() + nAsciiStart))
				{
					MessageBox(GetLangueString("Key Used"), GetLangueString("Set Key"), MB_OK | MB_ICONSTOP);
					return;
				}
			}
		}
	}
	m_nKeyValue = (UINT)(m_coboKey.GetCurSel() + nAsciiStart);
	CDialog::OnOK();
}
