// Teris.cpp: implementation of the CTetris class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Tetris.h"
#include "Teris.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

char CTetris::BLOCK_TYPE[MAX_TETRIS_TYPE][17] = 
						{" *  "				// basic block count: 7
                         " *  "
                         " *  "
                         " *  ",
                         " ** "
                         " *  "
                         " *  "
                         "    ",
                         "**  "
                         " *  "
                         " *  "
                         "    ",
                         " *  "
                         "*** "
                         "    "
                         "    ",
                         "**  "
                         " ** "
                         "    "
                         "    ",
                         " ** "
                         "**  "
                         "    "
                         "    ",
                         "**  "
                         "**  "
                         "    "
                         "    ",
                         " *  "					// extend block count: 11
                         "*** "
                         " *  "
                         "    ",
                         "* * "
                         "*** "
                         "    "
                         "    ",
                         " ** "
                         " *  "
                         "**  "
                         "    ",
                         "**  "
                         " *  "
                         " ** "
                         "    ",
                         " *  "
                         " ** "
                         "**  "
                         "    ",
                         " *  "
                         "**  "
                         " ** "
                         "    ",
                         " *  "
                         " ** "
                         " *  "
                         " *  ",
                         " *  "
                         " *  "
                         " ** "
                         " *  ",
                         " *  "
                         " *  "
                         " *  "
                         " ** ",
                         " *  "
                         " *  "
                         " *  "
                         "**  ",
                         " *  "
                         " *  "
                         "*** "
                         "    ",
                         "*   "					// easy bolck count: 4
                         "    "
                         "    "
                         "    ",
                         " *  "
                         " *  "
                         "    "
                         "    ",
						 "**  "
                         " *  "
                         "    "
                         "    ",
                         " *  "
                         " *  "
                         " *  "
                         "    "};

COLORREF CTetris::COLOR_TYPE[MAX_COLORS] = 
		{RGB(51, 204, 102),			// 	Default color, or extend block color
		 RGB(233, 121, 118),		// ש
		 RGB(200, 200, 102),		// 
		 RGB(0, 143, 224),			// 
		 RGB(153, 153, 204),		// 
		 RGB(204, 204, 204),		// 
		 RGB(232, 123,  20),		// 
		 RGB(235,  88, 235),		// 
		 RGB(220,  39,  75), 		// 	sample block color
		 RGB(51, 204, 102),			// 
		 RGB(51, 204, 102),			// 
		 RGB(51, 204, 102),			// 
		 RGB(51, 204, 102),			// 
		 RGB(51, 204, 102),			// 
		 RGB(51, 204, 102),			// 
		 RGB(51, 204, 102),			// 
		 RGB(51, 204, 102),			// 
		 RGB(51, 204, 102),			// 
		 RGB(51, 204, 102),			// 
		 RGB(51, 204, 102),			// 
		 RGB(51, 204, 102),			// 
		 RGB(51, 204, 102)};		// 
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTetris::CTetris()
{

}

CTetris::CTetris(CTetris &t)
{
	m_Blocks.RemoveAll();
	for (int i=0; i<t.m_Blocks.GetSize(); i++)
		m_Blocks.Add(t.m_Blocks.GetAt(i));
	m_nSize = t.m_nSize;
}

CTetris::CTetris(int nType, int nColor)
{
	m_Blocks.RemoveAll();
	for (int i=0; i<17; i++)
	{
		if (BLOCK_TYPE[nType][i] == '*')
		{
			CBlock *pTempBlock = new CBlock(i%4, i/4, COLOR_TYPE[nColor]);
			m_Blocks.Add(*pTempBlock);
			delete pTempBlock;
		}
	}
	CalculateSize();
}

CTetris::CTetris(int nType, COLORREF crMain, BOOL bColor)
{
	m_Blocks.RemoveAll();
	for (int i=0; i<17; i++)
	{
		if (BLOCK_TYPE[nType][i] == '*')
		{
			CBlock *pTempBlock = new CBlock(i%4, i/4, crMain);
			m_Blocks.Add(*pTempBlock);
			delete pTempBlock;
		}
	}
	CalculateSize();
}

CTetris::~CTetris()
{
	ReSetBlocks();
}

void CTetris::CalculateSize(void)
{
	int size = 0;
	for (int i=0; i<m_Blocks.GetSize(); i++)
	{
		size = size>m_Blocks[i].GetXPos() ? size : m_Blocks[i].GetXPos();
		size = size>m_Blocks[i].GetYPos() ? size : m_Blocks[i].GetYPos();
	}
	m_nSize = size;
}

void CTetris::Roate(void)
{
	if (m_nSize == 0) return;
	for (int i=0; i<m_Blocks.GetSize(); i++)
	{
		int Temp = m_Blocks[i].GetXPos();
		m_Blocks[i].SetXPos(m_nSize - m_Blocks[i].GetYPos());
		m_Blocks[i].SetYPos(Temp);
	}

}

void CTetris::Draw(CPoint pt, CDC &dc, BOOL bNull, int nSize, BOOL bCenter)
{
	CPoint ptStart = pt;
	if (bCenter)
	{
		int nMaxX = 0;
		int nMaxY = 0;
		for (int nIndex=0; nIndex<m_Blocks.GetSize(); nIndex++)
		{
			if (m_Blocks[nIndex].GetXPos()>nMaxX) nMaxX = m_Blocks[nIndex].GetXPos();
			if (m_Blocks[nIndex].GetYPos()>nMaxY) nMaxY = m_Blocks[nIndex].GetYPos();
		}
		ptStart = pt + CSize((3-nMaxX)*nSize/2, (3-nMaxY)*nSize/2);
	}
	for (int i=0; i<m_Blocks.GetSize(); i++)
	{
		m_Blocks[i].Draw(ptStart, dc, bNull, nSize);
	}
}

int CTetris::GetBlockCount(void)
{
	return m_Blocks.GetSize();
}

CBlock CTetris::GetBlock(int nIndex)
{
	return m_Blocks[nIndex];
}

CPoint CTetris::GetBlockPoint(int nIndex)
{
	return CPoint(m_Blocks[nIndex].GetXPos(), m_Blocks[nIndex].GetYPos());
}

void CTetris::SetColor(COLORREF cr)
{
	for (int i=0; i<m_Blocks.GetSize(); i++)
	{
		m_Blocks[i].SetColor(cr);
	}
}

void CTetris::CutTopLine(void)
{
	for (int i=m_Blocks.GetSize()-1; i>=0; i--)
	{
		int x = m_Blocks[i].GetXPos();
		int y = m_Blocks[i].GetYPos();
		if (y == 0)
		{
			m_Blocks.RemoveAt(i);
		}
		else
		{
			m_Blocks[i].SetXPos(x);
			m_Blocks[i].SetYPos(y-1);
		}
	}
}
