// Teris.h: interface for the CTetris class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TERIS_H__9CAB1AD4_F75F_11D4_910A_5254ABDD22CE__INCLUDED_)
#define AFX_TERIS_H__9CAB1AD4_F75F_11D4_910A_5254ABDD22CE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Block.h"

class CTetris : public CObject  
{
public:
	CTetris();
	CTetris(CTetris &t);
	CTetris(int nType, int nColor);
	CTetris(int nType, COLORREF crMain, BOOL bColor);

	virtual ~CTetris();

	void Draw(CPoint pt, CDC &dc, BOOL bNull = FALSE, int nSize = CBlock::GetCell(), BOOL bCenter = FALSE);
	void Roate(void);
	int GetBlockCount(void);
	CBlock GetBlock(int nIndex);
	CPoint GetBlockPoint(int nIndex);
	void ReSetBlocks(void)	{	m_Blocks.RemoveAll();	}

	void CutTopLine(void);
	void CalculateSize(void);
	int GetSize(void)	{	return m_nSize;	}
	void SetColor(COLORREF cr);
protected:
	CArray<CBlock, CBlock> m_Blocks;
	int		m_nSize;

public:
	static char BLOCK_TYPE[MAX_TETRIS_TYPE][17];
	static COLORREF COLOR_TYPE[MAX_COLORS];
	void operator = (const CTetris &t)
	{
		m_Blocks.RemoveAll();
		for (int i=0; i<t.m_Blocks.GetSize(); i++)
			m_Blocks.Add(t.m_Blocks.GetAt(i));
		m_nSize = t.m_nSize;
	}
};

#endif // !defined(AFX_TERIS_H__9CAB1AD4_F75F_11D4_910A_5254ABDD22CE__INCLUDED_)
