// Tetris.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "Tetris.h"

#include "MainFrm.h"
#include "SuperLink.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int CTetrisApp::m_nLangue = CHINESE;

/////////////////////////////////////////////////////////////////////////////
// CTetrisApp

BEGIN_MESSAGE_MAP(CTetrisApp, CWinApp)
	//{{AFX_MSG_MAP(CTetrisApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_UPDATE_COMMAND_UI(ID_APP_ABOUT, OnUpdateAppAbout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTetrisApp construction

CTetrisApp::CTetrisApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CTetrisApp object

CTetrisApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CTetrisApp initialization

BOOL CTetrisApp::InitInstance()
{
	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Rigel Games"));

	// To create the main window, this code creates a new frame window
	// object and then sets it as the application's main window object.

	CMainFrame* pFrame = new CMainFrame;
	m_pMainWnd = pFrame;

	// create and load the frame with its resources

	pFrame->LoadFrame(IDR_MAINFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, NULL,
		NULL);


	HICON hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	pFrame->SetIcon(hIcon, TRUE);
//	pFrame->SetIcon(hIcon, FALSE);


	// The one and only window has been initialized, so show and update it.
	pFrame->ShowWindow(SW_SHOW);
	pFrame->UpdateWindow();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CTetrisApp message handlers





/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

	CSuperLink m_ctlSuperLink;
// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CTetrisApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

void CTetrisApp::OnUpdateAppAbout(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetText(GetLangueString("About"));
}

/////////////////////////////////////////////////////////////////////////////
// CTetrisApp message handlers

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	SetWindowText(GetLangueString("About Tetris"));
	SetDlgItemText(IDC_TXT_VERSION, GetLangueString("Version"));
	SetDlgItemText(IDC_TXT_COPYRIGHT, GetLangueString("Copyright"));

	m_ctlSuperLink.SubclassDlgItem(IDC_TXTSUPERLINK, this);
	m_ctlSuperLink.SetSuperLink(TRUE);
	m_ctlSuperLink.SetLinkCursor(AfxGetApp()->LoadCursor(IDC_CURSOR_HAND));
	m_ctlSuperLink.SetLinkAddress("Rigel@163.com");

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

CString GetLangueString(const CString str)
{
	CString strLangue;
	if (CTetrisApp::m_nLangue == CTetrisApp::ENGLISH)
		strLangue = CString("Langue\\English");
	else
		strLangue = CString("Langue\\Chinese");

	return AfxGetApp()->GetProfileString(strLangue, str, str);
}

void LangueChange(int nLangue)
{
	if (CTetrisApp::m_nLangue == nLangue) return;
	CTetrisApp::m_nLangue = nLangue;

	CString strLangue;
	if (CTetrisApp::m_nLangue == CTetrisApp::ENGLISH)
		strLangue = CString("Langue\\English");
	else
		strLangue = CString("Langue\\Chinese");

	CTetrisApp *pApp = (CTetrisApp*)AfxGetApp();
	AfxGetMainWnd()->SetWindowText(pApp->GetProfileString(strLangue, "AppName"));
	CMenu *pMenu = AfxGetMainWnd()->GetMenu();

	pMenu->ModifyMenu(0, MF_BYPOSITION, 0, pApp->GetProfileString(strLangue, "Game"));
	pMenu->ModifyMenu(1, MF_BYPOSITION, 0, pApp->GetProfileString(strLangue, "&Option"));
	pMenu->ModifyMenu(2, MF_BYPOSITION, 0, pApp->GetProfileString(strLangue, "Help"));
	
	CMenu *pSubMenu;
	pSubMenu = pMenu->GetSubMenu(1);
//	pSubMenu->ModifyMenu(0, MF_BYPOSITION, 0, pApp->GetProfileString(strLangue, "Setting"));
	pSubMenu->ModifyMenu(1, MF_BYPOSITION, 0, pApp->GetProfileString(strLangue, "Langue"));

	pApp->WriteProfileInt("Langue", "Langue", CTetrisApp::m_nLangue);
	AfxGetMainWnd()->DrawMenuBar();
}

CString UintToString(UINT nChar)
{
	CString strRet;
	CString strFmt;
	switch (nChar)
	{
	case 37:
		strFmt = "";
		//strFmt = "Left";
		break;
	case 38:
		strFmt = "";
		//strFmt = "Up";
		break;
	case 39:
		strFmt = "";
		//strFmt = "Right";
		break;
	case 40:
		strFmt = "";
		//strFmt = "Down";
		break;
	default:
		strFmt = "%c";
	}
//	strRet.Format(strFmt + "  -  %d", nChar, nChar);
	strRet.Format(strFmt, nChar);
	return strRet;
}

