#ifdef  WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif

#include<windows.h>
#include<windowsx.h>
#include<ddraw.h>
#include<stdio.h>
#include<stdlib.h>
#include<mmsystem.h>
#include<math.h>
#include<direct.h>
#include<wingdi.h>
#include<dsound.h>
#include<winbase.h>
#include<dinput.h>
#include"resource.h"
#include"ddutil.h"
#include"dsutil.h"

#define GameLogo  1//Ϸ
#define GameInit  2//
#define GameReady 3
#define GameStart 4//Ϸʼ
#define GamePass  5//Ϸ
#define GameWin   6//Ϸʤ
#define GameOver  7//Ϸ
#define GameSpeed 1//Ϸٶ

#define DINPUT_BUFFERSIZE		16	

#define Aup         0
#define Aright      1
#define Adown       2
#define Aleft       3

#define cenemy     10//л
#define ctree      40//
#define cmap       10//Ϸͼ

#define leftblank  100//ͼߵؾ
#define super       0//
#define control     1//޵ʱ
#define Fplane      0//ɻӵ
#define Fenemy      1//ؼӵ
#define TimeValue   20

#define name      "fight"
#define title     "fight"
 	
class PLANE
{
public:
	int   planestatus;//ɻ״̬
 	int   lifenum;//ɻ
	int   x,y;//ɻ
	int   height,width;//ɻҳĳߴ
	int   speed;//ɻٶ
	int   direct;//ɻ
	bool  bfire;//ǷԷӵ
	bool  bdead;//ɻǷ
};

class FIRE
{
public:
	int   x,y;
	int   height,width;
	int   speed;
	int   direct;
	int   Efire;
    bool  bdead;//ӵǷҪʾ
	bool  type;//ǷɻĻǵл
};

class ENEMY
{
public:
	int   x,y;
	int   height,width;
	int   speed;
	int   direct;
	bool  bfire;
	bool  bdead;
};
 
class TREE
{
public:
	int   x,y;
	int   height,width;
	int   type;//ָ
};

class FLAME
{
public:
	int   x,y;
	int   height,width;
	int   ftps;//ʾǱը̵ĵftps
    bool  bdead;
};
class MAP
{
public:
	int x,y;
	int height,width;
};

LPDIRECTDRAW              lpdd=NULL;
LPDIRECTDRAWSURFACE       lpddsprimary=NULL;
LPDIRECTDRAWSURFACE       lpddsback=NULL;
LPDIRECTDRAWSURFACE       lpddsbackground=NULL;
LPDIRECTDRAWSURFACE       lpddsmap=NULL;
LPDIRECTDRAWSURFACE       lpddsflame=NULL;
LPDIRECTDRAWSURFACE       lpddstree[3];
LPDIRECTDRAWSURFACE       lpddsplane[4];
LPDIRECTDRAWSURFACE       lpddsenemy[4];
LPDIRECTDRAWSURFACE       lpddsfire[4];
LPDIRECTSOUND			  lpds=NULL;
LPDIRECTSOUNDBUFFER		  lpdsbprimary=NULL;
LPDIRECTSOUNDBUFFER		  lpdsbshot=NULL;
LPDIRECTINPUT			  lpdi=NULL;
LPDIRECTINPUTDEVICE		  lpKeybord=NULL;

unsigned int     active;//Ƿ񼤻
int       gamestatus=GameLogo;//ϷĽ
int       gamerank=0;//Ϸȼ
int       supertime=0;//ɻ޵еʱ
HWND      hWnd=NULL;
PLANE     A11;
ENEMY     Aenemy[cenemy];
FLAME     Aflame[cenemy];
FIRE      Afire[cenemy];
TREE      Atree[ctree];     
MAP       Amap;
DWORD     thistickcount;
DWORD     lasttickcount;
char	  apppath[50];		//Ӧó·
char   	  openmidi[50];		//midiַ
char	  closemidi[50];	//رmidiַ
char	  stopmidi[50];
int		  nsorce;

HRESULT   CALLBACK WinProc(HWND hwnd,UINT msg,WPARAM wParam,
						   LPARAM lParam);
HWND InitWin(HINSTANCE hInstance,int nCmdShow);
void GetRect(RECT *rect,long x,long y,long height,long width);
void FreeObject(void);
void InitData(void);//ʼ
bool InitDraw(void);//ʼdirectdrawӿ
bool InitSound(void);
bool InitInput(HWND);
HRESULT UpdataInputData(void);
void InitPass(void);//غݱ任
bool DrawMap(void);
bool DrawPlane(void);
bool DrawEnemy(void);
bool DrawFire(void);
bool DrawFlame(void);
bool DrawInfoText(void);
void DrawText(void);
void GetInput(void);
void EnemyAI(void);//ƵлСܵĶ
bool Hit(RECT drect,RECT srect);
void Checkhit(void);
void DataPro(void);//ɻӵСܶݴ
void PlaySound(void);
void UpFlame(void);
void Flip(void);
void ClrScr(void);//

void FreeObject(void)
{
    if (lpdi!=NULL) 
    { 
        if(lpKeybord) 
        { 
            lpKeybord->Unacquire(); 
            lpKeybord->Release();
            lpKeybord = NULL; 
        }
        lpdi->Release();
        lpdi = NULL;
	}

	if(lpds!=NULL)
	{
		if(lpdsbprimary!=NULL)
		{
			lpdsbprimary->Release();
			lpdsbprimary=NULL;
		}
		if(lpdsbshot!=NULL)
		{
			lpdsbshot->Release();
			lpdsbshot=NULL;
		}
	}
	if(lpdd!=NULL)
	{
		if(lpddsprimary!=NULL)
		{
			lpddsprimary->Release();
       		lpddsprimary=NULL;
		}
		if(lpddsback!=NULL)
		{
			lpddsback->Release();
			lpddsback=NULL;
		}
		if(lpddsbackground!=NULL)
		{
			lpddsbackground->Release();
			lpddsbackground=NULL;
		}
		if(lpddsmap!=NULL)
		{
			lpddsmap->Release();
			lpddsmap=NULL;
		}
		if(lpddsflame!=NULL)
		{
			lpddsflame->Release();
			lpddsflame=NULL;
		}
		for(int i=0;i<3;i++)
			if(lpddstree[i]!=NULL)
			{
				lpddstree[i]->Release();
				lpddstree[i]=NULL;
			}
        for( i=0;i<4;i++)
			if(lpddsplane[i]!=NULL)
			{
				lpddsplane[i]->Release();
				lpddsplane[i]=NULL;
			}
        for( i=0;i<4;i++)
			if(lpddsenemy[i]!=NULL)
			{
				lpddsenemy[i]->Release();
				lpddsenemy[i]=NULL;
			}
        for( i=0;i<4;i++)
		    if(lpddsfire[i]!=NULL)
			{
			    lpddsfire[i]->Release();
				lpddsfire[i]=NULL;
			}
		lpdd->Release();
		lpdd=NULL;
	}
}
//***********************************************
//ʼʹڲhwndhWndȫֱ
//***********************************************
HWND InitWin(HINSTANCE hInstance,int nCmdShow)
{
	HWND            hwnd;
	WNDCLASS        wc;
	HDC				hdc;

	wc.style=CS_HREDRAW | CS_VREDRAW ; 
	wc.lpfnWndProc=WinProc;
	wc.cbClsExtra=0;
	wc.cbWndExtra=0;
	wc.hInstance=hInstance;
	wc.hIcon=LoadIcon(NULL,"icon");
	wc.hCursor=LoadCursor(NULL,IDC_ARROW);
    wc.hbrBackground=(HBRUSH)GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName=0;
	wc.lpszClassName=name;

	if(FAILED(RegisterClass(&wc)))
	{
		MessageBox(NULL,"failed in register",NULL,NULL);
		return 0;
	}

    
	hwnd=CreateWindow(name,title,WS_OVERLAPPEDWINDOW,0,0,
		                CW_USEDEFAULT,
						CW_USEDEFAULT,
						NULL,NULL,hInstance,NULL);
	if(!hwnd)
	{
		MessageBox(hwnd,"failed in hwnd","HWND",NULL);
		return FALSE;
	}
	ShowWindow(hwnd,nCmdShow);
	UpdateWindow(hwnd);
	SetFocus(hwnd);
	hdc=GetDC(hwnd);
	SetTextColor(hdc, RGB(250,250,250));
	SetBkMode(hdc, TRANSPARENT);
	TextOut(hdc,250,200,"Loading...",10);
	return hwnd;
}
//------------------------------------------------
//ʼdirectsound
//-------------------------------------------------
bool InitSound(void)
{
	HRESULT			hr;
	DSBUFFERDESC	dsbdesc;
	WAVEFORMATEX	wfm;

	if(FAILED(DirectSoundCreate(NULL,&lpds,NULL)))
	{
		OutputDebugString("failed in create directsound");
		return FALSE;
	}

	if(FAILED(lpds->SetCooperativeLevel(hWnd,DSSCL_PRIORITY)))
	{
		OutputDebugString("failed in setcoolevel");
	}

	memset(&dsbdesc,0,sizeof(DSBUFFERDESC));

	dsbdesc.dwSize=sizeof(DSBUFFERDESC);
	dsbdesc.dwFlags=DSBCAPS_PRIMARYBUFFER;
	dsbdesc.dwBufferBytes=0;
	dsbdesc.lpwfxFormat=NULL;

    ZeroMemory( &wfm, sizeof(WAVEFORMATEX) ); 
    wfm.wFormatTag      = WAVE_FORMAT_PCM; 
    wfm.nChannels       = 2; 
    wfm.nSamplesPerSec  = 22050; 
    wfm.wBitsPerSample  = 16; 
    wfm.nBlockAlign     = wfm.wBitsPerSample / 8 * wfm.nChannels;
    wfm.nAvgBytesPerSec = wfm.nSamplesPerSec * wfm.nBlockAlign;
	hr=lpds->CreateSoundBuffer(&dsbdesc,&lpdsbprimary,NULL);

	if(SUCCEEDED(hr))
	{
		hr=lpdsbprimary->SetFormat(&wfm);
	}
	else
	{
        OutputDebugString("failed in create primary bufefer\n");
	} 

	lpdsbshot=DSLoadSoundBuffer(lpds,"SHOT");

	if(lpdsbshot==NULL)
	{
		OutputDebugString("failed in create shot buffer\n");
		
		return FALSE;
	}

	return	TRUE;
}
//*****************************************************
//
//*****************************************************
void PlaySound(void)
{
	if(lpdsbshot==NULL)return;

	lpdsbshot->SetCurrentPosition(0);

	if(FAILED(lpdsbshot->Play(0,0,0)))
	{
		OutputDebugString("failed in play");

	}
	
	return;
}
//*************************************************
//ʼdirectinput
//*************************************************
bool InitInput(HWND hwnd)
{
	HRESULT		hr;

	hr=DirectInputCreate((HINSTANCE)GetWindowLong( hwnd, GWL_HINSTANCE ),
		                 DIRECTINPUT_VERSION,
						 &lpdi,NULL);
	if(FAILED(hr))
	{
		OutputDebugString("failed in create dinput");
		return false;
	}

	hr=lpdi->CreateDevice(GUID_SysKeyboard,&lpKeybord,NULL);

	if(FAILED(hr))
	{
		OutputDebugString("failed in create diput device");
		return false;
	}

	hr=lpKeybord->SetDataFormat(&c_dfDIKeyboard);
	if(FAILED(hr))
	{
		OutputDebugString("failed in setformat");
		return false;
	}

	hr=lpKeybord->SetCooperativeLevel(hwnd,DISCL_NONEXCLUSIVE|
		                                   DISCL_FOREGROUND);
	if(FAILED(hr))
	{
		OutputDebugString("failed in set co level");
		return false;
	}

	DIPROPDWORD		property;

	property.diph.dwSize=sizeof(DIPROPDWORD);
	property.diph.dwHeaderSize=sizeof(DIPROPHEADER);
	property.diph.dwHow=DIPH_DEVICE;
	property.diph.dwObj=0;
	property.dwData=DINPUT_BUFFERSIZE;

	hr=lpKeybord->SetProperty(DIPROP_BUFFERSIZE,&property.diph);
    if(FAILED(hr))
	{
		OutputDebugString("failed in set property ");
		return false;
	}

	hr=lpKeybord->Acquire();
    if(FAILED(hr))
	{
		OutputDebugString("failed acquire the keyborad");
		return false;
	}
	
	return true;
}

//*************************************************
//ж
//*************************************************
HRESULT UpdataInputData(void)
{
	DWORD i;
	DIDEVICEOBJECTDATA	didod[DINPUT_BUFFERSIZE];
	DWORD				dwElements;
	HRESULT				hr;

	if(lpKeybord!=NULL)
	{
		hr=DIERR_INPUTLOST;

		while(hr!=DI_OK)
		{
			dwElements=DINPUT_BUFFERSIZE;
			hr=lpKeybord->GetDeviceData(sizeof(DIDEVICEOBJECTDATA),
				                        didod,
										&dwElements,
										0);

			if(hr!=DI_OK)
			{
				hr=lpKeybord->Acquire();
				if(FAILED(hr))
				{
					OutputDebugString("failed buffer data acquire");
					return hr;
				}
			}
		}

		if(FAILED(hr))
		{
			OutputDebugString("failed buffer data acquire again");
			return hr;
		}	
    
	   for(i=0; i<dwElements; i++)
	   {
			if((int)didod[i].dwOfs==DIK_UP&&(didod[i].dwData&0x80))
			{
				A11.direct=Aup;
			}
	
			if((int)didod[i].dwOfs==DIK_RIGHT&&(didod[i].dwData&0x80))
			{
				A11.direct=Aright;
			}
			
			if((int)didod[i].dwOfs==DIK_DOWN&&(didod[i].dwData&0x80))
			{
				A11.direct=Adown;
			}
			
			if((int)didod[i].dwOfs==DIK_LEFT&&(didod[i].dwData&0x80))
			{
				A11.direct=Aleft;
			}
			
			if((int)didod[i].dwOfs==DIK_SPACE&&(didod[i].dwData&0x80))
			{
				if(A11.bfire)return S_OK;
				A11.bfire=TRUE;
				while(!Afire[i].bdead){i++;}
				if(i<cenemy)
				{
					Afire[i].bdead=FALSE;
					Afire[i].direct=A11.direct;
					Afire[i].type=Fplane;
					Afire[i].x=A11.x+2*A11.width/6;
					Afire[i].y=A11.y+2*A11.height/6;
				}
			}
		}
	}
    return S_OK;
}
//*************************************************
//ʼdirectxҴȫֱhWndinitdraw
//*************************************************
bool InitDraw(void)
{
	DDSURFACEDESC         ddsd;
	DDSCAPS               ddscaps;

	if(FAILED(DirectDrawCreate(NULL,&lpdd,NULL)))
	{
		MessageBox(hWnd,"failed in create lpdd","LPDD",NULL);
		return FALSE;
	}

	if(FAILED(lpdd->SetCooperativeLevel(hWnd,DDSCL_EXCLUSIVE|
		                                DDSCL_FULLSCREEN)))
    {
		MessageBox(hWnd,"failed in setcolevel","DDSCL",NULL);
		return FALSE;
	}

	if(FAILED(lpdd->SetDisplayMode(800,600,32)))
	{
		MessageBox(hWnd,"failed in set display mode","SETMODE",NULL);
		return FALSE;
	}

	ZeroMemory(&ddsd,sizeof(ddsd));
	ddsd.dwSize=sizeof(ddsd);
	ddsd.dwFlags=DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE|
		                DDSCAPS_FLIP|
						DDSCAPS_COMPLEX;
	ddsd.dwBackBufferCount=1;

	if(FAILED(lpdd->CreateSurface(&ddsd,&lpddsprimary,NULL)))
	{
		MessageBox(hWnd,"failed in create primary","PRIMARY",NULL);
		return FALSE;
	}

	ddscaps.dwCaps=DDSCAPS_BACKBUFFER;
	if(FAILED(lpddsprimary->GetAttachedSurface(&ddscaps,&lpddsback)))
	{
		MessageBox(hWnd,"failed in attach","ATTACH",NULL);
		return FALSE;
	}
//	lpddsbackgroundҳ
	ddsd.dwFlags=DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;
	ddsd.dwHeight=600;
	ddsd.dwWidth=800;
	ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
	if(FAILED(lpdd->CreateSurface(&ddsd,&lpddsbackground,NULL)))
	{
		MessageBox(hWnd ,"failed in create back ground","MAGROUND",NULL);
		return FALSE;
	}
	if(FAILED(DDReLoadBitmap(lpddsbackground,"ground.bmp")))
	{
		MessageBox(hWnd,"failed in Load GROUND","LOADGROUND",NULL);
		return FALSE;
	}
	//lpddsmapҳ
	ddsd.dwFlags=DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;
	ddsd.dwHeight=60;
	ddsd.dwWidth=60;
	ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
	if(FAILED(lpdd->CreateSurface(&ddsd,&lpddsmap,NULL)))
	{
		MessageBox(hWnd ,"failed in create map","MAP",NULL);
		return FALSE;
	}
	if(FAILED(DDReLoadBitmap(lpddsmap,"mpfield.bmp")))
	{
		MessageBox(hWnd,"failed in Load map","LOADMAP",NULL);
		return FALSE;
	}
    //lpddsflameҳ
	ddsd.dwHeight=66;
	ddsd.dwWidth=528;
	ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
	if(FAILED(lpdd->CreateSurface(&ddsd,&lpddsflame,NULL)))
	{
		MessageBox(hWnd,"failed in create flame","FLAME",NULL);
		return FALSE;
	}
	if(FAILED(DDReLoadBitmap(lpddsflame,"flame.bmp")))
	{
		MessageBox(hWnd,"failed load flame","LOADFLAME",NULL);
		return FALSE;
	}
	if(FAILED(DDSetColorKey(lpddsflame,CLR_INVALID)))
	{
		MessageBox(hWnd,"failed in set color","FLAMECOLOR",NULL);
		return FALSE;
	}	 
    //lpddsplaneɻҳ
    ddsd.dwWidth=50;
	ddsd.dwHeight=60;
	ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
    lpdd->CreateSurface(&ddsd,&lpddsplane[0],NULL);
    lpdd->CreateSurface(&ddsd,&lpddsplane[2],NULL);
	DDReLoadBitmap(lpddsplane[0],"plane.bmp");
	DDReLoadBitmap(lpddsplane[2],"plane2.bmp");
    DDSetColorKey(lpddsplane[0],RGB(0,0,0));
    DDSetColorKey(lpddsplane[2],RGB(0,0,0));
    
	ddsd.dwWidth=60;
	ddsd.dwHeight=50;
    lpdd->CreateSurface(&ddsd,&lpddsplane[1],NULL);
    lpdd->CreateSurface(&ddsd,&lpddsplane[3],NULL);
	DDReLoadBitmap(lpddsplane[1],"plane1.bmp");
	DDReLoadBitmap(lpddsplane[3],"plane3.bmp");
    DDSetColorKey(lpddsplane[1],RGB(0,0,0));
    DDSetColorKey(lpddsplane[3],RGB(0,0,0));
    //lpddsenemyлҳ
	 ddsd.dwHeight=35;
	 ddsd.dwWidth=35;
	 lpdd->CreateSurface(&ddsd,&lpddsenemy[0],NULL);
     lpdd->CreateSurface(&ddsd,&lpddsenemy[1],NULL);
     lpdd->CreateSurface(&ddsd,&lpddsenemy[2],NULL);
     lpdd->CreateSurface(&ddsd,&lpddsenemy[3],NULL);

	 DDReLoadBitmap(lpddsenemy[0],"enemy.bmp");
	 DDReLoadBitmap(lpddsenemy[1],"enemy1.bmp");
	 DDReLoadBitmap(lpddsenemy[2],"enemy2.bmp");
	 DDReLoadBitmap(lpddsenemy[3],"enemy3.bmp");

	 DDSetColorKey(lpddsenemy[0],CLR_INVALID);
	 DDSetColorKey(lpddsenemy[1],CLR_INVALID);
	 DDSetColorKey(lpddsenemy[2],CLR_INVALID);
	 DDSetColorKey(lpddsenemy[3],CLR_INVALID);
     //lpddsfireӵҳ
	 ddsd.dwHeight=36;
  	 ddsd.dwWidth=14;
	 lpdd->CreateSurface(&ddsd,&lpddsfire[0],NULL);
	 lpdd->CreateSurface(&ddsd,&lpddsfire[2],NULL);
     DDReLoadBitmap(lpddsfire[0],"fire.bmp");
     DDReLoadBitmap(lpddsfire[2],"fire2.bmp");
  	 DDSetColorKey(lpddsfire[0],CLR_INVALID);
     DDSetColorKey(lpddsfire[2],CLR_INVALID);

 	 ddsd.dwHeight=14;
	 ddsd.dwWidth=36;
	 lpdd->CreateSurface(&ddsd,&lpddsfire[1],NULL);
	 lpdd->CreateSurface(&ddsd,&lpddsfire[3],NULL);
     DDReLoadBitmap(lpddsfire[1],"fire1.bmp");    
     DDReLoadBitmap(lpddsfire[3],"fire3.bmp");
  	 DDSetColorKey(lpddsfire[1],CLR_INVALID);
     DDSetColorKey(lpddsfire[3],CLR_INVALID);
     //lpddstreeҳ
	 ddsd.dwHeight=30;
	 ddsd.dwWidth=30;
	 lpdd->CreateSurface(&ddsd,&lpddstree[0],NULL);
	 lpdd->CreateSurface(&ddsd,&lpddstree[1],NULL);
	 lpdd->CreateSurface(&ddsd,&lpddstree[2],NULL);

	 DDReLoadBitmap(lpddstree[0],"mptree.bmp");
	 DDReLoadBitmap(lpddstree[1],"mptree1.bmp");
	 DDReLoadBitmap(lpddstree[2],"mptree2.bmp");

	 DDSetColorKey(lpddstree[0],RGB(0,0,0));	                
	 DDSetColorKey(lpddstree[1],RGB(0,0,0));
	 DDSetColorKey(lpddstree[2],RGB(0,0,0));

	//ȡõǰ·
	_getcwd( apppath, sizeof(apppath));
	strcpy(openmidi, "play ");
	strcat(openmidi, apppath);
	strcat(openmidi, "\\a.mid");
	strcpy(closemidi, "close ");
	strcat(closemidi, apppath);
	strcat(closemidi, "\\a.mid");
	strcpy(stopmidi, "stop");
	strcat(stopmidi, apppath);
	strcat(stopmidi, "\\a.mid");
	//midi
	char buf[256];
	mciSendString(openmidi, buf, sizeof(buf), NULL);

	 return TRUE;
}
//**************************************************
//ʼɻȵݣ
//**************************************************
void InitData(void)
{
   
	A11.x=400;
	A11.y=400;//ʼķɻ
	A11.width=50;
	A11.height=60;
    A11.planestatus=super;
	A11.speed=4*GameSpeed;
	A11.lifenum=3;
	A11.bfire=TRUE;//ܷӵ
	A11.direct=Aup;
	A11.bdead=TRUE;//

	supertime=0;

	Amap.height=60;
	Amap.width=60;
	Amap.x=0;
	Amap.y=0;

	for(int i=0;i<cenemy;i++)
	{
		Aenemy[i].bfire=FALSE;//ܷӵ
		Aenemy[i].bdead=TRUE;//
		Aenemy[i].direct=rand()%4;
		Aenemy[i].height=35;
		Aenemy[i].width=35;
		Aenemy[i].speed=2*GameSpeed;
		Aenemy[i].x=100;
		Aenemy[i].y=50;
	}
	for(i=0;i<cenemy;i++)
	{
		Aflame[i].height=66;
		Aflame[i].width=66;
		Aflame[i].x=100;
		Aflame[i].y=0;
		Aflame[i].ftps=0;
		Aflame[i].bdead=TRUE;
	}
	for(i=0;i<cenemy;i++)
	{
		Afire[i].Efire=0;
		Afire[i].height=36;
		Afire[i].width=14;
		Afire[i].bdead=TRUE;
		Afire[i].direct=Aup;
		Afire[i].speed =7*GameSpeed;
		Afire[i].type =Fplane;
		Afire[i].x=100;
		Afire[i].y=0;
	}
	for(i=0;i<ctree;i++)
	{
		Atree[i].height=30;
		Atree[i].width=30;
		Atree[i].type=rand()%3;
		Atree[i].x=rand()%570+leftblank;
		Atree[i].y=rand()%570;
	}
}
//**************************************************
//ͼһ㻭رڶ㻭
//**************************************************
bool DrawMap(void)
{
	if(FAILED(lpddsback->BltFast(0,0,lpddsbackground,NULL,DDBLTFAST_WAIT)))
	{
		MessageBox(hWnd,"failed blt ground",NULL,NULL);
		return FALSE;
	}

	for(int i=0;i<cmap;i++)
		for(int j=0;j<cmap;j++)
		{
			if(FAILED(lpddsback->BltFast((leftblank+i*Amap.width),
				                j*Amap.height,
								lpddsmap,NULL,DDBLTFAST_WAIT)))
			{
				MessageBox(hWnd,"failed draw map","DRAWMAP",NULL);
				return FALSE;
			}
		}
    for(i=0;i<ctree;i++)
	{
	   	if(FAILED(lpddsback->BltFast(Atree[i].x,Atree[i].y,
			               lpddstree[Atree[i].type],NULL,
						   DDBLTFAST_WAIT|
						   DDBLTFAST_SRCCOLORKEY)))
		{
			MessageBox(hWnd,"failed in draw tree","DRAWTREE",NULL);
			return FALSE;
		}
	}


	return TRUE;
}
//*************************************************
//ɻ
//*************************************************
bool DrawPlane(void)
{
	static int ot,nt,lt;//ֱʱ䡢ʱ䡢޵гʱ䣻
	if(gamestatus==GameOver)return TRUE;
    if(A11.bdead)return TRUE;

	if(A11.y< 0 ){A11.y=0  ;}
	if(A11.y>540){A11.y=540;}
	
	if(A11.planestatus==super)
	{
		A11.bfire=TRUE;
		supertime++;

		if(supertime==80)
		{
			A11.planestatus=control;
			supertime=0;
			A11.bfire=FALSE;
		}

		nt=GetTickCount();
		if((nt-ot)>35)
		{
			ot=GetTickCount();
            if(FAILED(lpddsback->BltFast(A11.x,A11.y,
		                         lpddsplane[A11.direct],NULL,
								 DDBLTFAST_WAIT|
								 DDBLTFAST_SRCCOLORKEY)))
			{
				MessageBox(hWnd,"failed in draw plane","DRAWPLANE",NULL);
		        return FALSE;
			}
		}
	}
	else
	{
		if(FAILED(lpddsback->BltFast(A11.x,A11.y,
		                         lpddsplane[A11.direct],NULL,
								 DDBLTFAST_WAIT|
								 DDBLTFAST_SRCCOLORKEY)))
		{
			MessageBox(hWnd,"failed in draw plane","DRAWPLANE",NULL);
		    return FALSE;
		}
	}

	for(int i=0;i<A11.lifenum-1;i++)
	{
		
		if(FAILED(lpddsback->BltFast(i*50,20,
								 lpddsplane[Aup],NULL,
								 DDBLTFAST_WAIT|
								 DDBLTFAST_SRCCOLORKEY)))
		{
			MessageBox(hWnd,"failed in draw plane","DRAWPLANE",NULL);
		    return FALSE;
		}
	}

	return TRUE;
}
//**********************************************
//л
//**********************************************
bool DrawEnemy(void)
{
	if(gamestatus==GameOver)return TRUE;
//    if(gamestatus==GamePass)return TRUE;
	for(int i=0;i<gamerank;i++)
	{
 		if(!Aenemy[i].bdead)
		{
			if(FAILED(lpddsback->BltFast(Aenemy[i].x,Aenemy[i].y,
			                 lpddsenemy[Aenemy[i].direct],NULL,
							 DDBLTFAST_WAIT|DDBLTFAST_SRCCOLORKEY)))
			{
				MessageBox(hWnd,"failed in blt enemy","DRAWENEMY",NULL);
			    return FALSE;
			}
		}
	}
	int x=0;
	int y=0;
	for(i=0;i<nsorce;i++)
	{		
		if(y>15){x=1;y=0;}		
		
		if(FAILED(lpddsback->BltFast(700+x*35,(y*35+10),
	                 lpddsenemy[Aup],NULL,
					 DDBLTFAST_WAIT|DDBLTFAST_SRCCOLORKEY)))
		{
			MessageBox(hWnd,"failed in blt enemy","DRAWENEMY",NULL);
		    return FALSE;
		}
		y++;
	}
	return TRUE;
 		
}
//************************************************************
//ӵ
//************************************************************
bool DrawFire(void)
{
	if(gamestatus==GameOver)return TRUE;

	for(int i=0;i<cenemy;i++)
	{
		if(!Afire[i].bdead )
		{
			if(Afire[i].x<102)Afire[i].x=100;
			if(Afire[i].x>660)Afire[i].x=664;
			if(Afire[i].y<10 )Afire[i].y=0  ;
			if(Afire[i].y>560)Afire[i].y=564;

			if(FAILED(lpddsback->BltFast(Afire[i].x ,Afire[i].y,
				               lpddsfire[Afire[i].direct],NULL,
							   DDBLTFAST_WAIT|
							   DDBLTFAST_SRCCOLORKEY)))
			{
				MessageBox(hWnd,"failed in draw fire","DRAWFIRE",NULL);
				return FALSE;
			}
		}
	}
	return TRUE;
}
//************************************************************
//ըЧ
//************************************************************
bool DrawFlame(void)
{
    RECT srect;
	for(int i=0;i<cenemy;i++)
	{
		if(!Aflame[i].bdead)
		{
			GetRect(&srect,Aflame[i].ftps*66,0,66,66);


            if(Aflame[i].x<100){Aflame[i].x=100;}
			if(Aflame[i].x>640){Aflame[i].x=640;}
			if(Aflame[i].y<0  ){Aflame[i].y=0  ;}
			if(Aflame[i].y>530){Aflame[i].y=530;}
		
			if(FAILED(lpddsback->BltFast(Aflame[i].x,Aflame[i].y,
				                   lpddsflame,&srect,
								   DDBLTFAST_WAIT|
								   DDBLTFAST_SRCCOLORKEY)))
			{
				MessageBox(hWnd,"failed in draw flame","DRAWFLAME",NULL);
				return FALSE;
			}

			static int otime[cenemy];
			if(GetTickCount()-otime[i]>100)
			{
				otime[i]=GetTickCount();
				Aflame[i].ftps++;
				if(Aflame[i].ftps==4)
				{
					PlaySound();
				}

				if(Aflame[i].ftps==8)
				{
//					PlaySound("shot.wav",NULL,0);
	            	Aflame[i].height=66;
		            Aflame[i].width=66;
		            Aflame[i].x=100;
		            Aflame[i].y=0;
		            Aflame[i].ftps=0;
		            Aflame[i].bdead=TRUE;
				}
			}
		}
	}
	return TRUE;
}
//*******************************************************
//ݵı仯
//*******************************************************
void DataPro(void)
{
	if(gamestatus==GameOver)return; 
	if(A11.lifenum<=0){A11.bdead=TRUE;gamestatus=GameOver;}

	if(!A11.bdead)
	{
		if(A11.direct==Aup){A11.y-=A11.speed ;}
		if(A11.direct==Aright){A11.x+=A11.speed;}
		if(A11.direct==Adown){A11.y+=A11.speed;}
		if(A11.direct==Aleft){A11.x-=A11.speed;}
	}

	for(int i=0;i<gamerank;i++)
	{
		if(!Aenemy[i].bdead)
		{
			if(Aenemy[i].direct==Aup){Aenemy[i].y-=Aenemy[i].speed;}
			if(Aenemy[i].direct==Aright){Aenemy[i].x+=Aenemy[i].speed;}
			if(Aenemy[i].direct==Adown){Aenemy[i].y+=Aenemy[i].speed;}			
			if(Aenemy[i].direct==Aleft){Aenemy[i].x-=Aenemy[i].speed;}
		}
	}

	for( i=0;i<cenemy;i++)
	{
		if(!Afire[i].bdead)
		{
			if(Afire[i].direct==Aup){Afire[i].y-=Afire[i].speed;}
			if(Afire[i].direct==Aright){Afire[i].x+=Afire[i].speed;}
			if(Afire[i].direct==Adown){Afire[i].y+=Afire[i].speed;}
			if(Afire[i].direct==Aleft){Afire[i].x-=Afire[i].speed;}
		}
	}
}
//*****************************************************
//rect
//*****************************************************
void GetRect(RECT *srect,long x ,long y,long height,long width)
{
    srect->left=x;
	srect->top=y;
	srect->right=x+width;
	srect->bottom=y+height;
	return;
}
//**********************************************************
//תҳ
//**********************************************************
void Flip(void)
{
	HRESULT rval;

	while (1)
	{
	rval=lpddsprimary->Flip(NULL, DDFLIP_WAIT);
	if(rval == DDERR_SURFACELOST) lpddsprimary->Restore();
	else 
		break;
	}
	
	return ;
}
//********************************************************&|*
//
//***********************************************************
void GetInput(void)
{   
	int i=0;
	if(GetAsyncKeyState(VK_UP)){A11.direct=Aup;}
	if(GetAsyncKeyState(VK_RIGHT)){A11.direct=Aright;}
	if(GetAsyncKeyState(VK_DOWN)){A11.direct=Adown;}
	if(GetAsyncKeyState(VK_LEFT)){A11.direct=Aleft;}
	if(GetAsyncKeyState(VK_SPACE))
	{
		if(A11.bfire)return;
		A11.bfire=TRUE;
		while(!Afire[i].bdead){i++;}
		if(i<cenemy)
		{
			Afire[i].bdead=FALSE;
			Afire[i].direct=A11.direct;
			Afire[i].type=Fplane;
			Afire[i].x=A11.x+2*A11.width/6;
			Afire[i].y=A11.y+2*A11.height/6;
		}
	}
	return;
}
//**********************************************************
//checkhit()ײ
//**********************************************************
void CheckHit()
{
	//ע⣺
	//1.ڽײļʱľСڸֵľ롣
	//2.עײ롢ֵ롢ھϷԵĸֵ
	//a.(if(A11.x<100||A11.x>640||A11.y<5||A11.y>530)
	//    b.if(A11.y<10  ){Aflame[i].x=A11.x;Aflame[i].y=A11.y;} 
	//    c.if(Aflame[i].x<100){Aflame[i].x=100;}
	//еúʹС˳ϵ
	//򽫲ԤĽ
	RECT drect,srect;
	int i=0;
	//1.´οһ·ɻײʱӳ٣˸
    //2.ײľȷλ
	if(!A11.bdead)
	{
		if(A11.x<100||A11.x>640||A11.y<3||A11.y>535)
		{
			while(!Aflame[i].bdead){i++;}

			if(i<cenemy)
			{
				if(A11.y<5  ){Aflame[i].x=A11.x;Aflame[i].y=A11.y;}
				if(A11.y>535){Aflame[i].x=A11.x;Aflame[i].y=A11.y+5;}
				if(A11.x<103){Aflame[i].x=A11.x;Aflame[i].y=A11.y;}
				if(A11.x>640){Aflame[i].x=A11.x;Aflame[i].y=A11.y;}
				Aflame[i].bdead=FALSE;
				Aflame[i].ftps =0;
			}
			A11.lifenum--;
			A11.planestatus=super;
			A11.x=400;
			A11.y=400;
			A11.direct=Aup;
		}
	}
	for(int j=0;j<cenemy;j++)
	{
		i=0;
		if(!Afire[j].bdead)
		{
			if(Afire[j].x<103||Afire[j].x>660||Afire[j].y<2||Afire[j].y>560)
			{
				if(Afire[j].type==Fplane)A11.bfire=FALSE;
                else{Aenemy[Afire[j].Efire].bfire =FALSE;}
                Afire[j].bdead=TRUE;

				while(!Aflame[i].bdead){i++;}
				if(i<cenemy)
				{
					if(Afire[j].y<15 ){Aflame[i].x=Afire[j].x-15;Aflame[i].y=Afire[j].y;}
					if(Afire[j].y>560){Aflame[i].x=Afire[j].x-15;Aflame[i].y=Afire[j].y;}
					if(Afire[j].x<110){Aflame[i].x=Afire[j].x;Aflame[i].y=Afire[j].y-20;}
					if(Afire[j].x>660){Aflame[i].x=Afire[j].x;Aflame[i].y=Afire[j].y-20;}
					Aflame[i].bdead=FALSE;
				    Aflame[i].ftps=0;
				}
			}
		}
	}
	for(i=0;i<cenemy;i++)
	{
		if(!Afire[i].bdead)
		{	
			GetRect(&drect,Afire[i].x,Afire[i].y,Afire[i].height,Afire[i].width);
		    if(Afire[i].type==Fplane)
			{
				for(int k=0;k<cenemy;k++)
				{
					if(!Aenemy[k].bdead)
					{
						GetRect(&srect,Aenemy[k].x,Aenemy[k].y,Aenemy[k].height,Aenemy[k].width);
						if(Hit(drect,srect))
						{
							int h=0;
                            while(!Aflame[h].bdead){h++;}
							if(h<cenemy)
							{
								Aflame[h].bdead=FALSE;
								Aflame[h].ftps=0;
								Aflame[h].x=Aenemy[k].x;
								Aflame[h].y=Aenemy[k].y;
							}
							Aenemy[k].bdead=TRUE;
							nsorce++;
							Afire[i].bdead=TRUE;
							A11.bfire=FALSE;
						}
					}
				}
			}
			else
			{
				if(A11.planestatus==super)return;
				if(!A11.bdead)
				{
					GetRect(&srect,A11.x,A11.y,A11.height,A11.width);
                    if(Hit(drect,srect))
					{
						int n=0;
						while(!Aflame[n].bdead){n++;}
						if(n<cenemy)
						{
							Aflame[n].bdead=FALSE;
							Aflame[n].ftps=0;
							Aflame[n].x=A11.x;
							Aflame[n].y=A11.y;
						}
						A11.lifenum--;
						A11.planestatus=super;
						A11.x=400;
						A11.y=400;
						A11.direct=Aup;

						Afire[i].bdead=TRUE;
						Aenemy[Afire[i].Efire].bfire=FALSE;
					}
				}
			}
		}
	}
}
//********************************************************
//Hit()Ƿ໥ص
//********************************************************
bool Hit(RECT drect,RECT srect)
{
	int xcount,ycount;
	int xmax,ymax;

	xcount=abs((drect.left-srect.left));
	ycount=abs((drect.top-srect.top));

	if(drect.left<srect.left)xmax=4*(drect.right-drect.left)/5;
	else
		xmax=3*(srect.right-srect.left)/5;

	if(drect.top<srect.top)ymax=4*(drect.bottom-drect.top)/5;
	else
		ymax=4*(srect.bottom-srect.top)/5;

	if(xcount<xmax&&ycount<ymax)return TRUE;
	else
		return FALSE;
}
//******************************************************
//EnemyAIлķ䡢ܡ׷ٵȸ
//******************************************************
//1.ͬһֱȴ
//Ե׷ٵıȱԵĴ
//2.ͬһֱϣһİ뾶Ϊ׷ٷΧ
//3.ӵһͬĻΪܷΧ
//ͬʱܱȱܵĻʴ
//4.лмеĻʸߣΪȽ׷١
void EnemyAI(void)
{

	for(int i=0;i<cenemy;i++)
	{
		//ײ
		if(!Aenemy[i].bdead)
		{
			if(Aenemy[i].x<100||Aenemy[i].x>660||Aenemy[i].y<10||Aenemy[i].y>560)			
			{
				if(Aenemy[i].direct==Aup   ){Aenemy[i].y=10 ;}
				if(Aenemy[i].direct==Adown ){Aenemy[i].y=560;}
				if(Aenemy[i].direct==Aleft ){Aenemy[i].x=100;}
				if(Aenemy[i].direct==Aright){Aenemy[i].x=660;}
				Aenemy[i].direct+=rand()%3;
				Aenemy[i].direct=Aenemy[i].direct%4;//עԱȡֵĶ
			//:directԲܴ30123һ
				//Ҫֵм⡣
			}
		}
		//ƹ
		if(!Aenemy[i].bdead&&!Aenemy[i].bfire)
		{
			if((abs((Aenemy[i].y-A11.y))<10&&
				(((Aenemy[i].x-A11.x)>10&&(Aenemy[i].x-A11.x)<60&&Aenemy[i].direct==3)||
			     ((A11.x-Aenemy[i].x)>10&&(A11.x-Aenemy[i].x)<60&&Aenemy[i].direct==1)||
				 ((A11.x-Aenemy[i].x)>60&&(rand()%10==4)&&Aenemy[i].direct==1)||
				 ((Aenemy[i].x-A11.x)>60&&(rand()%10==4)&&Aenemy[i].direct==3)))||
				  (abs((Aenemy[i].x-A11.x))<10&&
				(((Aenemy[i].y-A11.y)>10&&(Aenemy[i].y-A11.y)<60&&Aenemy[i].direct==0)||
				 ((A11.y-Aenemy[i].y)>10&&(A11.y-Aenemy[i].y)<60&&Aenemy[i].direct==2)||
				 ((A11.y-Aenemy[i].y)>60&&(rand()%10==4)&&Aenemy[i].direct==2)||
				 ((Aenemy[i].y-A11.y)>60&&(rand()%10==4)&&Aenemy[i].direct==0))))
				 //
			{
				
				Aenemy[i].bfire=TRUE;

				int n=0;
				while(!Afire[n].bdead){n++;}

				if(n<cenemy)
				{
					Afire[n].bdead=FALSE;
					Afire[n].direct=Aenemy[i].direct;
					Afire[n].Efire=i;
					Afire[n].type=Fenemy;
					Afire[n].x=Aenemy[i].x+Aenemy[i].width/3;
					Afire[n].y=Aenemy[i].y+Aenemy[i].height/3;
				}
			}
		//׷ٹ 
        if(abs(Aenemy[i].y-A11.y)<8)
		{
			if(((Aenemy[i].x-A11.x)<100&&(Aenemy[i].x-A11.x)>30)||((Aenemy[i].x-A11.x)>100&&(rand()%10==5)))
				Aenemy[i].direct=3;
			if(((A11.x-Aenemy[i].x)<100&&(A11.x-Aenemy[i].x)>30)||((A11.x-Aenemy[i].x)>100&&(rand()%10==5)))
				Aenemy[i].direct=1;
		}
		if(abs(Aenemy[i].x-A11.x)<8)
		{
			if(((Aenemy[i].y-A11.y)<100&&(Aenemy[i].y-A11.y)>30)||((Aenemy[i].y-A11.y)>100&&(rand()%10==5)))
				Aenemy[i].direct=0;
			if(((A11.y-Aenemy[i].y)<100&&(A11.y-Aenemy[i].y)>30)||((A11.y-Aenemy[i].y)>100&&(rand()%10==5)))
				Aenemy[i].direct=2;
		}
		//λõĿƹܣ磺Ƿɻ󲿷ʱм䲿ַУԱɻ׷
		if(((Aenemy[i].x<200&&Aenemy[i].x>190)||
			(Aenemy[i].x>600&&Aenemy[i].x<610)||
			(Aenemy[i].y>500&&Aenemy[i].y<510)||
			(Aenemy[i].y<100&&Aenemy[i].y>90))&&
			(rand()%7==3))
		{
			Aenemy[i].direct+=rand()%10;
			Aenemy[i].direct=Aenemy[i].direct%4;
		}
		//ըĶܹܣһİ뾶ΪܷΧͬʱԲͬвͬĶܼʡ
		//if
		}
	}
}
//**********************************************************
//clrscr()
//**********************************************************
void clrscr(DWORD color=RGB(0,0,0))
{
	DDBLTFX ddbltfx;
	ddbltfx.dwSize=sizeof(ddbltfx);
	ddbltfx.dwFillColor=color;
	lpddsprimary->Blt(NULL,NULL,NULL,DDBLT_COLORFILL,&ddbltfx);
	lpddsback->Blt(NULL,NULL,NULL,DDBLT_COLORFILL,&ddbltfx);
}
//*********************************************************
//WinMain();
//*********************************************************
int CALLBACK WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine
,int nCmdShow)
{
	MSG msg;

	hWnd=InitWin(hInstance,nCmdShow);
    if(hWnd==NULL)
	{
		MessageBox(hWnd,"failed in initwin","INITWIN",NULL);
		return FALSE;
	}
	if(FAILED(InitDraw()))
	{
		FreeObject();
		PostQuitMessage(WM_CLOSE);
		return FALSE;
	}

	if(FAILED(InitInput(hWnd)))
	{
		OutputDebugString("failed init input ");
		PostQuitMessage(WM_CLOSE);
		return FALSE;
	}
	if(FAILED(InitSound()))
	{
		OutputDebugString("failed in initsouund");
		PostQuitMessage(WM_CLOSE);
		return FALSE;
	}

	InitData();
	clrscr();
	while(1)
	{
		if(PeekMessage(&msg,NULL,0,0,PM_NOREMOVE))
		{
			if(!GetMessage(&msg,NULL,0,0))
				return msg.wParam;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else if(active)
		{
			UpFlame();
		}
		else
			WaitMessage();
	}
}
//*********************************************************
//WinProc()ڴ
//*********************************************************
HRESULT CALLBACK WinProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	char buf[256];

	switch(msg)
	{
	case WM_ACTIVATEAPP:
		active=wParam;
    	SetFocus(hWnd);
		break;
	case WM_SETCURSOR:
		SetCursor(NULL);
		return TRUE;
	case  WM_KEYDOWN:
		switch(wParam)
		{
		case VK_ESCAPE:
			PostQuitMessage(0);
			break;
		case VK_RETURN:		
			mciSendString( closemidi, buf, sizeof(buf), NULL);
			mciSendString(openmidi, buf, sizeof(buf), NULL);
			InitData();
			nsorce=0;
			gamerank=0;
			gamestatus=GamePass;
			InitPass();
			A11.bfire=FALSE;
			if(A11.bdead)A11.bdead=FALSE;
			else
				A11.bdead=TRUE;
			gamestatus=GameStart;
			break;
		}
		break;
	case WM_DESTROY:

		FreeObject();
		mciSendString(stopmidi,buf,sizeof(buf),NULL);
		mciSendString( closemidi, buf, sizeof(buf), NULL);
		PostQuitMessage(0);
		break;
	}
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
//******************************************************
//UpFlame()
//******************************************************
void UpFlame(void)
{
	thistickcount=GetTickCount();
	if((thistickcount-lasttickcount)<TimeValue)return;
	else
	{
		DrawMap();
//		GetInput();
        UpdataInputData();
		DrawFire();
        DrawPlane();
		DrawEnemy();
	    EnemyAI();
		CheckHit();
		DrawFlame();
		DataPro();
		InitPass();
		DrawText();
		Flip();
	    lasttickcount=thistickcount;
	}
	return;
}
//********************************************************
//Initpass()غݴ
//********************************************************
void InitPass()
{
	int nok=0;
	if(gamestatus==GameStart)
	{
		for(int j=0;j<cenemy;j++)
		{
			if(Aenemy[j].bdead==TRUE)nok++;
		}
		if(nok==cenemy)
		{
			gamestatus=GamePass;
			A11.planestatus=super;
		}
	}

	if(gamestatus==GamePass)
	{
		gamerank++;
		if(gamerank>8)gamerank=8;
		for(int i=0;i<gamerank;i++)
		{			
			Aenemy[i].bfire =FALSE;
			Aenemy[i].bdead =FALSE;
			Aenemy[i].direct=rand()%4;
			Aenemy[i].x     =leftblank+rand()%560;
			Aenemy[i].y     =rand()%560;
		}
		gamestatus=GameStart;
	}
}
//********************************************************
//DrawText()text
//********************************************************
void DrawText()
{
//	HRESULT rval;
//	RECT rect;
	HDC hdc;
	char temp[100];

	lpddsback->GetDC(&hdc);
/*
	if(gamestatus==GameLogo)
	{

		SetBkMode(hdc, TRANSPARENT);//͸ӳ䷽ʽ.
		SetTextColor(hdc, RGB(100,100,0)); 
		sprintf(temp, "  FIGHY 0.6");
        TextOut(hdc,396,260,temp,strlen(temp));

		SetTextColor(hdc, RGB(0,200,100));
        TextOut(hdc,392,320," SPACE",12);
		TextOut(hdc,392,340," ESC  ",12);

		SetTextColor(hdc, RGB(200,0,100));
        sprintf(temp, ":ʢɽ SCUT");
		TextOut(hdc, 350, 280, temp,strlen(temp));

		sprintf(temp, "E_M: sintler@263.net");
		TextOut(hdc, 350, 300, temp,strlen(temp));
	}
	else
	{*/
		SetBkMode(hdc, TRANSPARENT);//͸ӳ䷽ʽ.
		SetTextColor(hdc, RGB(100,100,0)); 

		sprintf(temp, "    FIGHT 0.6");
		TextOut(hdc,0,360,temp,strlen(temp));

		SetTextColor(hdc, RGB(0,100,200)); 

        sprintf(temp, "  :ʢɽ ");
		TextOut(hdc,0,380, temp,strlen(temp));

        sprintf(temp, " 2001.10 SCUT");
		TextOut(hdc,0,400, temp,strlen(temp));

		SetTextColor(hdc, RGB(200,0,100));
		sprintf(temp, "sintler@263.net");
        TextOut(hdc, 0, 420, temp,strlen(temp));

        TextOut(hdc,0,440," SPACE",12);
		TextOut(hdc,0,460," ʼ: ENTER",12);
		TextOut(hdc,0,480," ESC  ",12);

		if(gamestatus==GameOver)
		{	
			SetTextColor(hdc, RGB(200,250,0)); 

		    sprintf(temp, "GAME OVER");
	    	TextOut(hdc,360,300,temp,strlen(temp));
		}

		if(gamestatus==GameStart)
		{
		SetTextColor(hdc, RGB(200,0,0));
        sprintf(temp,"Lifenum:  %d",A11.lifenum);
		TextOut(hdc,0,0,temp,strlen(temp));
		
        sprintf(temp,"SORCE:  %6d",nsorce*100);
		TextOut(hdc,700,0,temp,strlen(temp));

        sprintf(temp,"PART:  %d",gamerank);
		TextOut(hdc,700,500,temp,strlen(temp));
		}

		lpddsback->ReleaseDC(hdc);
}
