import java.sql.Connection;


public class QueryTest {
    public static void main(String[] args) throws Exception {
        Connection conn = SQLUtils.getConnection();

        for(int i = 0; i < 2; i++) {
            // reference data queries
            executeTimed(conn, "select * from testDataRef");
            
            // get last revision
            executeTimed(conn, "select * from testData where expired = " + Long.MAX_VALUE);
            
            // random revision extraction (first, middle, last)
            int rev = 0;
            executeTimed(conn, "select * from testData where revision <= " + rev + " and expired > " + rev);
            rev = 2000;
            executeTimed(conn, "select * from testData where revision <= " + rev + " and expired > " + rev);
            rev = 9999;
            executeTimed(conn, "select * from testData where revision <= " + rev + " and expired > " + rev);
            
            // bbox on reference
            String bbox = "GeometryFromText('POLYGON((0 0, 80 0, 80 80, 0 80, 0 0))', 4326)";
            executeTimed(conn, "select * from testDataRef where geom && " + bbox);
            
            // last revision + bbox 
            executeTimed(conn, "select * from testData where expired = " + Long.MAX_VALUE + " and geom && " + bbox);
            
            // mid revision + bbox 
            rev = 9999;
            executeTimed(conn, "select * from testData where revision <= " + rev + " and expired > " + rev + " and geom && " + bbox);
            
            System.out.println("----------------------------------------------------------");
            System.out.println();
        }
    }

    private static void executeTimed(Connection conn, String plainsql) throws Exception {
        long startTime = System.currentTimeMillis();
        int count = SQLUtils.executeQuery(conn, plainsql);
        double seconds = (System.currentTimeMillis() - startTime) / 1000.0;
//        System.out.println("Executed query: " + plainsql);
        System.out.println("Elapsed: " + seconds + " s, returned records:" + count);
        System.out.println();
    }
}
