import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SQLUtils {

    public static Connection getConnection() throws ClassNotFoundException, SQLException {
        Class.forName("org.postgresql.Driver");
        return DriverManager.getConnection("jdbc:postgresql:postgis", "postgres", "postgis");
    }

    public static void execute(Connection conn, String sql, boolean lenient) throws SQLException {
        System.out.println("Running: " + sql);
        Statement st = null;
        try {
            st = conn.createStatement();
            st.execute(sql);
        } catch (SQLException e) {
            if (!lenient)
                throw e;
        }
    }

    public static int executeQuery(Connection conn, String sql) throws SQLException {
        System.out.println("Running: " + sql);
        Statement st = null;
        ResultSet rs = null;
        int count = 0;
        try {
            st = conn.createStatement();
            rs = st.executeQuery(sql);
            int cols = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                for(int c = 1; c <= cols; c++)
                    rs.getObject(c);
                count++; // just scan thru
            }
        } finally {
            if (rs != null)
                rs.close();
            if (st != null)
                st.close();
        }
        return count;
    }

}
