#!/usr/bin/env python

#
# A sample client app for use with FSM/REST applications generated
#   with fsmGenerate.py.
#


import sys, re
import cmd
import StringIO
import httplib, socket


#
# Import the modules that parse and represent the XML interchange
#   documents.
#
import Continuesub, Finishsub, Fruitsub, Plantsub, Startsub, Vegetablesub


#
# Text for the "help" and "?" commands.
#
HELP_TEXT = """\
Commands:
    submit [ <arg1> ]            -- Submit a request.
    quit                         -- Exit.
    help                         -- Show this help.
"""


#
# Reg expr to extract current state name from XML interchange document.
#   We need this in order to determine which parser to use in order to
#   parse the entire document.
#
RE1 = re.compile("<fsmcurrentstate>(.*)</fsmcurrentstate>")


#
# Map state name to XML interchange document parser.
#
StateParserDict = {
    "Start": Startsub,
    "Plant": Plantsub,
    "Fruit": Fruitsub,
    "Vegetable": Vegetablesub,
    "Continue": Continuesub,
    "Finish": Finishsub
}


#
# Default XML interchange document content.
#   Use these to create documents to send to server.
#

Start_DEFAULT_CONTENT = """\
<fsmstate>
    <fsmcurrentstate>Start</fsmcurrentstate>
    <fsmurl>/FSM/Test/Tmp1/</fsmurl>
    <fsmstack></fsmstack>
    <fsmoutput>
        <content>Default content.</content>
    </fsmoutput>
    <fsminput>
    </fsminput>
</fsmstate>
"""

Plant_DEFAULT_CONTENT = """\
<fsmstate>
    <fsmcurrentstate>Plant</fsmcurrentstate>
    <fsmurl>/FSM/Test/Tmp1/</fsmurl>
    <fsmstack></fsmstack>
    <fsmoutput>
        <content>Default content.</content>
    </fsmoutput>
    <fsminput>
        <arg1>[none]</arg1>
        <arg2>[none]</arg2>
    </fsminput>
</fsmstate>
"""

Fruit_DEFAULT_CONTENT = """\
<fsmstate>
    <fsmcurrentstate>Fruit</fsmcurrentstate>
    <fsmurl>/FSM/Test/Tmp1/</fsmurl>
    <fsmstack></fsmstack>
    <fsmoutput>
        <content>Default content.</content>
    </fsmoutput>
    <fsminput>
    </fsminput>
</fsmstate>
"""

Vegetable_DEFAULT_CONTENT = """\
<fsmstate>
    <fsmcurrentstate>Vegetable</fsmcurrentstate>
    <fsmurl>/FSM/Test/Tmp1/</fsmurl>
    <fsmstack></fsmstack>
    <fsmoutput>
        <content>Default content.</content>
    </fsmoutput>
    <fsminput>
    </fsminput>
</fsmstate>
"""

Continue_DEFAULT_CONTENT = """\
<fsmstate>
    <fsmcurrentstate>Continue</fsmcurrentstate>
    <fsmurl>/FSM/Test/Tmp1/</fsmurl>
    <fsmstack></fsmstack>
    <fsmoutput>
        <content>Default content.</content>
    </fsmoutput>
    <fsminput>
        <arg1>[none]</arg1>
    </fsminput>
</fsmstate>
"""

Finish_DEFAULT_CONTENT = """\
<fsmstate>
    <fsmcurrentstate>Finish</fsmcurrentstate>
    <fsmurl>/FSM/Test/Tmp1/</fsmurl>
    <fsmstack></fsmstack>
    <fsmoutput>
        <content>Default content.</content>
    </fsmoutput>
    <fsminput>
    </fsminput>
</fsmstate>
"""


#
# Driver for command-line handler.
#   Implements commands "submit", "quit", "help", ...
#   Use "?" to get help from command-line.
#
class RestCmd(cmd.Cmd):
    prompt = '>>> '
    intro = "Type '?' for help."
    def __init__(self):
        cmd.Cmd.__init__(self)
        self.doc = Startsub.parseString(Start_DEFAULT_CONTENT)
        self.currentStateName = ""
        self.host = 'warbler:8081'
        self.url = self.doc.getFsmurl()

    def do_submit(self, line):
        headers = {'Accept': 'text/xml', 'Content-type': 'text/xml'}
        args = line.split()
        state = ''
        if len(args) > 0:
            arg1 = args[0]
            self.doc.getFsminput().setArg1(arg1)
        contentStream = StringIO.StringIO()
        self.doc.export(contentStream, 0)
        content = contentStream.getvalue()
        contentStream.close()
        print 'host: "%s"  url: "%s"' % (self.host, self.url)
        print 'content submitted:\n', content
        status, content = self.request_http('POST', self.host, self.url, \
            content, headers)
        print 'status: %d' % status
        if status == 200:
            stateName = self.getStateName(content)
            parser = StateParserDict[stateName]
            self.doc = parser.parseString(content)
            print 'content received:\n', content
        else:
            print '*** Error'
            print 'status:', status
            print 'content:', content

    def do_help(self, line):
        print HELP_TEXT

    def do_quit(self, line):
        sys.exit(1)

    def emptyline(self):
        print "Enter a command or type '?' for help."

    def request_http(self, function, host, url, params, headers):
        try:
            conn = httplib.HTTPConnection(host)
            req = conn.request(function, url, params, headers)
        except socket.error:
            print "Can't connect to server: %s" % host
            return
        res = conn.getresponse()
        status = res.status
        content = None
        if status == 200:
            content = res.read()
        conn.close()
        return (status, content)

    def getStateName(self, content):
        mo = RE1.search(content)
        stateName = mo.group(1)
        print 'stateName: "%s"' % stateName
        return stateName


USAGE_TEXT = """
Usage: python example1client.py
"""

def usage():
    print USAGE_TEXT
    sys.exit(-1)


def main():
    args = sys.argv[1:]
    if len(args) != 0:
        usage()
    interp = RestCmd()
    interp.cmdloop()


if __name__ == '__main__':
    main()
    #import pdb
    #pdb.run('main()')

