#!/usr/bin/env python

## LICENSE

## Copyright (c) 2003 Dave Kuhlman

## Permission is hereby granted, free of charge, to any person obtaining
## a copy of this software and associated documentation files (the
## "Software"), to deal in the Software without restriction, including
## without limitation the rights to use, copy, modify, merge, publish,
## distribute, sublicense, and/or sell copies of the Software, and to
## permit persons to whom the Software is furnished to do so, subject to
## the following conditions:

## The above copyright notice and this permission notice shall be
## included in all copies or substantial portions of the Software.

## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
## EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
## MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
## IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
## CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
## TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
## SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


import sys, os
import getopt
import fsmappgen
import zipfile
import generateDS

#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://www-hep.colorado.edu/~fperez/ipython.
#
## from IPython.Shell import IPythonShellEmbed
## IPShell = IPythonShellEmbed(['-nosep'],
##     banner = 'Entering interpreter.  Ctrl-D to exit.',
##     exit_msg = 'Leaving Interpreter.')

# Use the following line where and when you want to drop into the
# IPython shell:
#    IPShell(vars(), '<a msg>')



def generate(inFileName, outName, app, gui, schema, zip):
    doc = fsmappgen.getDoc(inFileName)
    if app:
        # Use None for stateModule arg to generate one import for each state.
        fsmappgen.genPackageClass(inFileName, outName, 'states.py', doc)
    if gui:
        fsmappgen.genWxg(inFileName, outName, doc)
    if schema:
        fsmappgen.genXsd(inFileName, outName, doc)
        for state in doc.stateIterator():
            name = '%s%s%s.xsd' % (outName, os.sep, state.getName())
            supName = '%s%s%ssup.py' % (outName, os.sep, state.getName())
            subName = '%s%s%ssub.py' % (outName, os.sep, state.getName())
            supModule = '%ssup' % state.getName()
            generateDS.parseAndGenerate(supName, subName, '', name, supModule)
    if zip:
        outZipName = '%s.zip' % outName
        outZip = zipfile.PyZipFile(outZipName, 'w', zipfile.ZIP_DEFLATED)
        #outZip = zipfile.PyZipFile(outZipName, 'w', zipfile.ZIP_STORED)
        if app:
            outZip.writepy(outName)
            for state in doc.stateIterator():
                name = '%s%s%s.py' % (outName, os.sep, state.getName())
                outZip.write(name)
            name = '%s%s%s.py' % (outName, os.sep, '__init__')
            outZip.write(name)
            name = '%s%s%s.py' % (outName, os.sep, 'states')
            outZip.write(name)
        if gui:
            name = '%s%sgui.wxg' % (outName, os.sep)
            outZip.write(name)
        if schema:
            for state in doc.stateIterator():
                name = '%s%s%s.xsd' % (outName, os.sep, state.getName())
                outZip.write(name)
                name = '%s%s%ssup.py' % (outName, os.sep, state.getName())
                outZip.write(name)
                name = '%s%s%ssub.py' % (outName, os.sep, state.getName())
                outZip.write(name)
        outZip.close()


USAGE_TEXT = """
fsmGenerate -- Generate Quixote application skeleton, wxGlade GUI
    definition, and X Schema definitions for FSM REST Web application.
Usage:
    python fsmGenerate.py [options] <in_file_name> <out_name>
Options:
    -h, --help      Display this help message.
    -a, --app       Generate Quixote application skeleton.
    -g, --gui       Generate .wxg file for client-side GUI.
    -s, --schema    Generate .xsd X Schema files for XML interchange docs.
    -z, --zip       Zip into PyZipFile.
Example:
    python -a -g -s -z fsmGenerate.py myapp1
"""

def usage():
    print USAGE_TEXT
    sys.exit(-1)


def main():
    args = sys.argv[1:]
    try:
        opts, args = getopt.getopt(args, 'hagsz',\
            ['help', 'app', 'gui', 'schema', 'zip'])
    except:
        usage()
    app = 0
    gui = 0
    schema = 0
    zip = 0
    for opt, val in opts:
        if opt in ('-h', '--help'):
            usage()
        elif opt in ('-a', '--app'):
            app = 1
        elif opt in ('-g', '--gui'):
            gui = 1
        elif opt in ('-s', '--schema'):
            schema = 1
        elif opt in ('-z', '--zip'):
            zip = 1
    if len(args) != 2:
        usage()
    inFileName = args[0]
    outName = args[1]
    generate(inFileName, outName, app, gui, schema, zip)


if __name__ == '__main__':
    main()
    #import pdb
    #pdb.run('main()')


