#!/usr/bin/env python

import sys
import cmd
import httplib, socket
import rtnstatesub
import StringIO


HELP_TEXT = """\
Commands:
    submit [ <arg1> ]            -- Submit a request.
    quit                         -- Exit.
    help                         -- Show this help.
"""

DEFAULT_CONTENT = """\
<fsmstate>
    <fsmcurrentstate>Start</fsmcurrentstate>
    <fsmurl>/FSM/example6/</fsmurl>
    <fsmstack></fsmstack>
    <fsmoutput>
        <content>Default content.</content>
    </fsmoutput>
    <fsminput>
        <arg1>[none]</arg1>
        <arg2></arg2>
    </fsminput>
</fsmstate>
"""


class RestCmd(cmd.Cmd):
    prompt = '>>> '
    intro = "Type '?' for help."
    def __init__(self):
        cmd.Cmd.__init__(self)
        self.doc = rtnstatesub.parseString(DEFAULT_CONTENT)

    def do_submit(self, line):
        host = 'warbler:8081'
        url = self.doc.getFsmurl()
        headers = {'Accept': 'text/xml', 'Content-type': 'text/xml'}
        args = line.split()
        state = ''
        arg1 = ''
        if len(args) > 0:
            arg1 = args[0]
        self.doc.getFsminput().setArg1(arg1)
        #self.doc.setFsmcurrentstate(state)
        contentStream = StringIO.StringIO()
        self.doc.export(contentStream, 0)
        content = contentStream.getvalue()
        contentStream.close()
        print 'url: %s' % url
        print 'content sent:\n', content
        status, content = self.request_http('POST', host, url, \
            content, headers)
        print 'status: %d' % status
        if status == 200:
            self.doc = rtnstatesub.parseString(content)
            print 'content received:\n', content

    def do_help(self, line):
        print HELP_TEXT

    def do_quit(self, line):
        sys.exit(1)

    def emptyline(self):
        print "Enter a command or type '?' for help."

    def request_http(self, function, host, url, params, headers):
        try:
            conn = httplib.HTTPConnection(host)
            req = conn.request(function, url, params, headers)
        except socket.error:
            print "Can't connect to server: %s" % host
            return
        res = conn.getresponse()
        status = res.status
        content = None
        if status == 200:
            content = res.read()
        conn.close()
        return (status, content)



USAGE_TEXT = """
Usage: python example1client.py
"""

def usage():
    print USAGE_TEXT
    sys.exit(-1)


def main():
    args = sys.argv[1:]
    if len(args) != 0:
        usage()
    interp = RestCmd()
    interp.cmdloop()


if __name__ == '__main__':
    main()
    #import pdb
    #pdb.run('main()')



