#!/usr/bin/env python

import sys
import getopt
from xml.dom import minidom
from xml.dom import Node
#import yaml

#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://www-hep.colorado.edu/~fperez/ipython.
#
#from IPython.Shell import IPythonShellEmbed
#IPShell = IPythonShellEmbed('-nosep',
#    banner = 'Entering interpreter.  Ctrl-D to exit.',
#    exit_msg = 'Leaving Interpreter.')

# Use the following line where and when you want to drop into the
# IPython shell:
#    IPShell(vars(), '<a msg>')

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')


#
# Data representation classes.
#

class fsm:
    subclass = None
    def __init__(self, name='', lastmodified='', description='', currentstate='', startstate='', endstates=None, states=None):
        self.name = name
        self.lastmodified = lastmodified
        self.description = description
        self.currentstate = currentstate
        self.startstate = startstate
        self.endstates = endstates
        if states is None:
            self.states = []
        else:
            self.states = states
    def factory(*args):
        if fsm.subclass:
            return apply(fsm.subclass, args)
        else:
            return apply(fsm, args)
    factory = staticmethod(factory)
    def getName(self): return self.name
    def setName(self, name): self.name = name
    def getLastmodified(self): return self.lastmodified
    def setLastmodified(self, lastmodified): self.lastmodified = lastmodified
    def getDescription(self): return self.description
    def setDescription(self, description): self.description = description
    def getCurrentstate(self): return self.currentstate
    def setCurrentstate(self, currentstate): self.currentstate = currentstate
    def getStartstate(self): return self.startstate
    def setStartstate(self, startstate): self.startstate = startstate
    def getEndstates(self): return self.endstates
    def setEndstates(self, endstates): self.endstates = endstates
    def getStates(self): return self.states
    def addStates(self, states): self.states.append(states)
    def export(self, outfile, level):
        showIndent(outfile, level)
        outfile.write('<fsm>\n')
        level += 1
        showIndent(outfile, level)
        outfile.write('<name>%s</name>\n' % self.getName())
        showIndent(outfile, level)
        outfile.write('<lastmodified>%s</lastmodified>\n' % self.getLastmodified())
        showIndent(outfile, level)
        outfile.write('<description>%s</description>\n' % self.getDescription())
        showIndent(outfile, level)
        outfile.write('<currentstate>%s</currentstate>\n' % self.getCurrentstate())
        showIndent(outfile, level)
        outfile.write('<startstate>%s</startstate>\n' % self.getStartstate())
        if self.endstates:
            self.endstates.export(outfile, level)
        for states in self.states:
            states.export(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('</fsm>\n')
    def build(self, node_):
        attrs = node_.attributes
        for child in node_.childNodes:
            if child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'name':
                name = ''
                for text_ in child.childNodes:
                    name += text_.nodeValue
                self.name = name
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'lastmodified':
                lastmodified = ''
                for text_ in child.childNodes:
                    lastmodified += text_.nodeValue
                self.lastmodified = lastmodified
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'description':
                description = ''
                for text_ in child.childNodes:
                    description += text_.nodeValue
                self.description = description
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'currentstate':
                currentstate = ''
                for text_ in child.childNodes:
                    currentstate += text_.nodeValue
                self.currentstate = currentstate
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'startstate':
                startstate = ''
                for text_ in child.childNodes:
                    startstate += text_.nodeValue
                self.startstate = startstate
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'endstates':
                obj = endstates.factory()
                obj.build(child)
                self.setEndstates(obj)
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'state':
                obj = state.factory()
                obj.build(child)
                self.states.append(obj)
# end class fsm


class state:
    subclass = None
    def __init__(self, name='', pagename='', transitions=None, inputs=None):
        self.name = name
        self.pagename = pagename
        if transitions is None:
            self.transitions = []
        else:
            self.transitions = transitions
        self.inputs = inputs
    def factory(*args):
        if state.subclass:
            return apply(state.subclass, args)
        else:
            return apply(state, args)
    factory = staticmethod(factory)
    def getName(self): return self.name
    def setName(self, name): self.name = name
    def getPagename(self): return self.pagename
    def setPagename(self, pagename): self.pagename = pagename
    def getTransitions(self): return self.transitions
    def addTransitions(self, transitions): self.transitions.append(transitions)
    def getInputs(self): return self.inputs
    def setInputs(self, inputs): self.inputs = inputs
    def export(self, outfile, level):
        showIndent(outfile, level)
        outfile.write('<state>\n')
        level += 1
        showIndent(outfile, level)
        outfile.write('<name>%s</name>\n' % self.getName())
        showIndent(outfile, level)
        outfile.write('<pagename>%s</pagename>\n' % self.getPagename())
        for transitions in self.transitions:
            transitions.export(outfile, level)
        if self.inputs:
            self.inputs.export(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('</state>\n')
    def build(self, node_):
        attrs = node_.attributes
        for child in node_.childNodes:
            if child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'name':
                name = ''
                for text_ in child.childNodes:
                    name += text_.nodeValue
                self.name = name
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'pagename':
                pagename = ''
                for text_ in child.childNodes:
                    pagename += text_.nodeValue
                self.pagename = pagename
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'transition':
                obj = transition.factory()
                obj.build(child)
                self.transitions.append(obj)
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'inputs':
                obj = inputs.factory()
                obj.build(child)
                self.setInputs(obj)
# end class state


class transition:
    subclass = None
    def __init__(self, id='', condition='', action='', newstate=''):
        self.id = id
        self.condition = condition
        self.action = action
        self.newstate = newstate
    def factory(*args):
        if transition.subclass:
            return apply(transition.subclass, args)
        else:
            return apply(transition, args)
    factory = staticmethod(factory)
    def getId(self): return self.id
    def setId(self, id): self.id = id
    def getCondition(self): return self.condition
    def setCondition(self, condition): self.condition = condition
    def getAction(self): return self.action
    def setAction(self, action): self.action = action
    def getNewstate(self): return self.newstate
    def setNewstate(self, newstate): self.newstate = newstate
    def export(self, outfile, level):
        showIndent(outfile, level)
        outfile.write('<transition>\n')
        level += 1
        showIndent(outfile, level)
        outfile.write('<id>%s</id>\n' % self.getId())
        showIndent(outfile, level)
        outfile.write('<condition>%s</condition>\n' % self.getCondition())
        showIndent(outfile, level)
        outfile.write('<action>%s</action>\n' % self.getAction())
        showIndent(outfile, level)
        outfile.write('<newstate>%s</newstate>\n' % self.getNewstate())
        level -= 1
        showIndent(outfile, level)
        outfile.write('</transition>\n')
    def build(self, node_):
        attrs = node_.attributes
        for child in node_.childNodes:
            if child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'id':
                id = ''
                for text_ in child.childNodes:
                    id += text_.nodeValue
                self.id = id
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'condition':
                condition = ''
                for text_ in child.childNodes:
                    condition += text_.nodeValue
                self.condition = condition
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'action':
                action = ''
                for text_ in child.childNodes:
                    action += text_.nodeValue
                self.action = action
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'newstate':
                newstate = ''
                for text_ in child.childNodes:
                    newstate += text_.nodeValue
                self.newstate = newstate
# end class transition


class endstates:
    subclass = None
    def __init__(self, endstate=None):
        if endstate is None:
            self.endstate = []
        else:
            self.endstate = endstate
    def factory(*args):
        if endstates.subclass:
            return apply(endstates.subclass, args)
        else:
            return apply(endstates, args)
    factory = staticmethod(factory)
    def getEndstate(self): return self.endstate
    def addEndstate(self, endstate): self.endstate.append(endstate)
    def export(self, outfile, level):
        showIndent(outfile, level)
        outfile.write('<endstates>\n')
        level += 1
        for endstate in self.endstate:
            showIndent(outfile, level)
            outfile.write('<endstate>%s</endstate>\n' % endstate)
        level -= 1
        showIndent(outfile, level)
        outfile.write('</endstates>\n')
    def build(self, node_):
        attrs = node_.attributes
        for child in node_.childNodes:
            if child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'endstate':
                endstate = ''
                for text_ in child.childNodes:
                    endstate += text_.nodeValue
                self.endstate.append(endstate)
# end class endstates


class inputs:
    subclass = None
    def __init__(self, input=None):
        if input is None:
            self.input = []
        else:
            self.input = input
    def factory(*args):
        if inputs.subclass:
            return apply(inputs.subclass, args)
        else:
            return apply(inputs, args)
    factory = staticmethod(factory)
    def getInput(self): return self.input
    def addInput(self, input): self.input.append(input)
    def export(self, outfile, level):
        showIndent(outfile, level)
        outfile.write('<inputs>\n')
        level += 1
        for input in self.input:
            input.export(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('</inputs>\n')
    def build(self, node_):
        attrs = node_.attributes
        for child in node_.childNodes:
            if child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'input':
                obj = input.factory()
                obj.build(child)
                self.input.append(obj)
# end class inputs


class input:
    subclass = None
    def __init__(self, name='', label='', defaultvalue='', controltype='', tooltip=''):
        self.name = name
        self.label = label
        self.defaultvalue = defaultvalue
        self.controltype = controltype
        self.tooltip = tooltip
    def factory(*args):
        if input.subclass:
            return apply(input.subclass, args)
        else:
            return apply(input, args)
    factory = staticmethod(factory)
    def getName(self): return self.name
    def setName(self, name): self.name = name
    def getLabel(self): return self.label
    def setLabel(self, label): self.label = label
    def getDefaultvalue(self): return self.defaultvalue
    def setDefaultvalue(self, defaultvalue): self.defaultvalue = defaultvalue
    def getControltype(self): return self.controltype
    def setControltype(self, controltype): self.controltype = controltype
    def getTooltip(self): return self.tooltip
    def setTooltip(self, tooltip): self.tooltip = tooltip
    def export(self, outfile, level):
        showIndent(outfile, level)
        outfile.write('<input>\n')
        level += 1
        showIndent(outfile, level)
        outfile.write('<name>%s</name>\n' % self.getName())
        showIndent(outfile, level)
        outfile.write('<label>%s</label>\n' % self.getLabel())
        showIndent(outfile, level)
        outfile.write('<defaultvalue>%s</defaultvalue>\n' % self.getDefaultvalue())
        showIndent(outfile, level)
        outfile.write('<controltype>%s</controltype>\n' % self.getControltype())
        showIndent(outfile, level)
        outfile.write('<tooltip>%s</tooltip>\n' % self.getTooltip())
        level -= 1
        showIndent(outfile, level)
        outfile.write('</input>\n')
    def build(self, node_):
        attrs = node_.attributes
        for child in node_.childNodes:
            if child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'name':
                name = ''
                for text_ in child.childNodes:
                    name += text_.nodeValue
                self.name = name
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'label':
                label = ''
                for text_ in child.childNodes:
                    label += text_.nodeValue
                self.label = label
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'defaultvalue':
                defaultvalue = ''
                for text_ in child.childNodes:
                    defaultvalue += text_.nodeValue
                self.defaultvalue = defaultvalue
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'controltype':
                controltype = ''
                for text_ in child.childNodes:
                    controltype += text_.nodeValue
                self.controltype = controltype
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'tooltip':
                tooltip = ''
                for text_ in child.childNodes:
                    tooltip += text_.nodeValue
                self.tooltip = tooltip
# end class input


USAGE_TEXT = """
Usage: python <Parser>.py <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(-1)


def parse(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.childNodes[0]
    rootObj = fsm.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('?xml version="1.0" ?>')
    rootObj.export(sys.stdout, 0)
    return rootObj


def parseString(inString):
    doc = minidom.parseString(inString)
    rootNode = doc.childNodes[0]
    rootObj = fsm.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0)
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) != 1:
        usage()
    parse(args[0])


if __name__ == '__main__':
    main()
    #import pdb
    #pdb.run('main()')

