#!/usr/bin/env python

import sys
from xml.dom import minidom

import fsmsup as supermod

class fsmSub(supermod.fsm):
    def __init__(self, name='', lastmodified='', description='', currentstate='', startstate='', endstates=None, states=None):
        supermod.fsm.__init__(self, name, lastmodified, description, currentstate, startstate, endstates, states)
supermod.fsm.subclass = fsmSub
# end class fsmSub


class stateSub(supermod.state):
    def __init__(self, name='', pagename='', transitions=None):
        supermod.state.__init__(self, name, pagename, transitions)
supermod.state.subclass = stateSub
# end class stateSub


class transitionSub(supermod.transition):
    def __init__(self, button='', inputs=None, action=None, newstate=''):
        supermod.transition.__init__(self, button, inputs, action, newstate)
supermod.transition.subclass = transitionSub
# end class transitionSub


class actionSub(supermod.action):
    def __init__(self, source='', compiled=''):
        supermod.action.__init__(self, source, compiled)
supermod.action.subclass = actionSub
# end class actionSub


class endstatesSub(supermod.endstates):
    def __init__(self, endstate=None):
        supermod.endstates.__init__(self, endstate)
supermod.endstates.subclass = endstatesSub
# end class endstatesSub


class inputsSub(supermod.inputs):
    def __init__(self, input=None):
        supermod.inputs.__init__(self, input)
supermod.inputs.subclass = inputsSub
# end class inputsSub


class inputSub(supermod.input):
    def __init__(self, name='', value='', condition=''):
        supermod.input.__init__(self, name, value, condition)
supermod.input.subclass = inputSub
# end class inputSub



def parse(inFilename):
    doc = minidom.parse(inFilename)
    rootNode = doc.childNodes[0]
    rootObj = supermod.fsm.factory()
    rootObj.build(rootNode)
    return rootObj


def parseString(inString):
    doc = minidom.parseString(inString)
    rootNode = doc.childNodes[0]
    rootObj = supermod.fsm.factory()
    rootObj.build(rootNode)
    return rootObj


def genModulePackage(root, args):
    if len(args) != 1:
        usage()
    return

def genClassModule(root, args):
    if len(args) != 1:
        usage()
    outFileName = args[0]
    outFile = file(outFileName, 'w')
    print 'root:', str(root)

def genFunctionModule(root, args):
    if len(args) != 1:
        usage()
    return

def genMethodClass(root, args):
    if len(args) != 1:
        usage()
    return



USAGE_TEXT = """
Usage: python generateQuixoteFSM.py <infilename>
"""

def usage():
    print USAGE_TEXT
    sys.exit(-1)


def main():
    args = sys.argv[1:]
    print '*** args:', args
    try:
        opts, args = getopt.getopt(args, '', ['module-package',
            'class-module', 'function-module', 'method-class'])
    except getopt.GetoptError:
        usage()
    print '(opts, args):', opts, args
    if len(args) != 1:
        usage()
    infilename = args[0]
    root = parse(infilename)
    sys.stdout.write('?xml version="1.0" ?>\n')
    root.export(sys.stdout, 0)
    for opt, arg in opts:
        if opt == 'module-package':
            genModulePackage(root, args)
        elif opt == 'class-module':
            genClassModule(root, args)
        elif opt == 'function-module':
            genFunctionModule(root, args)
        elif opt == 'method-class':
            genMethodClass(root, args)
        else:
            usage()


if __name__ == '__main__':
    main()
    #import pdb
    #pdb.run('main()')


