#!/usr/bin/env python

import sys
import getopt
from xml.dom import minidom
from xml.dom import Node
#import yaml

#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://www-hep.colorado.edu/~fperez/ipython.
#
#from IPython.Shell import IPythonShellEmbed
#IPShell = IPythonShellEmbed('-nosep',
#    banner = 'Entering interpreter.  Ctrl-D to exit.',
#    exit_msg = 'Leaving Interpreter.')

# Use the following line where and when you want to drop into the
# IPython shell:
#    IPShell(vars(), '<a msg>')

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')


#
# Data representation classes.
#

class fsmstate:
    subclass = None
    def __init__(self, fsmcurrentstate='', fsmurl='', fsmstack='', fsmoutput=None, fsminput=None):
        self.fsmcurrentstate = fsmcurrentstate
        self.fsmurl = fsmurl
        self.fsmstack = fsmstack
        self.fsmoutput = fsmoutput
        self.fsminput = fsminput
    def factory(*args):
        if fsmstate.subclass:
            return apply(fsmstate.subclass, args)
        else:
            return apply(fsmstate, args)
    factory = staticmethod(factory)
    def getFsmcurrentstate(self): return self.fsmcurrentstate
    def setFsmcurrentstate(self, fsmcurrentstate): self.fsmcurrentstate = fsmcurrentstate
    def getFsmurl(self): return self.fsmurl
    def setFsmurl(self, fsmurl): self.fsmurl = fsmurl
    def getFsmstack(self): return self.fsmstack
    def setFsmstack(self, fsmstack): self.fsmstack = fsmstack
    def getFsmoutput(self): return self.fsmoutput
    def setFsmoutput(self, fsmoutput): self.fsmoutput = fsmoutput
    def getFsminput(self): return self.fsminput
    def setFsminput(self, fsminput): self.fsminput = fsminput
    def export(self, outfile, level):
        showIndent(outfile, level)
        outfile.write('<fsmstate>\n')
        level += 1
        showIndent(outfile, level)
        outfile.write('<fsmcurrentstate>%s</fsmcurrentstate>\n' % self.getFsmcurrentstate())
        showIndent(outfile, level)
        outfile.write('<fsmurl>%s</fsmurl>\n' % self.getFsmurl())
        showIndent(outfile, level)
        outfile.write('<fsmstack>%s</fsmstack>\n' % self.getFsmstack())
        if self.fsmoutput:
            self.fsmoutput.export(outfile, level)
        if self.fsminput:
            self.fsminput.export(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('</fsmstate>\n')
    def build(self, node_):
        attrs = node_.attributes
        for child in node_.childNodes:
            if child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'fsmcurrentstate':
                fsmcurrentstate = ''
                for text_ in child.childNodes:
                    fsmcurrentstate += text_.nodeValue
                self.fsmcurrentstate = fsmcurrentstate
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'fsmurl':
                fsmurl = ''
                for text_ in child.childNodes:
                    fsmurl += text_.nodeValue
                self.fsmurl = fsmurl
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'fsmstack':
                fsmstack = ''
                for text_ in child.childNodes:
                    fsmstack += text_.nodeValue
                self.fsmstack = fsmstack
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'fsmoutput':
                obj = fsmoutput.factory()
                obj.build(child)
                self.setFsmoutput(obj)
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'fsminput':
                obj = fsminput.factory()
                obj.build(child)
                self.setFsminput(obj)
# end class fsmstate


class fsmoutput:
    subclass = None
    def __init__(self, content=''):
        self.content = content
    def factory(*args):
        if fsmoutput.subclass:
            return apply(fsmoutput.subclass, args)
        else:
            return apply(fsmoutput, args)
    factory = staticmethod(factory)
    def getContent(self): return self.content
    def setContent(self, content): self.content = content
    def export(self, outfile, level):
        showIndent(outfile, level)
        outfile.write('<fsmoutput>\n')
        level += 1
        showIndent(outfile, level)
        outfile.write('<content>%s</content>\n' % self.getContent())
        level -= 1
        showIndent(outfile, level)
        outfile.write('</fsmoutput>\n')
    def build(self, node_):
        attrs = node_.attributes
        for child in node_.childNodes:
            if child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'content':
                content = ''
                for text_ in child.childNodes:
                    content += text_.nodeValue
                self.content = content
# end class fsmoutput


class fsminput:
    subclass = None
    def __init__(self, arg1='', arg2=''):
        self.arg1 = arg1
        self.arg2 = arg2
    def factory(*args):
        if fsminput.subclass:
            return apply(fsminput.subclass, args)
        else:
            return apply(fsminput, args)
    factory = staticmethod(factory)
    def getArg1(self): return self.arg1
    def setArg1(self, arg1): self.arg1 = arg1
    def getArg2(self): return self.arg2
    def setArg2(self, arg2): self.arg2 = arg2
    def export(self, outfile, level):
        showIndent(outfile, level)
        outfile.write('<fsminput>\n')
        level += 1
        showIndent(outfile, level)
        outfile.write('<arg1>%s</arg1>\n' % self.getArg1())
        showIndent(outfile, level)
        outfile.write('<arg2>%s</arg2>\n' % self.getArg2())
        level -= 1
        showIndent(outfile, level)
        outfile.write('</fsminput>\n')
    def build(self, node_):
        attrs = node_.attributes
        for child in node_.childNodes:
            if child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'arg1':
                arg1 = ''
                for text_ in child.childNodes:
                    arg1 += text_.nodeValue
                self.arg1 = arg1
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'arg2':
                arg2 = ''
                for text_ in child.childNodes:
                    arg2 += text_.nodeValue
                self.arg2 = arg2
# end class fsminput


USAGE_TEXT = """
Usage: python <Parser>.py <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(-1)


def parse(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.childNodes[0]
    rootObj = fsmstate.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('?xml version="1.0" ?>')
    rootObj.export(sys.stdout, 0)
    return rootObj


def parseString(inString):
    doc = minidom.parseString(inString)
    rootNode = doc.childNodes[0]
    rootObj = fsmstate.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0)
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) != 1:
        usage()
    parse(args[0])


if __name__ == '__main__':
    main()
    #import pdb
    #pdb.run('main()')

