"""
example5.py

Simple FSM example.

Structure -- A package implements the FSM.  A separate module
    implements each state.

URI -- The same URI is used for each request.  The current state is
    passed back and forth in the XML content.

Dispatching -- _q_index function parses the XML content (from the
    client, extracts the current state, and dispatches by creating
    an instance of a class in the module that implements the state
    and calling the _q_index method in the class in that module.

"""

import Ns
import statesub

# Import the state implementations.
from start import Start
from plant import Plant
from fruit import Fruit
from vegetable import Vegetable
from continuemod import Continue
from finish import Finish
from error import Error


_q_exports = []


# A dictionary that maps state names to state implementations.
StateDict = {
    'Start': Start,
    'Plant': Plant,
    'Fruit': Fruit,
    'Vegetable': Vegetable,
    'Continue': Continue,
    'Finish': Finish,
    'Error': Error
    }


def getStateDict():
    return StateDict


#
# Dispatch to the state implementation.
#
def _q_index(request):
    buf = request.stdin
    content = buf.read()
    doc = statesub.parseString(content)
    state = doc.getFsmcurrentstate()
    arg1 = doc.getFsminput().getArg1()
    cls = getStateDict().get(state, None)
    if cls:
        obj = cls(doc)
        return obj._q_index(request)
    else:
        raise TraversalError('No such state: %s' % state)



