# continue.py


from state import State


class Continue(State):
    def __init__(self, doc):
        State.__init__(self, doc)
    def _q_index(self, request):
        doc = self.doc
        arg1 = doc.getFsminput().getArg1()
        if arg1 == 'finish':
            nextState = 'Finish'
            msg = ''
        elif arg1 == 'restart':
            nextState = 'Plant'
            msg = "['fruit' or 'vegetable']"
        else:
            nextState = 'Error'
            msg = ''
        self.setXmlResponse(request)
        return """\
<fsmstate>
    <fsmcurrentstate>%s</fsmcurrentstate>
    <fsmoutput>
        <content>Continuing.</content>
    </fsmoutput>
    <fsminput>
        <arg1>%s</arg1>
        <arg2></arg2>
    </fsminput>
</fsmstate>
""" % (nextState, msg)


