#!/usr/bin/env python

import sys
from xml.dom import minidom

import statesup as supermod

class fsmstateSub(supermod.fsmstate):
    def __init__(self, fsmcurrentstate='', fsmoutput=None, fsminput=None):
        supermod.fsmstate.__init__(self, fsmcurrentstate, fsmoutput, fsminput)
supermod.fsmstate.subclass = fsmstateSub
# end class fsmstateSub


class fsmoutputSub(supermod.fsmoutput):
    def __init__(self, content=''):
        supermod.fsmoutput.__init__(self, content)
supermod.fsmoutput.subclass = fsmoutputSub
# end class fsmoutputSub


class fsminputSub(supermod.fsminput):
    def __init__(self, arg1='', arg2=''):
        supermod.fsminput.__init__(self, arg1, arg2)
supermod.fsminput.subclass = fsminputSub
# end class fsminputSub



def parse(inFilename):
    doc = minidom.parse(inFilename)
    rootNode = doc.childNodes[0]
    rootObj = supermod.fsmstate.factory()
    rootObj.build(rootNode)
    return rootObj


def parseString(inString):
    doc = minidom.parseString(inString)
    rootNode = doc.childNodes[0]
    rootObj = supermod.fsmstate.factory()
    rootObj.build(rootNode)
    return rootObj


USAGE_TEXT = """
Usage: python statesub.py <infilename>
"""

def usage():
    print USAGE_TEXT
    sys.exit(-1)


def main():
    args = sys.argv[1:]
    if len(args) != 1:
        usage()
    infilename = args[0]
    root = parse(infilename)
    sys.stdout.write('?xml version="1.0" ?>\n')
    root.export(sys.stdout, 0)


if __name__ == '__main__':
    main()
    #import pdb
    #pdb.run('main()')


