#!/usr/bin/env python

import sys, getopt
from xml.dom import minidom

import fsmsup as supermod

class fsmSub(supermod.fsm):
    def __init__(self, name='', lastmodified='', description='', currentstate='', startstate='', endstates=None, states=None):
        supermod.fsm.__init__(self, name, lastmodified, description, currentstate, startstate, endstates, states)

    def genModuleClass(self, outFile):
        for state in self.getStates():
            state.genModuleClass(outFile)

    def genModuleFunction(self, outFile):
        for state in self.getStates():
            state.genModuleFunction(outFile)

    def genStateDict(self, outFile):
        s1 = "#\n"
        outFile.write(s1)
        s1 = "# Dictionary to map state names to state implementations\n"
        outFile.write(s1)
        s1 = "#\n"
        outFile.write(s1)
        s1 = "StateDict = {\n"
        outFile.write(s1)
        for state in self.getStates():
            name = state.getName()
            s1 = "    '%s': %s,\n" % (name, name)
            outFile.write(s1)
        s1 = "    }\n\n"
        outFile.write(s1)

supermod.fsm.subclass = fsmSub
# end class fsmSub


class stateSub(supermod.state):
    def __init__(self, name='', pagename='', transitions=None):
        supermod.state.__init__(self, name, pagename, transitions)

    def genModuleClass(self, outFile):
        s1 = "class %s(State):\n" % self.getName()
        outFile.write(s1)
        s1 = "    def __init__(self, doc):\n"
        outFile.write(s1)
        s1 = "        State.__init__(self, doc)\n"
        outFile.write(s1)
        s1 = "    def _q_index(self, request):\n"
        outFile.write(s1)
        s1 = "        nextState = None\n"
        outFile.write(s1)
        for transition in self.getTransitions():
            transition.genModuleClass(outFile)
        s1 = "        self.doc.setFsmcurrentstate(nextState)\n"
        outFile.write(s1)

        s1= "        content = self.generateContent()\n"
        outFile.write(s1)
        s1= "        self.setXmlResponse(request)\n"
        outFile.write(s1)
        s1= "        return content\n"
        outFile.write(s1)
        s1 = "\n\n"
        outFile.write(s1)

    def genModuleFunction(self, outFile):
        s1 = "def %s(request, doc):\n" % self.getName()
        outFile.write(s1)
        s1 = "    nextState = None\n"
        outFile.write(s1)
        for transition in self.getTransitions():
            transition.genModuleClass(outFile)
        s1 = "    doc.setFsmcurrentstate(doc, nextState)\n"
        outFile.write(s1)
        s1= "    content = generateContent(doc)\n"
        outFile.write(s1)
        s1= "    setXmlResponse(request)\n"
        outFile.write(s1)
        s1= "    return content\n"
        outFile.write(s1)
        s1 = "\n\n"
        outFile.write(s1)

supermod.state.subclass = stateSub
# end class stateSub


class transitionSub(supermod.transition):
    def __init__(self, id='', button='', inputs=None, action=None, newstate=''):
        supermod.transition.__init__(self, id, button, inputs, action, newstate)

    def genModuleClass(self, outFile):
        inputs = None
        if self.getInputs():
            inputs = self.getInputs().getInput()
        s1 = "        # Transition %s\n" % self.getId()
        outFile.write(s1)
        #outFile.write("inputs: " + str(inputs) + "\n")
        if inputs:
            test = 'if'
            for input in inputs:
                condition = self.mapCondition(input.getCondition())
                if input.getCondition():
                    s1 = "        %s %s %s '%s':\n" % \
                        (test, input.getName(), condition, input.getValue())
                else:
                    s1 = "        %s %s:\n" % \
                        (test, input.getName())
                outFile.write(s1)
                s1 = "            nextState = '%s'\n" % self.getNewstate()
                outFile.write(s1)
                test = 'elif'
        else:
            # If there are no inputs/conditions, then set nextState unconditionally.
            s1 = "        nextState = '%s'\n" % self.getNewstate()
            outFile.write(s1)

    def mapCondition(self, inCondition):
        if inCondition == 'eq':
            outCondition = '=='
        elif inCondition == 'lt':
            outCondition = '<'
        elif inCondition == 'le':
            outCondition = '<='
        elif inCondition == 'gt':
            outCondition = '>'
        elif inCondition == 'ge':
            outCondition = '>='
        else:
            outCondition = '??'
        return outCondition


supermod.transition.subclass = transitionSub
# end class transitionSub


class actionSub(supermod.action):
    def __init__(self, source='', compiled=''):
        supermod.action.__init__(self, source, compiled)
supermod.action.subclass = actionSub
# end class actionSub


class endstatesSub(supermod.endstates):
    def __init__(self, endstate=None):
        supermod.endstates.__init__(self, endstate)
supermod.endstates.subclass = endstatesSub
# end class endstatesSub


class inputsSub(supermod.inputs):
    def __init__(self, input=None):
        supermod.inputs.__init__(self, input)

##     def genModuleClass(self, outFile):
##         inputs = self.getInput()
##         print '(inputsSub) inputs:', inputs
##         for input in inputs:
##             input.genModuleClass(outFile)

supermod.inputs.subclass = inputsSub
# end class inputsSub


class inputSub(supermod.input):
    def __init__(self, name='', value='', condition=''):
        supermod.input.__init__(self, name, value, condition)

##     def genModuleClass(self, outFile):
##         pass

supermod.input.subclass = inputSub
# end class inputSub



HEADER_module_class = """

# Import the parser and data structures for the XML interchange document.
import %s

_q_exports = []


# StateDict must be defined below after states are defined.
def getStateDict():
    return StateDict


def _q_index(request):
    buf = request.stdin
    content = buf.read()
    doc = statesub.parseString(content)
    state = doc.getFsmcurrentstate()
    arg1 = doc.getFsminput().getArg1()
    cls = getStateDict().get(state, None)
    if cls:
        obj = cls(doc)
        return obj._q_index(request)
    else:
        raise TraversalError('No such state: %%s' %% state)


#
# State implementations.
#

class State:
    def __init__(self, doc):
        self.doc = doc
    def setXmlResponse(self, request):
        response = request.response
        response.set_header('Content-type', 'text/xml; charset=iso-8859-1')
    def generateContent(self):
        contentStream = StringIO.StringIO()
        self.doc.export(contentStream, 0)
        content = contentStream.getvalue()
        contentStream.close()
        return content

"""

HEADER_module_function = """

# Import the parser and data structures for the XML interchange document.
import %s

_q_exports = []


# StateDict must be defined below after states are defined.
def getStateDict():
    return StateDict


def _q_index(request):
    buf = request.stdin
    content = buf.read()
    doc = statesub.parseString(content)
    state = doc.getFsmcurrentstate()
    arg1 = doc.getFsminput().getArg1()
    cls = getStateDict().get(state, None)
    if cls:
        obj = cls(doc)
        return obj._q_index(request)
    else:
        raise TraversalError('No such state: %%s' %% state)


#
# State implementations.
#

"""

FOOTER_module_class = """
"""

FOOTER_module_function = """
#
# Utility functions.
#

def generateContent(doc):
    contentStream = StringIO.StringIO()
    doc.export(contentStream, 0)
    content = contentStream.getvalue()
    contentStream.close()
    return content

def setXmlResponse(request):
    response = request.response
    response.set_header('Content-type', 'text/xml; charset=iso-8859-1')

"""

def genModuleClass(inFileName, outName, stateModule):
    fsm = parse(inFileName)
    outFile = file(outName, 'w')
    outFile.write(HEADER_module_class % stateModule)
    fsm.genModuleClass(outFile)
    fsm.genStateDict(outFile)
    outFile.write(FOOTER_module_class)
    outFile.close()


def genModuleFunction(inFileName, outName, stateModule):
    fsm = parse(inFileName)
    outFile = file(outName, 'w')
    outFile.write(HEADER_module_function % stateModule)
    fsm.genModuleFunction(outFile)
    fsm.genStateDict(outFile)
    outFile.write(FOOTER_module_function)
    outFile.close()


def parse(inFilename):
    doc = minidom.parse(inFilename)
    rootNode = doc.childNodes[0]
    rootObj = supermod.fsm.factory()
    rootObj.build(rootNode)
    return rootObj


def parseString(inString):
    doc = minidom.parseString(inString)
    rootNode = doc.childNodes[0]
    rootObj = supermod.fsm.factory()
    rootObj.build(rootNode)
    return rootObj


USAGE_TEXT = """
Usage: python fsmsub.py [ options ] <infilename> <outname>

Options:
    -s, --state <module>    Module implementing parser and data structures
                                for XML doc.
    -m, --mode <mode>       See below.

Modes:
    module_class            Generate Quixote/REST app.
                                Container: module  State: class
    module_function         Generate Quixote/REST app.
                                Container: module  State: function
Examples:
    python fsmsub.py -m module_class fsm1.xml app1.py
    python fsmsub.py -m module_function fsm1.xml app1.py
"""

def usage():
    print USAGE_TEXT
    sys.exit(-1)


def export():
    args = sys.argv[1:]
    if len(args) != 1:
        usage()
    infilename = args[0]
    root = parse(infilename)
    sys.stdout.write('?xml version="1.0" ?>\n')
    root.export(sys.stdout, 0)


def main():
    args = sys.argv[1:]
    #opts, args = getopt.getopt(args, 'hm:', ['help', 'mode='])
    try:
        opts, args = getopt.getopt(args, 'hm:s:', ['help', 'mode=', 'state='])
    except:
        usage()
    relink = 1
    mode = None
    stateModule = 'statesub'
    for opt, val in opts:
        if opt in ('-h', '--help'):
            usage()
        elif opt in ('-m', '--mode'):
            mode = val
        elif opt in ('-s', '--state'):
            stateModule = val
    if len(args) < 2:
        usage()
    if mode == 'module_class':
        if len(args) != 2:
            usage()
        inFileName = args[0]
        outName = args[1]
        genModuleClass(inFileName, outName, stateModule)
    elif mode == 'module_function':
        if len(args) != 2:
            usage()
        inFileName = args[0]
        outName = args[1]
        genModuleFunction(inFileName, outName, stateModule)
    else:
        usage()


if __name__ == '__main__':
    main()
    #import pdb
    #pdb.run('main()')


