
import string
from quixote.errors import TraversalError

from data import recipes

#_q_exports = ['ingredients', 'instructions']
_q_exports = []

def _q_getname(request, name):
    if name == 'ingredients':
        return Ingredients()
    elif name == 'instructions':
        return Instructions()
    else:
        raise TraversalError('No such detail: %s' % name)


class Ingredients:
    _q_exports = []
    def __init__(self):
        pass
    def show(self, request, name):
        recipe = recipes[name]
        rname = recipe['name']
        doc = [
            '<html>'
            '<head><title>Drilldown - Details - Ingredientss</title></head>',
            '<body>',
            '  <div align="center"><h1>Recipe -- %s</h1></div>' % rname,
            '  <h2>Ingredients</h2>',
            '  <ol>'
            ]
        for item in recipe['ingredients']:
            doc.append('    <li>%s</li>' % item)
        doc.append('  </ol>')
        doc.append('  <hr>')
        doc.append('  <p><a href="/DrillDown/recipelist">Return to recipe list</a></p>')
        doc.append('  <p><a href="/DrillDown/">Return to index</a></p>')
        doc.append('</body>')
        doc.append('</html>')
        content = string.join(doc, '\n')
        return content
    def _q_getname(self, request, name):
        if not recipes.has_key(name):
            raise TraversalError('No such recipe: %s' % name)
        return self.show(request, name)


class Instructions:
    _q_exports = []
    def __init__(self):
        pass
    def show(self, request, name):
        recipe = recipes[name]
        rname = recipe['name']
        doc = [
            '<html>'
            '<head><title>Drilldown - Details - Instructions</title></head>',
            '<body>'
            '<div align="center"><h1>Recipe -- %s</h1></div>' % rname,
            '<h2>Instructions</h2>',
            '<ol>'
            ]
        for item in recipe['instructions']:
            doc.append('  <li>%s</li>' % item)
        doc.append('</ol>')
        doc.append('  <hr>')
        doc.append('  <p><a href="/DrillDown/recipelist">Return to recipe list</a></p>')
        doc.append('  <p><a href="/DrillDown/">Return to index</a></p>')
        doc.append('</body>')
        doc.append('</html>')
        content = string.join(doc, '\n')
        return content
    def _q_getname(self, request, name):
        if not recipes.has_key(name):
            raise TraversalError('No such recipe: %s' % name)
        return self.show(request, name)
        

